/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics;

import com.aniways.IconData;
import com.aniways.analytics.AniwaysAnalyticsReporter;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.analytics.models.EventProperties;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.quick.action.ContextualPopupStateHolder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;

public class ContextualPopupStateReporter {
    public static void reportScreenEvent(ContextualPopupStateHolder popupStateHolder, long closingTime) {
        Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        EventProperties props = new EventProperties();
        props.put("category", "screen");
        props.put("action", "popup");
        props.put("page_index", popupStateHolder.pageIndex);
        props.put("page_index_out_of", popupStateHolder.totalPages);
        props.put("state", popupStateHolder.isInRevealMoreState ? "reveal more" : "regular");
        props.put("asset_type", (Object)popupStateHolder.currentAssetType);
        props.put("content_lines", popupStateHolder.contentLines);
        props.put("entry_method", popupStateHolder.entryMethod);
        props.put("exit_method", popupStateHolder.exitMethod);
        props.put("previous_screen", popupStateHolder.previousScreen);
        props.put("next_screen", popupStateHolder.nextScreen);
        props.put("popup_origin", popupStateHolder.popupOrigin.getStringRepresentation());
        props.put("time_open", closingTime - popupStateHolder.popupOpenStartTime);
        props.put("phrase", popupStateHolder.phraseName);
        ContextualPopupStateReporter.addProviderToContentIds(popupStateHolder, props);
        AniwaysAnalyticsReporter.track(props, timestamp);
    }

    private static void addProviderToContentIds(ContextualPopupStateHolder popupStateHolder, EventProperties props) {
        if (popupStateHolder.popupAssetInfos == null || popupStateHolder.popupAssetInfos.isEmpty()) {
            return;
        }
        EasyJSONObject providerNameToIds = new EasyJSONObject();
        HashMap map = new HashMap();
        for (IAniwaysAssetInfo iAniwaysAssetInfo : popupStateHolder.popupAssetInfos) {
            IconData iconData = iAniwaysAssetInfo.getIconData();
            if (iconData == null) continue;
            String key = iconData.assetProvider.toString().toLowerCase();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((ArrayList)map.get(key)).add(iconData.getAssetIdFromProvider());
        }
        for (Map.Entry entry : map.entrySet()) {
            providerNameToIds.put((String)entry.getKey(), new JSONArray((Collection)entry.getValue()));
        }
        props.put("content_ids", providerNameToIds);
    }
}

