/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics;

import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.AniwaysAnalyticsReporter;
import com.aniways.analytics.EventReporterCommonMedhods;
import com.aniways.analytics.models.EventProperties;
import com.aniways.analytics.utils.ContextualEventData;
import com.aniways.data.AnimatedGifPhraseAssetInfoBuilder;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.EmoticonsPhraseAssetBuilder;
import com.aniways.data.Phrase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class ContextualEventReporter {
    private static final List<AnalyticsReporter.PhrasesEventAction> requiredMessageIdEvents = Arrays.asList(AnalyticsReporter.PhrasesEventAction.suggested, AnalyticsReporter.PhrasesEventAction.tapped, AnalyticsReporter.PhrasesEventAction.selected, AnalyticsReporter.PhrasesEventAction.sent, AnalyticsReporter.PhrasesEventAction.sentExternalContent);

    public static void reportContextualEvent(ContextualEventData contextualEventData) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        EventProperties props = new EventProperties();
        props.put("category", "contextual");
        props.put("action", contextualEventData.action.getEventReportName());
        if (requiredMessageIdEvents.contains((Object)contextualEventData.action)) {
            props.put("message_id", contextualEventData.messageId);
        }
        if (contextualEventData.phrase != null) {
            props.put("phrase_name", contextualEventData.phrase.getName());
            props.put("part_to_replace", contextualEventData.phrase.getPartToReplace());
        }
        if (ContextualEventReporter.isReportIndexInMessageRequired(contextualEventData)) {
            props.put("index_in_message", contextualEventData.indexInMessage);
        }
        if (ContextualEventReporter.isReportAssetsRequired(contextualEventData)) {
            ContextualEventReporter.addAssetsReportToProps(props, contextualEventData);
        }
        if (ContextualEventReporter.isReportPhraseLanguageRequired(contextualEventData)) {
            // empty if block
        }
        if (ContextualEventReporter.isUserInteractedWithContentEvent(contextualEventData)) {
            ContextualEventReporter.addUserInteractionEventProperties(props, contextualEventData);
        }
        if (ContextualEventReporter.isExternalConnectSent(contextualEventData)) {
            ContextualEventReporter.addExternalContentEventProperties(props, contextualEventData);
        }
        AniwaysAnalyticsReporter.track(props, timestamp);
    }

    private static void addExternalContentEventProperties(EventProperties props, ContextualEventData contextualEventData) {
        IconData[] icons = contextualEventData.icons;
        if (icons == null || icons.length <= 0) {
            return;
        }
        IconData interactedAsset = icons[0];
        props.put("asset_type", interactedAsset.assetType.toString());
        props.put("provider_name", interactedAsset.assetProvider.toString());
        props.put("content_id", EventReporterCommonMedhods.extractAssetId(interactedAsset));
        props.put("origin", (Object)contextualEventData.imageSpanMetadata.iconSelectionOrigin);
        if (interactedAsset.isEmoji()) {
            props.put("unicode_representation", interactedAsset.getUnicodeRepresentation());
        }
    }

    private static boolean isExternalConnectSent(ContextualEventData contextualEventData) {
        return contextualEventData.action == AnalyticsReporter.PhrasesEventAction.sentExternalContent;
    }

    private static void addUserInteractionEventProperties(EventProperties props, ContextualEventData contextualEventData) {
        IconData[] icons = contextualEventData.icons;
        if (icons == null || icons.length <= 0) {
            return;
        }
        IconData interactedAsset = icons[0];
        props.put("asset_type", interactedAsset.assetType.toString());
        props.put("provider_name", interactedAsset.assetProvider.toString());
        props.put("content_id", EventReporterCommonMedhods.extractAssetId(interactedAsset));
        props.put("from_auto_popup", contextualEventData.imageSpanMetadata.iconSelectionOrigin == IAniwaysImageSpan.IconSelectionOrigin.ContextualAuto);
        props.put("from_reveal_more", contextualEventData.isFromRevealMore());
        props.put("asset_index", contextualEventData.position);
        props.put("asset_index_out_of", contextualEventData.outOf);
    }

    private static boolean isUserInteractedWithContentEvent(ContextualEventData contextualEventData) {
        AnalyticsReporter.PhrasesEventAction action = contextualEventData.action;
        return action == AnalyticsReporter.PhrasesEventAction.selected || action == AnalyticsReporter.PhrasesEventAction.sent;
    }

    private static boolean isReportAssetsRequired(ContextualEventData contextualEventData) {
        AnalyticsReporter.PhrasesEventAction action = contextualEventData.action;
        return action == AnalyticsReporter.PhrasesEventAction.suggested || action == AnalyticsReporter.PhrasesEventAction.tapped;
    }

    private static boolean isReportPhraseLanguageRequired(ContextualEventData contextualEventData) {
        return false;
    }

    private static void addAssetsReportToProps(EventProperties props, ContextualEventData contextualEventData) {
        Phrase phrase = contextualEventData.phrase;
        if (phrase == null) {
            return;
        }
        ArrayList<String> availableAssetTypesForPhrase = new ArrayList<String>();
        AnimatedGifPhraseAssetInfoBuilder animatedGifs = phrase.animatedGifsPhraseAssetBuilder;
        EmoticonsPhraseAssetBuilder iconsData = phrase.emoticonsPhraseAssetBuilder;
        if (animatedGifs != null) {
            availableAssetTypesForPhrase.add("Animated Icons");
        }
        if (iconsData != null) {
            availableAssetTypesForPhrase.add("Emoticons");
        }
        if (!availableAssetTypesForPhrase.isEmpty()) {
            props.put("assets", availableAssetTypesForPhrase);
            props.put("assets_seen", availableAssetTypesForPhrase);
        }
    }

    private static void addIconIdsToAssetList(List<String> assetsIds, EmoticonsPhraseAssetBuilder iconsData) {
        if (iconsData.icons == null || iconsData.icons.length <= 0) {
            return;
        }
        for (IconData icon : iconsData.icons) {
            assetsIds.add(String.valueOf(icon.id));
        }
    }

    private static boolean isReportIndexInMessageRequired(ContextualEventData contextualEventData) {
        AnalyticsReporter.PhrasesEventAction action = contextualEventData.action;
        return action == AnalyticsReporter.PhrasesEventAction.suggested || action == AnalyticsReporter.PhrasesEventAction.sent || action == AnalyticsReporter.PhrasesEventAction.sentExternalContent;
    }
}

