/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics;

import android.content.Intent;
import com.aniways.analytics.DynamicPropertiesEvaluator;
import com.aniways.analytics.db.JsonPayloadSerializer;
import com.aniways.analytics.info.EventMetaDataCreator;
import com.aniways.analytics.models.Alias;
import com.aniways.analytics.models.BasePayload;
import com.aniways.analytics.models.Context;
import com.aniways.analytics.models.Error;
import com.aniways.analytics.models.EventProperties;
import com.aniways.analytics.models.Identify;
import com.aniways.analytics.models.Log;
import com.aniways.analytics.models.Screen;
import com.aniways.analytics.models.Timing;
import com.aniways.analytics.models.Track;
import com.aniways.analytics.models.Traits;
import com.aniways.analytics.service.AniwaysAnalyticsService;
import com.aniways.analytics.stats.AnalyticsStatistics;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.Calendar;
import java.util.UUID;
import org.json.JSONException;

public class AniwaysAnalyticsReporter {
    private static final String TAG = "AniwaysAnalyticsReporter";
    private static AnalyticsStatistics statistics;
    private static boolean initialized;
    private static String sessionId;
    private static DynamicPropertiesEvaluator dynamicPropertiesEvaluator;
    private static JsonPayloadSerializer serializer;
    private static android.content.Context sContext;

    public static AnalyticsStatistics getStatistics() {
        return statistics;
    }

    static void initialize(android.content.Context context) {
        if (initialized) {
            return;
        }
        sContext = context;
        statistics = new AnalyticsStatistics();
        serializer = new JsonPayloadSerializer();
        dynamicPropertiesEvaluator = new DynamicPropertiesEvaluator(){

            @Override
            public Context getEventMetaDataProperties() {
                Context result = new Context(EventMetaDataCreator.getInstance().create(sContext));
                return result;
            }

            @Override
            public Context getEventDataProperties(EventProperties properties, Calendar timestamp) {
                Context result = new Context();
                result.put("category", properties.get("category"));
                result.put("action", properties.get("action"));
                result.put("timestamp", timestamp);
                result.put("session_id", AniwaysAnalyticsReporter.getSessionId());
                properties.remove("category");
                properties.remove("action");
                return result;
            }
        };
        initialized = true;
        AniwaysAnalyticsReporter.startNewSession();
    }

    static void identify(String userId, Traits traits, Calendar timestamp) {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("analytics-android #identify must be initialized with a valid user id.");
        }
        Context context = dynamicPropertiesEvaluator.getEventMetaDataProperties();
        if (traits == null) {
            traits = new Traits();
        }
        Identify identify = new Identify(userId, traits, timestamp, context);
        AniwaysAnalyticsReporter.enqueue(identify);
        statistics.updateIdentifies(1.0);
    }

    static void track(EventProperties properties, Calendar timestamp) {
        Context metaData = dynamicPropertiesEvaluator.getEventMetaDataProperties();
        if (properties == null) {
            properties = new EventProperties();
        }
        Context eventData = dynamicPropertiesEvaluator.getEventDataProperties(properties, timestamp);
        Track track = new Track(properties, timestamp, metaData, eventData);
        AniwaysAnalyticsReporter.enqueue(track);
        statistics.updateTracks(1.0);
    }

    static void trackLog(EventProperties properties, Calendar timestamp) {
        Context context = dynamicPropertiesEvaluator.getEventMetaDataProperties();
        if (properties == null) {
            properties = new EventProperties();
        }
        Log log = new Log(properties, timestamp, context);
        AniwaysAnalyticsReporter.enqueue(log);
        statistics.updateTracks(1.0);
    }

    static void trackError(AniwaysConfiguration.Verbosity severity, EventProperties properties, Calendar timestamp) {
        Context context = dynamicPropertiesEvaluator.getEventMetaDataProperties();
        if (properties == null) {
            properties = new EventProperties();
        }
        Error error = new Error(severity.toString(), properties, timestamp, context);
        AniwaysAnalyticsReporter.enqueue(error);
        statistics.updateTracks(1.0);
    }

    static void screen(String screen, EventProperties properties, Calendar timestamp) {
        if (screen == null || screen.length() == 0) {
            throw new IllegalArgumentException("analytics-android #screen must be initialized with a valid screen name.");
        }
        Context context = dynamicPropertiesEvaluator.getEventMetaDataProperties();
        if (properties == null) {
            properties = new EventProperties();
        }
        Screen screenAction = new Screen(screen, properties, timestamp, context);
        AniwaysAnalyticsReporter.enqueue(screenAction);
        statistics.updateScreens(1.0);
    }

    static void timing(long interval, EventProperties properties, Calendar timestamp) {
        Context context = dynamicPropertiesEvaluator.getEventMetaDataProperties();
        if (properties == null) {
            properties = new EventProperties();
        }
        Timing timing = new Timing(interval, properties, timestamp, context);
        AniwaysAnalyticsReporter.enqueue(timing);
        statistics.updateTiming(1.0);
    }

    static void alias(String from, String to, Calendar timestamp) {
        if (from == null || from.length() == 0) {
            throw new IllegalArgumentException("analytics-android #alias must be initialized with a valid from id.");
        }
        if (to == null || to.length() == 0) {
            throw new IllegalArgumentException("analytics-android #alias must be initialized with a valid to id.");
        }
        Context context = dynamicPropertiesEvaluator.getEventMetaDataProperties();
        Alias alias = new Alias(from, to, timestamp, context);
        AniwaysAnalyticsReporter.enqueue(alias);
        statistics.updateAlias(1.0);
    }

    static boolean isInitialized() {
        return initialized;
    }

    static void startNewSession() {
        if (!AniwaysPrivateConfig.getInstance().isAnalyticsDisabled()) {
            sessionId = UUID.randomUUID().toString();
        }
    }

    private static void enqueue(BasePayload payload) {
        try {
            if (AniwaysPrivateConfig.getInstance().printAnalyticsToLogs) {
                com.aniways.Log.i(TAG, payload.toString(4));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String json = serializer.serialize(payload);
        Intent intent = new Intent(sContext, AniwaysAnalyticsService.class);
        intent.setAction("Enqueue");
        intent.putExtra("event", json);
        sContext.startService(intent);
    }

    private static String getSessionId() {
        return sessionId;
    }
}

