/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.aniways.AssetType;
import com.aniways.BugsnagReporter;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.analytics.AniwaysAnalyticsReporter;
import com.aniways.analytics.ContextualEventReporter;
import com.aniways.analytics.ContextualPopupStateReporter;
import com.aniways.analytics.ErrorReporter;
import com.aniways.analytics.EventReporterCommonMedhods;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.models.EventProperties;
import com.aniways.analytics.utils.ContextualEventData;
import com.aniways.analytics.utils.LooperThreadWithHandler;
import com.aniways.billing.AniwaysCreditsStoreActivity;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;
import com.aniways.quick.action.ContextualPopupCreationContext;
import com.aniways.quick.action.ContextualPopupStateHolder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class AnalyticsReporter {
    private static final String TAG = "AniwaysAnalyticsReporte";
    private static Map<String, Pair<Integer, Pair<Long, Integer>>> sStatisticalEvents = new HashMap<String, Pair<Integer, Pair<Long, Integer>>>();
    private static Map<String, Long> sStatisticalEventsLastReportTime = new HashMap<String, Long>();
    private static LooperThreadWithHandler sThread;

    public static void forceInit(Context applicationContext, Context context) {
        GoogleAnalyticsReporter.forceInit(applicationContext);
        sThread = new LooperThreadWithHandler("AniwaysAnalyticsThread");
        sThread.start();
        try {
            AniwaysAnalyticsReporter.initialize(applicationContext);
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Caught exception while initializing Aniways analytics", ex);
        }
        try {
            ErrorReporter.setReporter(new BugsnagReporter(context));
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Caught exception while initializing ErrorReporter", ex);
        }
    }

    public static boolean isInitialized() {
        return GoogleAnalyticsReporter.isInitialized() && AniwaysAnalyticsReporter.isInitialized();
    }

    public static void reportNewSession() {
        GoogleAnalyticsReporter.reportNewSession();
        AniwaysAnalyticsReporter.startNewSession();
    }

    public static void ReportTiming(AniwaysConfiguration.Verbosity verbosity, long startTime, String category, String name, String labelValueString, String tag, String labelName) {
        if (AniwaysPrivateConfig.getInstance().gaTimingEventsVerbosity.ordinal() <= verbosity.ordinal() || AniwaysPrivateConfig.getInstance().timingEventsVerbosity.ordinal() <= verbosity.ordinal()) {
            long measuredTime = System.currentTimeMillis() - startTime;
            AnalyticsReporter.ReportTimingNoCalc(verbosity, measuredTime, category, name, labelValueString, tag, labelName);
        }
    }

    public static void ReportTimingNoCalc(final AniwaysConfiguration.Verbosity verbosity, final long measuredTime, final String category, final String name, final String labelValueString, final String tag, final String labelName) {
        if (AniwaysPrivateConfig.getInstance().gaTimingEventsVerbosity.ordinal() <= verbosity.ordinal() || AniwaysPrivateConfig.getInstance().timingEventsVerbosity.ordinal() <= verbosity.ordinal()) {
            sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportTiming", "category: " + category){

                @Override
                public void innerRun() {
                    Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    if (verbosity == AniwaysConfiguration.Verbosity.Statistical) {
                        long reportTimeDelta;
                        int labelValue;
                        try {
                            labelValue = Integer.parseInt(labelValueString);
                        }
                        catch (NumberFormatException ex) {
                            Log.e(true, AnalyticsReporter.TAG, "Number format exception on statistical timing event. Category: " + category + " Name: " + name + " Label: " + labelValueString, ex);
                            return;
                        }
                        String key = category + name;
                        Pair sums = (Pair)sStatisticalEvents.get(key);
                        if (sums == null) {
                            Pair newSumValues = new Pair((Object)0L, (Object)0);
                            sums = new Pair((Object)0, (Object)newSumValues);
                            sStatisticalEvents.put(key, sums);
                        }
                        int numberOfSamples = (Integer)sums.first;
                        int newNumberOfSamples = numberOfSamples + 1;
                        Pair sumValues = (Pair)sums.second;
                        long timeSum = (Long)sumValues.first + measuredTime;
                        int valueSum = (Integer)sumValues.second + labelValue;
                        Long lastReportTime = (Long)sStatisticalEventsLastReportTime.get(key);
                        long now = System.currentTimeMillis();
                        if (lastReportTime == null) {
                            lastReportTime = now;
                            sStatisticalEventsLastReportTime.put(key, now);
                        }
                        if ((reportTimeDelta = now - lastReportTime) > (long)AniwaysPrivateConfig.getInstance().statisticalEventsInterval) {
                            GoogleAnalyticsReporter.ReportTiming(verbosity, timeSum / (long)newNumberOfSamples, category, name, String.valueOf(valueSum / newNumberOfSamples));
                            if (AniwaysPrivateConfig.getInstance().timingEventsVerbosity.ordinal() <= verbosity.ordinal()) {
                                EventProperties props = new EventProperties();
                                props.put("category", category);
                                props.put("name", name);
                                props.put("label", valueSum / newNumberOfSamples);
                                AniwaysAnalyticsReporter.timing(timeSum / (long)newNumberOfSamples, props, timestamp);
                            }
                            sStatisticalEventsLastReportTime.put(key, now);
                            sStatisticalEvents.remove(key);
                        } else {
                            Pair newSumValues = new Pair((Object)timeSum, (Object)valueSum);
                            Pair newSums = new Pair((Object)newNumberOfSamples, (Object)newSumValues);
                            sStatisticalEvents.put(key, newSums);
                        }
                    } else {
                        GoogleAnalyticsReporter.ReportTiming(verbosity, measuredTime, category, name, labelValueString);
                        if (AniwaysPrivateConfig.getInstance().timingEventsVerbosity.ordinal() <= verbosity.ordinal()) {
                            EventProperties props = new EventProperties();
                            props.put("category", category);
                            props.put("name", name);
                            props.put("label", labelValueString);
                            AniwaysAnalyticsReporter.timing(measuredTime, props, timestamp);
                        }
                    }
                    Log.v(tag, category + " -- " + name + " time: " + measuredTime + " " + labelName + ": " + labelValueString);
                }
            });
        }
    }

    public static void reportOnDemandIconSelectedlEvent(final ContextualEventData contextualEventData) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportPhrasesEvent", "action: " + contextualEventData.action.getEventReportName()){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                props.put("category", "contextual");
                props.put("action", contextualEventData.action.getEventReportName());
                props.put("message_id", contextualEventData.messageId);
                IconData[] icons = contextualEventData.icons;
                if (icons != null && icons.length > 0) {
                    IconData interactedAsset = icons[0];
                    props.put("asset_type", interactedAsset.assetType.toString());
                    props.put("provider_name", interactedAsset.assetProvider.toString());
                    props.put("content_id", EventReporterCommonMedhods.extractAssetId(interactedAsset));
                    props.put("category_name", contextualEventData.tabName);
                    props.put("page_index", contextualEventData.pageNumber);
                    props.put("page_index_put_of", contextualEventData.outOf);
                    AniwaysAnalyticsReporter.track(props, timestamp);
                }
            }
        });
    }

    public static void reportContextualEvent(final ContextualEventData contextualEventData) {
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportPhrasesEvent", "action: " + contextualEventData.action.getEventReportName()){

            @Override
            public void innerRun() {
                ContextualEventReporter.reportContextualEvent(contextualEventData);
            }
        });
    }

    public static void reportPhrasesEvent(final PhrasesEventAction action, final UUID messageId, final Phrase phrase, final IconData[] icons, final boolean wasUnlocked, final IconData previousIcon, final boolean isFromGenious, final String tabName, final int tabNumber, final String FamilyName, final int familyNumber, final int pageNumber, final int position, final int outOf, final int row, final int column, final int numRows, final int numColumns, final int serialNumberInMessage, final String externalData, final ExternalDataType externalDataType, final IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportPhrasesEvent", "action: " + (Object)((Object)action)){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                if (action != PhrasesEventAction.displayInfo && !AniwaysPrivateConfig.getInstance().doNotSendMessageIdInAnalytics) {
                    props.put("message_id", messageId);
                }
                props.put("category", "contextual");
                props.put("action", action.getEventReportName());
                if (phrase != null) {
                    props.put("phraseName", phrase.getName());
                    props.put("partToReplace", phrase.getPartToReplace());
                }
                if (icons != null && icons.length > 0) {
                    Long[] iconIds = new Long[icons.length];
                    for (int i = 0; i < icons.length; ++i) {
                        IconData icon = icons[i];
                        iconIds[i] = icon != null ? Long.valueOf(icon.id) : Long.valueOf(-1L);
                    }
                    props.put("iconNames", (T[])iconIds);
                }
                if (previousIcon != null) {
                    props.put("prevIconName", previousIcon.id);
                }
                if (imageSpanMetadata != null) {
                    props.put("iconSelectionOrigin", (Object)imageSpanMetadata.iconSelectionOrigin);
                    props.put("assetProvider", (Object)imageSpanMetadata.assetProvider);
                    props.put("assetType", (Object)imageSpanMetadata.assetType);
                    if (imageSpanMetadata.isFromAniwaysKeyboard()) {
                        props.put("isFromGenious", isFromGenious);
                    }
                }
                if (action == PhrasesEventAction.selected) {
                    props.put("position", position);
                    props.put("outOf", outOf);
                    props.put("row", row);
                    props.put("column", column);
                    props.put("numRows", numRows);
                    props.put("numColumns", numColumns);
                    if (tabName != null) {
                        props.put("tabName", tabName);
                    }
                    props.put("tabNumber", tabNumber);
                    if (FamilyName != null) {
                        props.put("FamilyName", FamilyName);
                    }
                    props.put("familyNumber", familyNumber);
                    props.put("pageNumber", pageNumber);
                }
                if (icons != null && icons.length == 1) {
                    IconData icon = icons[0];
                    props.put("isAnimated", icon.isAnimated());
                }
                props.put("serialNumberInMessage", serialNumberInMessage);
                if (action != PhrasesEventAction.tapped && action != PhrasesEventAction.suggested) {
                    props.put("wasUnlocked", wasUnlocked);
                }
                if (!TextUtils.isEmpty((CharSequence)externalData)) {
                    props.put("externalData", externalData);
                    props.put("externalDataType", (Object)externalDataType);
                }
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    public static void reportIconNotSelectedThroughAniwaysSent(final IconData icon, final int serialNumberInMessage, final UUID messageId, final IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportUncoveredEmoji", "action: emojiKeyword"){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                if (!AniwaysPrivateConfig.getInstance().doNotSendMessageIdInAnalytics) {
                    props.put("msgid", messageId);
                }
                props.put("category", "Icons");
                props.put("action", "sentIcon");
                if (imageSpanMetadata != null) {
                    props.put("iconSelectionOrigin", (Object)imageSpanMetadata.iconSelectionOrigin);
                    props.put("assetProvider", (Object)imageSpanMetadata.assetProvider);
                    props.put("assetType", (Object)imageSpanMetadata.assetType);
                }
                if (icon != null) {
                    props.put("iconID", icon.id);
                    props.put("isEmoji", icon.isEmoji());
                    if (icon.isEmoji()) {
                        String unicodeRepresentation = icon.getUnicodeRepresentation();
                        props.put("emojiUnicode", unicodeRepresentation);
                        String escapedUnicodeRepresentation = "";
                        if (unicodeRepresentation != null) {
                            int codepoint;
                            int length = unicodeRepresentation.length();
                            for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
                                codepoint = unicodeRepresentation.codePointAt(offset);
                                if (offset > 0) {
                                    escapedUnicodeRepresentation = escapedUnicodeRepresentation + "-";
                                }
                                escapedUnicodeRepresentation = escapedUnicodeRepresentation + Integer.toHexString(codepoint);
                            }
                        }
                        props.put("escapedUnicodeRepresentation", escapedUnicodeRepresentation);
                    }
                }
                props.put("serialNumberInMessage", serialNumberInMessage);
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    public static void reportUserConfigChanged(String action, String propertyName, Object oldValue, Object newValue) {
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "User config Changed", propertyName, "Old value: " + oldValue + ". New value: " + newValue, 0L);
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        EventProperties props = new EventProperties();
        props.put("old value", oldValue == null ? "Not set" : oldValue);
        props.put("new value", newValue);
        AnalyticsReporter.reportConfiguration(action, props);
    }

    public static void reportRequestBackendSync(long intervalFromLastSuccessfulAlarm, boolean fromAlarm) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Verbose.ordinal()) {
            return;
        }
        EventProperties props = new EventProperties();
        props.put("intervalFromLastSuccessfulAlarm", intervalFromLastSuccessfulAlarm);
        props.put("firstTime", intervalFromLastSuccessfulAlarm == 0L);
        props.put("fromalarm", fromAlarm);
        AnalyticsReporter.reportStatistics("Request backend sync", props);
    }

    public static void reportUpdatedKeywordsVersion(String from, String to) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Verbose.ordinal()) {
            return;
        }
        EventProperties props = new EventProperties();
        props.put("from", from);
        props.put("to", to);
        AnalyticsReporter.reportStatistics("Updated keywords version", props);
    }

    public static void reportUpdatedConfigVersion(String from, String to) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Verbose.ordinal()) {
            return;
        }
        EventProperties props = new EventProperties();
        props.put("from", from);
        props.put("to", to);
        AnalyticsReporter.reportStatistics("Updated config version", props);
    }

    public static void reportFinishedProcessingKeywordsVersion(String oldVer, String newVer) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Verbose.ordinal()) {
            return;
        }
        EventProperties props = new EventProperties();
        props.put("oldVer", oldVer);
        props.put("newVer", newVer);
        AnalyticsReporter.reportLog("Finished processing keywords version", props);
    }

    public static void reportAppStillInstalled(long appInstallTime, long now) {
        if (!AniwaysPrivateConfig.getInstance().sendHeartbeatEvent) {
            return;
        }
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        EventProperties props = new EventProperties();
        AnalyticsReporter.reportApplication("app installed", props);
    }

    public static void reportFinishedProcessingConfigVersion(String oldVer, String newVer) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Verbose.ordinal()) {
            return;
        }
        EventProperties props = new EventProperties();
        props.put("oldVer", oldVer);
        props.put("newVer", newVer);
        AnalyticsReporter.reportLog("Finished processing config version", props);
    }

    public static void reportMessageSentEvent(final UUID messageId, final String text) {
        final AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        if (config.analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportMessagingEvent", "text: " + text){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                if (!config.doNotSendMessageIdInAnalytics) {
                    props.put("message_id", messageId);
                }
                props.put("action", PhrasesEventAction.messageSent.getEventReportName());
                props.put("category", "contextual");
                props.put("keyboard_language", "unknown");
                if (text != null && !config.doNotSendMessagesInAnalytics) {
                    props.put("text", text);
                }
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    public static void reportEditTextTutorialEvent(final EditTextTutorialAction action, final UUID messageId, final Phrase phrase, final int tutorialNumber) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportEditTextTutorialEvent", "action: " + (Object)((Object)action)){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                if (!AniwaysPrivateConfig.getInstance().doNotSendMessageIdInAnalytics) {
                    props.put("msgid", messageId);
                }
                props.put("category", "EditText Tutorial");
                props.put("tutorialNumber", tutorialNumber);
                if (phrase != null) {
                    props.put("phraseName", phrase.getName());
                    props.put("partToReplace", phrase.getPartToReplace());
                }
                if (action == EditTextTutorialAction.opened) {
                    GoogleAnalyticsReporter.reportView("Tutorial number: " + tutorialNumber);
                    if (AniwaysPrivateConfig.getInstance().screenEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
                        return;
                    }
                    AniwaysAnalyticsReporter.screen("Edit text tutorial", props, timestamp);
                    return;
                }
                if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
                    return;
                }
                props.put("action", action.toString());
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    public static void reportStoreEvent(final StoreEventAction action, final String storeSessionId, final int remainingCredits, final int newCredits, final int amount, final boolean openedFollowingTryingToUnlockIcon, final String iconTryingToUnlock, final String source, final String sku, final AniwaysCreditsStoreActivity.Price price, final String paymentMethod) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportStoreEvent", "action:" + (Object)((Object)action)){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                if (action == StoreEventAction.openedStore) {
                    GoogleAnalyticsReporter.reportView("Aniways Credits Store " + (openedFollowingTryingToUnlockIcon ? " (following trying to unlock icon)" : "following click on store balance"));
                    if (AniwaysPrivateConfig.getInstance().screenEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
                        return;
                    }
                    props.put("storeSessionId", storeSessionId);
                    props.put("category", "Store");
                    props.put("remainingCredits", remainingCredits);
                    props.put("openedFollowingTryingToUnlockIcon", openedFollowingTryingToUnlockIcon);
                    props.put("iconTryingToUnlock", iconTryingToUnlock);
                    props.put("source", source);
                    props.put("paymentMethod", paymentMethod);
                    return;
                }
                if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Billing.ordinal()) {
                    return;
                }
                if (action != StoreEventAction.creditsPurchased && AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
                    return;
                }
                props.put("action", action.toString());
                props.put("sku", sku);
                if (price != null) {
                    props.put("price", price.readablePrice);
                    props.put("priceAmount", price.priceAmount);
                    props.put("priceCurrency", price.priceCurrency);
                }
                props.put("newCredits", newCredits);
                props.put("amount", amount);
                props.put("storeSessionId", storeSessionId);
                props.put("category", "Store");
                props.put("remainingCredits", remainingCredits);
                props.put("openedFollowingTryingToUnlockIcon", openedFollowingTryingToUnlockIcon);
                props.put("iconTryingToUnlock", iconTryingToUnlock);
                props.put("source", source);
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    private static void reportConfiguration(final String action, EventProperties properties) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (properties == null) {
            properties = new EventProperties();
        }
        final EventProperties props = properties;
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportConfiguration", "Action: " + action){

            @Override
            public void innerRun() {
                props.put("category", "configuration");
                props.put("action", action);
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    private static void reportStatistics(final String action, EventProperties properties) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (properties == null) {
            properties = new EventProperties();
        }
        final EventProperties props = properties;
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportStatistics", "Action: " + action){

            @Override
            public void innerRun() {
                props.put("category", "Statistics");
                props.put("action", action);
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    public static void reportIconsOnDemandScreenView(final AssetType assetType, final String categoryName, final int categoryNumber, final String familyName, final int familyNumber, final int pageNumber) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportIconsOnDemandScreenView", "tabName: " + categoryName){

            @Override
            public void innerRun() {
                String screenView = "AniwaysEmoticonsButton--" + assetType.toString() + "--" + categoryName + "--" + familyName + "--" + pageNumber;
                GoogleAnalyticsReporter.reportView(screenView);
                if (AniwaysPrivateConfig.getInstance().screenEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
                    return;
                }
                EventProperties props = new EventProperties();
                props.put("tabName", categoryName);
                props.put("tabNumber", categoryNumber);
                props.put("familyName", familyName);
                props.put("familyNumber", familyNumber);
                props.put("pageNumber", pageNumber);
                props.put("assetCode", assetType.getAssetCode());
                AniwaysAnalyticsReporter.screen("IOD", props, timestamp);
            }
        });
    }

    public static void reportError(final AniwaysConfiguration.Verbosity severity, final String tag, final String message, final Throwable error, final boolean toGaOnly) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportError", message, true){

            @Override
            public void innerRun() {
                boolean sendToGoogleAnalytics;
                if (!AnalyticsReporter.isInitialized()) {
                    android.util.Log.e((String)AnalyticsReporter.TAG, (String)("Report error event called before Aniways was initialized!! Error: " + message));
                }
                boolean sendToAniways = !toGaOnly && AniwaysPrivateConfig.getInstance().sendErrorsToAniwaysServer && AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() <= severity.ordinal();
                boolean bl = sendToGoogleAnalytics = AniwaysPrivateConfig.getInstance().sendErrorsToGoogleAnalytics && AniwaysPrivateConfig.getInstance().googleAnalyticsEventsVerbosity.ordinal() <= severity.ordinal();
                if (sendToAniways || sendToGoogleAnalytics) {
                    String stackTrace = "";
                    String exceptionMessage = "";
                    if (error != null) {
                        stackTrace = Log.getStackTraceString(error);
                        exceptionMessage = error.toString();
                    }
                    if (sendToGoogleAnalytics) {
                        String formattedMessage = message + "\n\nException message: \n" + exceptionMessage + "\n\nStack trace: \n" + stackTrace;
                        GoogleAnalyticsReporter.reportEvent(severity, severity.toString(), tag, formattedMessage, 0L);
                    }
                    if (sendToAniways) {
                        EventProperties props = new EventProperties();
                        props.put("category", "Errors");
                        props.put("tag", tag);
                        props.put("msg", message);
                        if (error != null) {
                            props.put("exceptionMessage", exceptionMessage);
                            props.put("stackTrace", stackTrace);
                        }
                        AniwaysAnalyticsReporter.trackError(severity, props, timestamp);
                    }
                }
                if (toGaOnly || AniwaysPrivateConfig.getInstance().errorHandlingVerbosity.ordinal() > severity.ordinal()) {
                    return;
                }
                ErrorReporter.notify(tag, message, error);
            }
        });
    }

    private static void reportApplication(final String action, EventProperties properties) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (properties == null) {
            properties = new EventProperties();
        }
        final EventProperties props = properties;
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportApplication", "Action: " + action){

            @Override
            public void innerRun() {
                props.put("category", "application");
                props.put("action", action);
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    private static void reportLog(final String action, EventProperties properties) {
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (properties == null) {
            properties = new EventProperties();
        }
        final EventProperties props = properties;
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportLog", "Action: " + action){

            @Override
            public void innerRun() {
                props.put("category", "Statistics");
                props.put("action", action);
                AniwaysAnalyticsReporter.trackLog(props, timestamp);
            }
        });
    }

    public static void reportPopupScroll(final AssetType newAssetType, final int position, final AssetType oldAssetType, final int oldPos, final ContextualPopupCreationContext creationContext) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportPopupScrollEvent", "action: scroll"){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                props.put("msgid", creationContext.messageId);
                props.put("category", "Popup");
                props.put("action", "scroll");
                props.put("toAssetType", (Object)newAssetType);
                props.put("fromAssetType", (Object)oldAssetType);
                props.put("toPosition", position);
                props.put("fromPosition", oldPos);
                props.put("iconSelectionOrigin", (Object)creationContext.selectionOrigin);
                if (creationContext.phrase != null) {
                    props.put("phraseName", creationContext.phrase.getName());
                    props.put("partToReplace", creationContext.phrase.getPartToReplace());
                }
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    public static void reportRevealMoreInPopup(final AssetType assetType, final int position, final ContextualPopupCreationContext creationContext) {
        if (AniwaysPrivateConfig.getInstance().analyticsEventsVerbosity.ordinal() > AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return;
        }
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportPopupScrollEvent", "action: scroll"){

            @Override
            public void innerRun() {
                EventProperties props = new EventProperties();
                props.put("msgid", creationContext.messageId);
                props.put("category", "Popup");
                props.put("action", "revealMore");
                props.put("assetType", (Object)assetType);
                props.put("position", position);
                props.put("iconSelectionOrigin", (Object)creationContext.selectionOrigin);
                if (creationContext.phrase != null) {
                    props.put("phraseName", creationContext.phrase.getName());
                    props.put("partToReplace", creationContext.phrase.getPartToReplace());
                }
                AniwaysAnalyticsReporter.track(props, timestamp);
            }
        });
    }

    public static void reportScreenEvent(ContextualPopupStateHolder popupStateHolder) {
        final ContextualPopupStateHolder stateHolderCopy = new ContextualPopupStateHolder(popupStateHolder);
        sThread.handler().post((Runnable)new NonThrowingRunnable(TAG, "reportPopupScrollEvent", "action: scroll"){

            @Override
            public void innerRun() {
                ContextualPopupStateReporter.reportScreenEvent(stateHolderCopy, System.currentTimeMillis());
            }
        });
    }

    public static enum ExternalDataType {
        openApp,
        openGooglePlay,
        openGooglePlayBrowser,
        openWebsiteInBrowser;

    }

    public static enum StoreEventAction {
        finishedConsumptionFlow,
        startConsumptionFlowFromInventoryQuery,
        startPurchseCredits,
        creditsPurchased,
        startConsumptionFlowAfterPurchase,
        openedStore,
        launchingStore,
        unlockIcon,
        userCancelled;

    }

    public static enum EditTextTutorialAction {
        opened,
        cancelled,
        phraseClicked;

    }

    public static enum PhrasesEventAction {
        suggested("suggested"),
        tapped("tapped"),
        selected("selected"),
        sent("sent"),
        messageSent("message sent"),
        sentExternalContent("external content"),
        switched("switched"),
        backspaceDelete("backspaceDelete"),
        popupDelete("popupDelete"),
        displayInfo("displayInfo"),
        displayExternalInfo("displayExternalInfo");

        private final String eventReportName;

        private PhrasesEventAction(String eventReportName) {
            this.eventReportName = eventReportName;
        }

        public String getEventReportName() {
            return this.eventReportName;
        }
    }
}

