/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.view.View;
import android.view.ViewGroup;
import com.aniways.AniwaysVerticalLinearLayout;
import java.util.ArrayList;
import java.util.List;

public final class ViewUtils {
    private ViewUtils() {
    }

    public static <T> List<T> find(ViewGroup root, Class<T> type) {
        FinderByType finderByType = new FinderByType(type);
        AniwaysVerticalLinearLayout.LayoutTraverser.build(finderByType).traverse(root, true);
        return finderByType.getViews();
    }

    public static int getRelativeLeftToViewRoot(View myView) {
        if (myView.getParent() == myView.getRootView()) {
            return myView.getLeft();
        }
        return myView.getLeft() + ViewUtils.getRelativeLeftToViewRoot((View)myView.getParent());
    }

    public static int getRelativeTopToViewRoot(View myView) {
        if (myView.getParent() == myView.getRootView()) {
            return myView.getTop();
        }
        return myView.getTop() + ViewUtils.getRelativeTopToViewRoot((View)myView.getParent());
    }

    private static class FinderByType<T>
    implements AniwaysVerticalLinearLayout.LayoutTraverser.Processor {
        private final Class<T> type;
        private final List<T> views;

        private FinderByType(Class<T> type) {
            this.type = type;
            this.views = new ArrayList<T>();
        }

        @Override
        public void process(View view) {
            if (this.type.isInstance(view)) {
                this.views.add(view);
            }
        }

        public List<T> getViews() {
            return this.views;
        }
    }
}

