/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.aniways.AniwaysAnimatedGifSpan;
import com.aniways.AniwaysBitmapDecodeUtils;
import com.aniways.AniwaysImageSpan;
import com.aniways.AssetType;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IIconInfoDisplayer;
import com.aniways.IImageSpanFactory;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;
import pl.droidsonroids.gif.GifDrawable;

public class IconData
implements IImageSpanFactory {
    public static final int EMPTY_EMOJI_CODEPOINT = -1;
    private static final String EXTENSION = ".png";
    public static final String ANIMATED_EXTENSION = ".gif";
    private static final String DEFAULT_UNICODE_REPRESENTATION = new String(new int[]{Integer.parseInt("1f6c5", 16)}, 0, 1);
    private static final String TAG = "AniwaysIconData";
    private static final double USE_INTRINSIC_SIZE = 0.0;
    public Phrase primaryPhrase;
    public String family;
    public int id;
    public boolean isLocked;
    public AssetType assetType;
    public IAniwaysImageSpan.AssetProvider assetProvider;
    private final boolean animated;
    public int firstEmojiCodepoint = -1;
    public int secondEmojiCodepoint = -1;
    public Object iconSelectionTag;

    public IconData(int id2, String family, boolean isLocked, Phrase primaryPhrase, String unicodeRepresentation, AssetType assetType, IAniwaysImageSpan.AssetProvider assetProvider, boolean animated) {
        this.id = id2;
        this.family = family;
        this.isLocked = isLocked;
        this.primaryPhrase = primaryPhrase;
        this.assetType = assetType;
        this.assetProvider = assetProvider;
        this.animated = animated;
        this.extractUnicodeRepresentation(unicodeRepresentation);
    }

    protected IconData(IconData other) {
        this(other.id, other.family, other.isLocked, other.primaryPhrase, null, other.assetType, other.assetProvider, other.animated);
        this.firstEmojiCodepoint = other.firstEmojiCodepoint;
        this.secondEmojiCodepoint = other.secondEmojiCodepoint;
        this.iconSelectionTag = other.iconSelectionTag;
    }

    public boolean isInFamily(String family) {
        return this.family.equalsIgnoreCase(family);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isEmoji() {
        return this.assetType == AssetType.Emoji;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public boolean hasEmojiFallback() {
        return this.firstEmojiCodepoint != -1;
    }

    public String getUnicodeRepresentation() {
        if (this.firstEmojiCodepoint == -1) {
            return null;
        }
        return new String(new int[]{this.firstEmojiCodepoint, this.secondEmojiCodepoint}, 0, this.secondEmojiCodepoint == -1 ? 1 : 2);
    }

    public String getUnicodeToReplaceText() {
        String response = this.getUnicodeRepresentation();
        if (response == null) {
            response = DEFAULT_UNICODE_REPRESENTATION;
        }
        return response;
    }

    public String getFileName() {
        return Integer.toString(this.id) + (this.isAnimated() ? ANIMATED_EXTENSION : EXTENSION);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IconData)) {
            return false;
        }
        return this.equals((IconData)o);
    }

    public boolean equals(IconData o) {
        return this.id == o.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "ID: " + this.id + ". Family: " + this.family + ". Asset type: " + (Object)((Object)this.assetType) + ". Asset provider: " + (Object)((Object)this.assetProvider) + ". has emoji fallback: " + this.hasEmojiFallback() + ". Primary Phrase: " + this.primaryPhrase + ". IsLocked: " + this.isLocked + ". Unicode to replace text: " + this.getUnicodeToReplaceText();
    }

    private void extractUnicodeRepresentation(String unicodesString) {
        if (unicodesString == null) {
            return;
        }
        String[] unicodeStrings = unicodesString.split("-");
        this.firstEmojiCodepoint = Integer.parseInt(unicodeStrings[0], 16);
        if (unicodeStrings.length == 1) {
            return;
        }
        this.secondEmojiCodepoint = Integer.parseInt(unicodeStrings[1], 16);
    }

    public boolean hasExternalData() {
        return false;
    }

    public String getExternalActivityPackage() {
        Log.e(true, TAG, "getExternalActivityPackage called on IconData");
        return null;
    }

    public String getExternalWebsite() {
        Log.e(true, TAG, "getExternalWebsite called on IconData");
        return null;
    }

    @Override
    public AniwaysImageSpan createImageSpan(Object data, Phrase phrase, IAniwaysImageSpan.IconSelectionOrigin selectionOrigin, Context context, int width, int height, IIconInfoDisplayer iconInfoDisplayer) {
        if (this.isAnimated()) {
            AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
            if (iconInfoDisplayer != null) {
                return new AniwaysAnimatedGifSpan((byte[])data, phrase, this, selectionOrigin, width, height);
            }
            Bitmap bitmap = AniwaysBitmapDecodeUtils.decodeBitmapFromByteArray((byte[])data, config.getMaxWidthForCache(this), config.getMaxHeightForCache(this), this.getFileName(), false);
            return new AniwaysImageSpan(bitmap, phrase, this, selectionOrigin, context, width, height);
        }
        return new AniwaysImageSpan((Bitmap)data, phrase, this, selectionOrigin, context, width, height);
    }

    public Drawable setDrawableBounds(Drawable drawable2, int maxWidth, int maxHeight) {
        if (drawable2 == null) {
            return null;
        }
        int height = IconData.getIconHeight(drawable2, maxHeight);
        int width = IconData.getIconWidth(drawable2, maxWidth);
        drawable2.setBounds(0, 0, width, height);
        return drawable2;
    }

    private static int getIconHeight(Drawable d, int maxHeight) {
        return IconData.getIconHeight(d.getIntrinsicWidth(), d.getIntrinsicHeight(), maxHeight);
    }

    private static int getIconHeight(int intrinsicWidth, int intrinsicHeight, int maxHeight) {
        if ((double)maxHeight == 0.0) {
            maxHeight = intrinsicHeight;
        }
        if (intrinsicHeight >= intrinsicWidth) {
            return maxHeight;
        }
        float ratio = (float)intrinsicHeight / (float)intrinsicWidth;
        int result = Math.round((float)maxHeight * ratio);
        return result;
    }

    private static int getIconWidth(Drawable d, int maxWidth) {
        return IconData.getIconWidth(d.getIntrinsicWidth(), d.getIntrinsicHeight(), maxWidth);
    }

    private static int getIconWidth(int intrinsicWidth, int intrinsicHeight, int maxWidth) {
        if ((double)maxWidth == 0.0) {
            maxWidth = intrinsicWidth;
        }
        if (intrinsicWidth >= intrinsicHeight) {
            return maxWidth;
        }
        float ratio = (float)intrinsicWidth / (float)intrinsicHeight;
        int result = Math.round((float)maxWidth * ratio);
        return result;
    }

    public static Drawable generateAnimatedDrawable(byte[] data) {
        GifDrawable gifDrawable = null;
        try {
            gifDrawable = new GifDrawable(data);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Failed to create an animated gif drawable", ex);
        }
        return gifDrawable;
    }

    public String getUrl(boolean useSmallEmoji, boolean displayBig, boolean displayBanner) {
        return null;
    }

    public Drawable generateDrawable(Bitmap image, Context ctx) {
        if (ctx == null) {
            Log.e(true, TAG, "context is null");
            return null;
        }
        if (image == null) {
            Log.e(true, TAG, "image is null");
            return null;
        }
        return new BitmapDrawable(ctx.getResources(), image);
    }

    public String getAssetIdFromProvider() {
        return String.valueOf(this.id);
    }
}

