/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.aniways.AniwaysDynamicImageSpansContainer;
import com.aniways.AniwaysEditTextAndTextViewCommonPart;
import com.aniways.AniwaysIconInfoDisplayer;
import com.aniways.AniwaysInternalIconInfoSpan;
import com.aniways.AniwaysMessageListViewItemWrapperLayout;
import com.aniways.IAniwaysGestureResponder;
import com.aniways.IAniwaysIconInfoSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IAniwaysTextEditor;
import com.aniways.IAniwaysTextWatcher;
import com.aniways.IIconInfoDisplayer;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysStatics;

public class AniwaysTextView
extends TextView
implements IAniwaysGestureResponder,
IAniwaysTextEditor,
IIconInfoDisplayer,
IAniwaysTextContainer {
    private AniwaysEditTextAndTextViewCommonPart mAniwaysEditTextAndTextViewerCommonPart;
    private static final String TAG = "AniwaysTextView";
    private static int sSetTextTimingCounter = 0;
    private AniwaysIconInfoDisplayer mIconInfoDisplayer;
    public boolean mUseSmallIcons = false;
    private int mOldTextHashCode = -1;
    private boolean mIconsClickable = true;

    public AniwaysTextView(Context paramContext) {
        this(paramContext, null);
    }

    public AniwaysTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (!this.isInEditMode()) {
            this.mAniwaysEditTextAndTextViewerCommonPart = new AniwaysEditTextAndTextViewCommonPart(this);
            this.mIconInfoDisplayer = new AniwaysIconInfoDisplayer();
            this.init(attributeSet);
        }
    }

    public AniwaysTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.mAniwaysEditTextAndTextViewerCommonPart = new AniwaysEditTextAndTextViewCommonPart(this);
            this.mIconInfoDisplayer = new AniwaysIconInfoDisplayer();
            this.init(attrs);
        }
    }

    private void init(AttributeSet attrs) {
        try {
            if (attrs == null) {
                return;
            }
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.AniwaysSmallIcons);
            for (int i = 0; i < a.getIndexCount(); ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.AniwaysSmallIcons_aniways_use_small_icons) {
                    this.mUseSmallIcons = a.getBoolean(attr2, false);
                    continue;
                }
                if (attr2 != R.styleable.AniwaysSmallIcons_aniways_icons_clickable) continue;
                this.mIconsClickable = a.getBoolean(attr2, true);
            }
            a.recycle();
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in Ctor", e);
        }
    }

    public boolean onTextContextMenuItem(int id2) {
        try {
            return this.mAniwaysEditTextAndTextViewerCommonPart.onTextContextMenuItem(id2);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in onTextContextMenuItem. Id is: " + id2, ex);
            return true;
        }
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        try {
            return this.mAniwaysEditTextAndTextViewerCommonPart.dispatchKeyEventPreIme(event);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in dispatchKeyEventPreIme. Event is: " + event, ex);
            return true;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            if (!this.mIconsClickable) {
                Log.v(TAG, "Icons are not clickable so passing touch event to super");
                return super.onTouchEvent(event);
            }
            return this.mAniwaysEditTextAndTextViewerCommonPart.onTouchEvent(event);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in onTouchEvent. Event is: " + event, ex);
            return true;
        }
    }

    @Override
    public void displayIconInfo(AniwaysInternalIconInfoSpan infoSpan, IAniwaysTextContainer textContainer) {
        this.mIconInfoDisplayer.displayIconInfo(infoSpan, textContainer);
    }

    @Override
    public void onSingleTap(MotionEvent event) {
        try {
            Log.d(TAG, "Single tap detected on an AniwaysTextView icon");
            int pos = this.mAniwaysEditTextAndTextViewerCommonPart.getPositionOfTouchEventInText(event);
            if (pos != -1) {
                IAniwaysIconInfoSpan[] infoSpans = (IAniwaysIconInfoSpan[])this.getText().getSpans(pos, pos, IAniwaysIconInfoSpan.class);
                if (infoSpans.length != 0) {
                    long eventTime = -1L;
                    if (event.getAction() == 0) {
                        eventTime = event.getEventTime();
                    }
                    infoSpans[0].onClick(this.mAniwaysEditTextAndTextViewerCommonPart, eventTime);
                }
            } else {
                Log.d(TAG, "single tap detected on an AniwaysTextView icon, but position is -1!!!");
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in onSingleTap. Event is: " + event, ex);
        }
    }

    @Override
    public boolean callSuperOnTextContextMenuItem(int id2) {
        return super.onTextContextMenuItem(id2);
    }

    @Override
    public boolean callSuperOnTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    @Override
    public boolean callSuperDispatchKeyEventPreIme(KeyEvent event) {
        return super.dispatchKeyEventPreIme(event);
    }

    public Editable getText() {
        CharSequence text;
        if (!this.isInEditMode()) {
            AniwaysStatics.makeSureAniwaysIsInitialized(false);
        }
        if ((text = super.getText()) instanceof Editable) {
            return (Editable)text;
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Log.e(true, TAG, "The text was not ediable: " + text);
        }
        return Editable.Factory.getInstance().newEditable(text);
    }

    @Override
    public void setText(CharSequence text, boolean justCallSuper) {
        if (justCallSuper) {
            super.setText(text, TextView.BufferType.EDITABLE);
        } else {
            this.setText(text, TextView.BufferType.EDITABLE);
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.isInEditMode()) {
            super.setText(text, type);
            return;
        }
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            Log.d(TAG, "Setting text: " + text);
            if (text == null) {
                text = "";
            }
            Editable oldText = null;
            boolean oldTextWasNull = false;
            try {
                oldText = this.getText();
            }
            catch (ClassCastException ex) {
                oldTextWasNull = true;
                oldText = Editable.Factory.getInstance().newEditable((CharSequence)"");
                Log.v(TAG, "set text cast exception caught");
            }
            int newHash = text.hashCode();
            if (!oldTextWasNull && oldText != null && newHash == this.mOldTextHashCode && this.mOldTextHashCode != -1) {
                Log.v(TAG, "Trying to set the same text, so doing nothing..");
            }
            this.mOldTextHashCode = newHash;
            long startTime = System.currentTimeMillis();
            super.setText(text, TextView.BufferType.EDITABLE);
            if (this.mAniwaysEditTextAndTextViewerCommonPart != null) {
                this.mAniwaysEditTextAndTextViewerCommonPart.onSetText((CharSequence)this.getText(), (Spannable)oldText);
            }
            if (AnalyticsReporter.isInitialized()) {
                if (sSetTextTimingCounter % 30 == 0) {
                    AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Statistical, startTime, "Performance", "Set Text To Label", String.valueOf(text.length()), TAG, "num chars");
                }
                ++sSetTextTimingCounter;
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in setText. Text is: " + text, ex);
        }
    }

    public void setSelection(int start, int stop) {
        try {
            Selection.setSelection((Spannable)this.getText(), (int)start, (int)stop);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in setSelection. start is: " + start + ". Stop is: " + stop, ex);
        }
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        this.mAniwaysEditTextAndTextViewerCommonPart.removeTextChangedListener(watcher);
    }

    public void addTextChangedListener(TextWatcher watcher) {
        this.mAniwaysEditTextAndTextViewerCommonPart.addTextChangedListener(watcher);
    }

    public void setSelection(int index) {
        try {
            Selection.setSelection((Spannable)this.getText(), (int)index);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in setSelection. Index is: " + index, ex);
        }
    }

    public void selectAll() {
        try {
            Selection.selectAll((Spannable)this.getText());
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in selectAll", ex);
        }
    }

    public void extendSelection(int index) {
        try {
            Selection.extendSelection((Spannable)this.getText(), (int)index);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in extendSelection. Index is: " + index, ex);
        }
    }

    @Override
    public void callSuperSetSelection(int start, int stop) {
        this.setSelection(start, stop);
    }

    @Override
    public void callSuperSetSelection(int index) {
        this.setSelection(index);
    }

    @Override
    public void callSuperExtendSelection(int index) {
        this.extendSelection(index);
    }

    @Override
    public void callSuperSelectAll() {
        this.selectAll();
    }

    @Override
    public void callSuperRemoveTextChangedListener(TextWatcher watcher) {
        super.removeTextChangedListener(watcher);
    }

    @Override
    public void callSuperAddTextChangedListener(TextWatcher watcher) {
        super.addTextChangedListener(watcher);
    }

    @Override
    public IAniwaysTextWatcher addTheAniwaysTextWatcher() {
        return this.mAniwaysEditTextAndTextViewerCommonPart.addTheAniwaysTextWatcher();
    }

    @Override
    public IAniwaysTextWatcher removeTheAniwaysTextWatcher() {
        return this.mAniwaysEditTextAndTextViewerCommonPart.removeTheAniwaysTextWatcher();
    }

    protected void onDetachedFromWindow() {
        this.mAniwaysEditTextAndTextViewerCommonPart.onDetachFromWindow();
        super.onDetachedFromWindow();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mAniwaysEditTextAndTextViewerCommonPart.onLayoutCalled();
    }

    public void setDoNotShowIcons(boolean dontShow) {
        this.mAniwaysEditTextAndTextViewerCommonPart.mDoNotShowIcons = dontShow;
    }

    public void setUseSmallIcons(boolean use) {
        this.mUseSmallIcons = use;
    }

    public void setIconsClickable(boolean clickable) {
        this.mIconsClickable = clickable;
    }

    @Override
    public void registerSetTextListener(AniwaysMessageListViewItemWrapperLayout.OnSetTextListener textChangedListener) {
        this.mAniwaysEditTextAndTextViewerCommonPart.registerSetTextListener(textChangedListener);
    }

    @Override
    public void unregisterSetTextListener(AniwaysMessageListViewItemWrapperLayout.OnSetTextListener listener) {
        this.mAniwaysEditTextAndTextViewerCommonPart.unregisterSetTextListener(listener);
    }

    @Override
    public Point getPointOfPositionInText(int position, boolean fromTop) {
        return this.mAniwaysEditTextAndTextViewerCommonPart.getPointOfPositionInText(position, fromTop);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public AniwaysDynamicImageSpansContainer getDynamicImageSpansContainer() {
        return this.mAniwaysEditTextAndTextViewerCommonPart.getDynamicImageSpansContainer();
    }

    @Override
    public void removeTextWatchers() {
        this.mAniwaysEditTextAndTextViewerCommonPart.removeTextWatchers();
    }

    @Override
    public void addBackTheTextWatchers() {
        this.mAniwaysEditTextAndTextViewerCommonPart.addBackTheTextWatchers();
    }

    @Override
    public void onLoadedImageSuccessfuly() {
        this.mAniwaysEditTextAndTextViewerCommonPart.onLoadedImageSuccessfuly();
    }

    @Override
    public void onErrorLoadingImage() {
        this.mAniwaysEditTextAndTextViewerCommonPart.onErrorLoadingImage();
    }

    @Override
    public IIconInfoDisplayer getIconInfoDisplayer() {
        return this;
    }
}

