/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.graphics.Point;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.View;
import com.aniways.AniwaysEditTextAndTextViewCommonPart;
import com.aniways.AniwaysInternalIconInfoSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IIconInfoDisplayer;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.quick.action.ActionItem;
import com.aniways.quick.action.QuickAction;

public class AniwaysIconInfoDisplayer
implements IIconInfoDisplayer {
    private static final String TAG = "AniwaysIconInfoDisplayer";
    private QuickAction mQuickAction;

    @Override
    public void displayIconInfo(final AniwaysInternalIconInfoSpan infoSpan, IAniwaysTextContainer textContainer) {
        long startTime = System.currentTimeMillis();
        String origText = infoSpan.originalText;
        Phrase phrase = infoSpan.phrase;
        Spannable text = textContainer.getText();
        if (origText == null) {
            Log.w(true, TAG, "Original text is null. Taking part to replace. Phrase: " + phrase.toString() + ". Text: " + text);
            origText = phrase.getPartToReplace();
        }
        int[] startEnd = new int[]{text.getSpanStart((Object)infoSpan), text.getSpanEnd((Object)infoSpan)};
        Utils.setMaxMinStartEnd(startEnd);
        int start = startEnd[0];
        int end = startEnd[1];
        Point[] centerPoints = AniwaysEditTextAndTextViewCommonPart.calculateCenterPointsForAboveAndBelowLine(start, end, textContainer);
        if (centerPoints == null) {
            Log.w(true, TAG, "Not displaying icon info since cannot calculate center point of text in the control");
            return;
        }
        QuickAction quickAction = this.createAndSetNewQuickAction(textContainer.getView(), null, false);
        quickAction.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    infoSpan.setDismissEventTime(event.getEventTime());
                }
                return false;
            }
        });
        ActionItem item = new ActionItem(0, origText, null, null);
        quickAction.addActionIconInfo(item);
        quickAction.setOnActionItemClickListener(new QuickAction.OnActionItemClickListener(){

            @Override
            public void onItemClick(QuickAction quickAction, int pos, int actionId) {
                if (quickAction.isShowing().booleanValue()) {
                    // empty if block
                }
            }
        });
        String iconPath = infoSpan.icon.getFileName();
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display Icon Info", origText, iconPath, 0L);
        quickAction.showAndCloseAfterDelay(centerPoints[0], centerPoints[1], false);
        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Verbose, startTime, "Performance", "Display Icon Info", "", TAG, "");
    }

    QuickAction createAndSetNewQuickAction(View anchor, JsonParser parser, boolean showCreditsIfStoreIsEnabled) {
        if (this.mQuickAction != null && this.mQuickAction.isShowing().booleanValue()) {
            this.mQuickAction.dismiss();
        }
        this.mQuickAction = new QuickAction(anchor.getContext(), anchor, parser, showCreditsIfStoreIsEnabled, true, false);
        return this.mQuickAction;
    }
}

