/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Pair;
import com.aniways.AniwaysDecoderIconData;
import com.aniways.AniwaysDecoderResult;
import com.aniways.AniwaysEditText;
import com.aniways.AniwaysExternalIconInfoSpan;
import com.aniways.AniwaysImageSpan;
import com.aniways.AniwaysInternalIconInfoSpan;
import com.aniways.AniwaysLoadingImageSpan;
import com.aniways.AniwaysMarkerInserter;
import com.aniways.AniwaysSuggestionSpan;
import com.aniways.AniwaysSuggestionSpanForAutoreplace;
import com.aniways.AniwaysTextView;
import com.aniways.AssetType;
import com.aniways.EmojiWithVarientSelector;
import com.aniways.IAniwaysIconInfoSpan;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IAniwaysWordMarkerSpan;
import com.aniways.IIconInfoDisplayer;
import com.aniways.ISuggestionDisplayer;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.SpanStartSorter;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.data.PhraseWithPartToReplace;
import com.aniways.volley.toolbox.Volley;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;

public class AniwaysIconConverter {
    private static final String TAG = "AniwaysIconConverter";
    private static final int INDEX_NOT_FOUND = -1;
    private static final String SPACE = " ";

    static String encodeMessage(Spannable textWithIcons, Context context, boolean autoreplaceTextWithIcons, AniwaysPrivateConfig.IconEncodingMethod enforceIconEncodingMethod, boolean forceDoNotReplacePhraseWithEmoji) {
        long startTime = System.currentTimeMillis();
        String result = null;
        Log.d(TAG, "Start encode");
        if (autoreplaceTextWithIcons) {
            textWithIcons = Editable.Factory.getInstance().newEditable((CharSequence)textWithIcons);
            if (AniwaysPrivateConfig.getInstance().autoReplaceKeyPhrasesOnEncode) {
                Log.d(TAG, "Start autoreplace phrases on encode");
                AniwaysIconConverter.autoreplaceTextWithIcons(textWithIcons, context, null, false);
                Log.d(TAG, "End autoreplace phrases on encode");
            }
        }
        if (enforceIconEncodingMethod == null) {
            enforceIconEncodingMethod = AniwaysPrivateConfig.getInstance().iconEncodingMethod;
        }
        if (enforceIconEncodingMethod == AniwaysPrivateConfig.IconEncodingMethod.Invisible) {
            result = AniwaysIconConverter.replaceAniwaysIconsWithTextEncodedAsInvisible(textWithIcons, forceDoNotReplacePhraseWithEmoji);
        } else if (enforceIconEncodingMethod == AniwaysPrivateConfig.IconEncodingMethod.ViralLink) {
            result = AniwaysIconConverter.replaceAniwaysIconsWithTextEncodedAsInvisibleAndViralUrl(context, textWithIcons, forceDoNotReplacePhraseWithEmoji);
        } else {
            Log.e(true, TAG, "received illegal encoding method: " + (Object)((Object)AniwaysPrivateConfig.getInstance().iconEncodingMethod));
        }
        if (AnalyticsReporter.isInitialized()) {
            AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Statistical, startTime, "Performance", "Encode Message - " + (Object)((Object)AniwaysPrivateConfig.getInstance().iconEncodingMethod), String.valueOf(textWithIcons.length()), TAG, "num chars");
        }
        Log.d(TAG, "End encode");
        return result;
    }

    static void autoreplaceTextWithIcons(Spannable textWithIcons, Context context, IIconInfoDisplayer iconInfoDisplayer, boolean useSmallIcons) {
        Pattern autoreplacePattern = AniwaysPrivateConfig.getInstance().autoreplacePattern;
        if (autoreplacePattern != null) {
            HashSet<String> ignorePhrases = AniwaysPrivateConfig.getInstance().autoreplaceIgnorePhrases;
            JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
            AniwaysMarkerInserter.addSuggestionMarkersToText(textWithIcons, autoreplacePattern, ignorePhrases, parser);
            AniwaysSuggestionSpanForAutoreplace[] spans = (AniwaysSuggestionSpanForAutoreplace[])textWithIcons.getSpans(0, textWithIcons.length(), AniwaysSuggestionSpanForAutoreplace.class);
            if (spans != null && spans.length > 0) {
                for (AniwaysSuggestionSpanForAutoreplace span : spans) {
                    int start = textWithIcons.getSpanStart((Object)span);
                    Phrase phrase = span.phrase;
                    IconData[] potentialIcons = phrase.emoticonsPhraseAssetBuilder.icons;
                    ArrayList<IconData> icons = new ArrayList<IconData>();
                    for (IconData ic : potentialIcons) {
                        if (!ic.family.equals(AniwaysPrivateConfig.getInstance().autoReplaceEmoticonsInTextViewDefaultIconsFamily)) continue;
                        icons.add(ic);
                    }
                    if (!icons.isEmpty()) {
                        IconData icon = (IconData)icons.get(0);
                        Log.i(TAG, "Autoreplacing phrase: " + phrase + " with icon: " + icon.getFileName());
                        AniwaysIconConverter.insertAniwaysIconToText(context, textWithIcons, icon, start, phrase, null, iconInfoDisplayer, IAniwaysImageSpan.ImageSpanMetadata.Empty, false, useSmallIcons, false);
                        if (iconInfoDisplayer == null) continue;
                        textWithIcons.removeSpan((Object)span);
                        continue;
                    }
                    if (parser.getKeywordsVersion().equalsIgnoreCase("0.0")) {
                        Log.w(false, TAG, "Autoreplacement: No icons for replacement of phrase: " + phrase + ". Map version: " + parser.getKeywordsVersion());
                        continue;
                    }
                    Log.w(true, TAG, "Autoreplacement: No icons for replacement of phrase: " + phrase + ". Map version: " + parser.getKeywordsVersion());
                }
            }
        }
    }

    static void decodeMessage(Context context, final Editable text, final ISuggestionDisplayer suggestionDisplayer, final IIconInfoDisplayer iconInfoDisplayer, final IAniwaysTextContainer textContainer, JsonParser parser, final AniwaysPrivateConfig.IconEncodingMethod enforceIconDecodingMethod, final boolean useSmallIcons, final boolean isFromPaste, boolean useEmptyParser, final boolean fromTextWatcher) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (suggestionDisplayer == null) {
            AniwaysIconConverter.removeAllEditTextSpecificSpans((Spannable)text);
        }
        if (iconInfoDisplayer == null) {
            AniwaysIconConverter.removeAllTextViewSpecificSpans((Spannable)text);
        }
        AniwaysDecoderResult result = null;
        if (parser.isEmpty() && !useEmptyParser) {
            final Context appContext = context.getApplicationContext();
            AniwaysPhraseReplacementData.addOnNonEmptyParserSetListener(new AniwaysPhraseReplacementData.IOnNonEmptyParserSetListener(){

                @Override
                public void onNonEmptyParserSet(JsonParser newParser) {
                    if (textContainer == null) {
                        Log.e(true, AniwaysIconConverter.TAG, "Text container is null");
                    } else {
                        textContainer.removeTextWatchers();
                    }
                    AniwaysIconConverter.decodeMessage(appContext, text, suggestionDisplayer, iconInfoDisplayer, textContainer, newParser, enforceIconDecodingMethod, useSmallIcons, isFromPaste, true, fromTextWatcher);
                    if (textContainer != null) {
                        textContainer.addBackTheTextWatchers();
                    }
                }
            });
            Log.d(TAG, "Parser is empty, will decode again when there is a non empty one");
            return;
        }
        if (parser.isEmpty() && useEmptyParser) {
            Log.w(false, TAG, "Using empty parser to decode - might not get full functionality for message");
        }
        if (enforceIconDecodingMethod != null) {
            if (enforceIconDecodingMethod == AniwaysPrivateConfig.IconEncodingMethod.Invisible || enforceIconDecodingMethod == AniwaysPrivateConfig.IconEncodingMethod.ViralLink) {
                result = AniwaysIconConverter.insertAniwaysIconsToTextEncodedAsInvisible(context, text, suggestionDisplayer, iconInfoDisplayer, parser, useSmallIcons, isFromPaste, fromTextWatcher);
            } else {
                Log.e(true, TAG, "received illegal encoding method: " + (Object)((Object)enforceIconDecodingMethod));
            }
        } else if (AniwaysPrivateConfig.getInstance().useOnlyConfiguredEncodingMethodForDecoding) {
            if (AniwaysPrivateConfig.getInstance().iconEncodingMethod == AniwaysPrivateConfig.IconEncodingMethod.Invisible) {
                result = AniwaysIconConverter.insertAniwaysIconsToTextEncodedAsInvisible(context, text, suggestionDisplayer, iconInfoDisplayer, parser, useSmallIcons, isFromPaste, fromTextWatcher);
            } else {
                Log.e(true, TAG, "received illegal encoding method: " + (Object)((Object)AniwaysPrivateConfig.getInstance().iconEncodingMethod));
            }
        } else {
            result = AniwaysIconConverter.insertAniwaysIconsToTextEncodedAsInvisible(context, text, suggestionDisplayer, iconInfoDisplayer, parser, useSmallIcons, isFromPaste, fromTextWatcher);
        }
        if (result == null || result.getError() != null) {
            Log.w(false, TAG, "Could not decode message: " + text + ". Parser version: " + parser.getKeywordsVersion() + ". Because: " + (result != null && result.getError() != null ? result.getError().message : "result is null"));
        }
    }

    static void insertAniwaysIconToText(Context context, Spannable spannable, AniwaysSuggestionSpan suggestionSpan, IconData icon, IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata, boolean useSmallIcons) {
        int[] startEnd = new int[]{spannable.getSpanStart((Object)suggestionSpan), spannable.getSpanEnd((Object)suggestionSpan)};
        int startOfReplacementText = startEnd[0];
        ISuggestionDisplayer suggestionDisplayer = suggestionSpan.suggestionDisplayer;
        AniwaysIconConverter.insertAniwaysIconToText(context, spannable, icon, startOfReplacementText, suggestionSpan.phrase, suggestionDisplayer, null, imageSpanMetadata, false, useSmallIcons, false);
    }

    static int insertAniwaysIconToText(Context context, Spannable spannable, IconData icon, int startOfReplacementText, Phrase phrase, ISuggestionDisplayer suggestionDisplayer, IIconInfoDisplayer iconInfoDisplayer, IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata, boolean addSuggestionSpan, boolean useSmallIcons, boolean expectUnicode) {
        int end = 0;
        int lengthDifference = 0;
        String originalText = null;
        if (expectUnicode) {
            end = startOfReplacementText + icon.getUnicodeToReplaceText().length();
            originalText = phrase.getPartToReplace();
        } else {
            end = startOfReplacementText + phrase.getLengthOfPartToReplace();
            originalText = spannable.subSequence(startOfReplacementText, end).toString();
        }
        AniwaysSuggestionSpan suggestionSpan = null;
        IAniwaysIconInfoSpan infoSpan = null;
        if (suggestionDisplayer != null && addSuggestionSpan) {
            suggestionSpan = new AniwaysSuggestionSpan(phrase, suggestionDisplayer, originalText);
        }
        if (iconInfoDisplayer != null) {
            infoSpan = icon.hasExternalData() ? new AniwaysExternalIconInfoSpan(icon, context) : new AniwaysInternalIconInfoSpan(phrase, icon, iconInfoDisplayer, originalText);
        }
        IAniwaysWordMarkerSpan[] bcs = (IAniwaysWordMarkerSpan[])spannable.getSpans(startOfReplacementText, end, IAniwaysWordMarkerSpan.class);
        IAniwaysImageSpan[] iss = (IAniwaysImageSpan[])spannable.getSpans(startOfReplacementText, end, IAniwaysImageSpan.class);
        if (bcs != null && bcs.length > 0) {
            for (IAniwaysWordMarkerSpan iAniwaysWordMarkerSpan : bcs) {
                if (Utils.isSpanAdjacentToRange(spannable, startOfReplacementText, end, iAniwaysWordMarkerSpan)) continue;
                spannable.removeSpan((Object)iAniwaysWordMarkerSpan);
            }
        }
        if (iss != null && iss.length > 0) {
            for (IAniwaysImageSpan iAniwaysImageSpan : iss) {
                if (Utils.isSpanAdjacentToRange(spannable, startOfReplacementText, end, iAniwaysImageSpan)) continue;
                spannable.removeSpan((Object)iAniwaysImageSpan);
            }
        }
        AniwaysImageSpan is = null;
        int maxWidth = 0;
        int maxHeight = 0;
        AniwaysPrivateConfig aniwaysPrivateConfig = AniwaysPrivateConfig.getInstance();
        boolean displayBig = false;
        if (useSmallIcons || aniwaysPrivateConfig.useSmallIcon(icon)) {
            maxWidth = AniwaysPrivateConfig.getInstance().smallIconTextWidth;
            maxHeight = AniwaysPrivateConfig.getInstance().smallIconTextHeight;
        } else if (suggestionDisplayer != null) {
            maxWidth = aniwaysPrivateConfig.iconInEditTextWidth;
            maxHeight = aniwaysPrivateConfig.iconInEditTextHeight;
        } else if (iconInfoDisplayer != null) {
            if (startOfReplacementText == 0 && (end == spannable.length() || end == spannable.length() - 1 && spannable.subSequence(spannable.length() - 1, spannable.length()).toString().equals(SPACE)) && aniwaysPrivateConfig.makeStandaloneIconsBigger && aniwaysPrivateConfig.canBeDisplayedBig(icon)) {
                maxWidth = aniwaysPrivateConfig.bigIconWidth;
                maxHeight = aniwaysPrivateConfig.bigIconHeight;
                displayBig = true;
            } else {
                maxWidth = aniwaysPrivateConfig.iconInTextViewWidth;
                maxHeight = aniwaysPrivateConfig.iconInTextViewHeight;
            }
        } else {
            Bitmap tmpBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)17301558);
            is = new AniwaysImageSpan(tmpBitmap, phrase, icon, imageSpanMetadata.iconSelectionOrigin, context, 1, 1);
            lengthDifference = AniwaysIconConverter.addSpans(spannable, startOfReplacementText, end, suggestionSpan, infoSpan, is, !expectUnicode);
            return lengthDifference;
        }
        String url = aniwaysPrivateConfig.getIconUrl(icon, displayBig, false);
        Object data = Volley.getImageLoader().getCached(url, aniwaysPrivateConfig.getMaxWidthForCache(icon), aniwaysPrivateConfig.getMaxHeightForCache(icon), icon.getFileName());
        if (data != null) {
            Log.v(TAG, "Creating image span from cached image to: " + icon.getFileName());
            is = icon.createImageSpan(data, phrase, imageSpanMetadata.iconSelectionOrigin, context, maxWidth, maxHeight, iconInfoDisplayer);
            lengthDifference = AniwaysIconConverter.addSpans(spannable, startOfReplacementText, end, suggestionSpan, infoSpan, is, !expectUnicode);
        } else {
            Log.v(TAG, "Getting image from network: " + icon.getFileName());
            float textSizeRawPixels = -1.0f;
            if (suggestionDisplayer == null && suggestionSpan != null) {
                suggestionDisplayer = suggestionSpan.suggestionDisplayer;
            }
            AniwaysEditText editText = null;
            if (suggestionDisplayer != null) {
                editText = (AniwaysEditText)suggestionDisplayer;
                textSizeRawPixels = editText.getTextSize();
            } else if (iconInfoDisplayer != null && iconInfoDisplayer instanceof AniwaysTextView) {
                textSizeRawPixels = ((AniwaysTextView)iconInfoDisplayer).getTextSize();
            }
            AniwaysLoadingImageSpan lis = new AniwaysLoadingImageSpan(maxWidth, maxHeight, context, phrase, icon, imageSpanMetadata, textSizeRawPixels);
            lis.setImageUrl(url, Volley.getImageLoader(), aniwaysPrivateConfig.getMaxWidthForCache(icon), aniwaysPrivateConfig.getMaxHeightForCache(icon));
            lengthDifference = AniwaysIconConverter.addSpans(spannable, startOfReplacementText, end, suggestionSpan, infoSpan, lis, !expectUnicode);
            if (editText != null) {
                IAniwaysTextContainer textContainer = editText.getTextContainer();
                textContainer.getDynamicImageSpansContainer().addDynamicImageSpan(lis);
            }
        }
        return lengthDifference;
    }

    private static int addSpans(Spannable spannable, int start, int end, AniwaysSuggestionSpan suggestionSpan, IAniwaysIconInfoSpan infoSpan, IAniwaysImageSpan is, boolean replaceTextWithUnicode) {
        int lengthDifference = 0;
        if (replaceTextWithUnicode) {
            String replacementUnicode = is.getIcon().getUnicodeToReplaceText();
            ((Editable)spannable).replace(start, end, (CharSequence)replacementUnicode);
            int origLength = end - start;
            lengthDifference = replacementUnicode.length() - origLength;
            end = start + replacementUnicode.length();
        }
        if (suggestionSpan != null) {
            spannable.setSpan((Object)suggestionSpan, start, end, 33);
        }
        if (infoSpan != null) {
            spannable.setSpan((Object)infoSpan, start, end, 33);
        }
        spannable.setSpan((Object)is, start, end, 33);
        return lengthDifference;
    }

    private static String replaceAniwaysIconsWithTextEncodedAsInvisible(Spannable spannable, boolean forceDoNotReplacePhraseWithEmoji) {
        AniwaysDecoderResult decoderResult = AniwaysIconConverter.encodeInternal(spannable, true);
        return AniwaysIconConverter.encodeAniwaysMessageV2(decoderResult, forceDoNotReplacePhraseWithEmoji, false, false);
    }

    private static IAniwaysImageSpan[] getAllAniwaysContentInMessage(Spannable spannable) {
        return (IAniwaysImageSpan[])spannable.getSpans(0, spannable.length(), IAniwaysImageSpan.class);
    }

    private static boolean doesMessageContainAniwaysContent(Spannable spannable) {
        IAniwaysImageSpan[] aiss = AniwaysIconConverter.getAllAniwaysContentInMessage(spannable);
        return aiss != null && aiss.length > 0;
    }

    private static String replaceAniwaysIconsWithTextEncodedAsInvisibleAndViralUrl(Context context, Spannable spannable, boolean forceDoNotReplacePhraseWithEmoji) {
        Phrase p;
        if (!AniwaysIconConverter.doesMessageContainAniwaysContent(spannable)) {
            return AniwaysIconConverter.replaceAniwaysIconsWithTextEncodedAsInvisible(spannable, forceDoNotReplacePhraseWithEmoji);
        }
        Editable editable = Editable.Factory.getInstance().newEditable((CharSequence)spannable);
        AniwaysPrivateConfig privateConfigInstance = AniwaysPrivateConfig.getInstance();
        IconData iconData = new IconData(privateConfigInstance.viralLinkImageId, null, false, null, null, AssetType.Emoticons, IAniwaysImageSpan.AssetProvider.Aniways, false);
        iconData.primaryPhrase = p = new Phrase(AniwaysIconConverter.createViralMessage(privateConfigInstance), iconData);
        editable.append((CharSequence)AniwaysIconConverter.createViralMessage(privateConfigInstance));
        AniwaysIconConverter.insertAniwaysIconToText(context, (Spannable)editable, iconData, spannable.length(), p, null, null, IAniwaysImageSpan.ImageSpanMetadata.Empty, false, false, false);
        return AniwaysIconConverter.replaceAniwaysIconsWithTextEncodedAsInvisible((Spannable)editable, forceDoNotReplacePhraseWithEmoji);
    }

    private static String createViralMessage(AniwaysPrivateConfig privateConfigInstance) {
        return privateConfigInstance.viralMessage + privateConfigInstance.viralUrl;
    }

    private static AniwaysDecoderResult encodeInternal(Spannable spannable, boolean expectSuggestionSpans) {
        String origString = spannable.toString();
        AniwaysPrivateConfig cfg = AniwaysPrivateConfig.getInstance();
        AniwaysDecoderResult decoderResult = new AniwaysDecoderResult(Editable.Factory.getInstance().newEditable((CharSequence)origString));
        IAniwaysImageSpan[] imageSpans = AniwaysIconConverter.getAllAniwaysContentInMessage(spannable);
        if (imageSpans == null || imageSpans.length == 0) {
            return decoderResult;
        }
        Arrays.sort(imageSpans, new SpanStartSorter(spannable));
        for (IAniwaysImageSpan span : imageSpans) {
            int phraseNameLengthAfterReplacedPart;
            int start = spannable.getSpanStart((Object)span);
            int end = spannable.getSpanEnd((Object)span);
            int[] startEnd = new int[]{start, end};
            start = startEnd[0];
            end = startEnd[1];
            String phraseName = span.getPhrase().getName().toLowerCase(Locale.US);
            String replacedString = span.getPhrase().getPartToReplace().toLowerCase(Locale.US);
            String originalText = null;
            AniwaysSuggestionSpan[] suggestionSpans = (AniwaysSuggestionSpan[])spannable.getSpans(start, end, AniwaysSuggestionSpan.class);
            if (suggestionSpans != null && suggestionSpans.length > 0) {
                for (AniwaysSuggestionSpan ss : suggestionSpans) {
                    int ssStart = spannable.getSpanStart((Object)ss);
                    int ssEnd = spannable.getSpanEnd((Object)ss);
                    if (ssStart != start || ssEnd != end) continue;
                    originalText = ss.originalText;
                    break;
                }
            }
            if (span.getIcon().id == cfg.viralLinkImageId) {
                originalText = AniwaysIconConverter.createViralMessage(cfg);
            } else if (span.getIcon().id == cfg.animatedGifImageId) {
                originalText = span.getIcon().getUnicodeToReplaceText();
            } else if (originalText == null) {
                if (span.getImageSpanMetadata().iconSelectionOrigin == IAniwaysImageSpan.IconSelectionOrigin.OtherKeyboard) {
                    originalText = spannable.subSequence(start, end).toString();
                    if (cfg.makeNonAniwaysIconsSmart) {
                        Log.w(true, TAG, "No original text in app icon, although, making non Aniways icons Smart. Phrase: " + span.getPhrase().toString());
                    }
                } else {
                    if (expectSuggestionSpans) {
                        Log.w(true, TAG, "No original text, using phrase part to replace: " + span.getPhrase().toString());
                    }
                    originalText = replacedString;
                }
            } else if (!replacedString.equalsIgnoreCase(originalText)) {
                Log.w(true, TAG, "Original text != part to replace. Orig: " + originalText + ". Part to replace: " + replacedString);
                originalText = replacedString;
            }
            int indexOfreplacedPart = phraseName.indexOf(replacedString);
            int phraseStartIndex = start - indexOfreplacedPart;
            if (phraseStartIndex < 0) {
                phraseName = replacedString;
                phraseStartIndex = start;
            }
            if (end + (phraseNameLengthAfterReplacedPart = phraseName.length() - (indexOfreplacedPart + replacedString.length())) > spannable.length()) {
                phraseName = replacedString;
                phraseStartIndex = start;
            }
            decoderResult.addIcon(phraseStartIndex, start, originalText, phraseName, span.getIcon(), span.getImageSpanMetadata().iconSelectionOrigin);
        }
        return decoderResult;
    }

    private static AniwaysDecoderResult insertAniwaysIconsToTextEncodedAsInvisible(Context context, Editable editable, ISuggestionDisplayer suggestionDisplayer, IIconInfoDisplayer iconInfoDisplayer, JsonParser parser, boolean useSmallIcons, boolean isFromPaste, boolean fromTextWatcher) {
        AniwaysDecoderResult result = AniwaysIconConverter.decodeAniwaysMessageV2(editable, null, parser);
        if (result.getError() != null) {
            Log.v(TAG, "Could not decode message as invisible because: " + result.getError().message, result.getError().exception);
            return result;
        }
        AniwaysIconConverter.decodeInternal(context, editable, suggestionDisplayer, iconInfoDisplayer, parser, result, useSmallIcons, isFromPaste, fromTextWatcher);
        return result;
    }

    private static void decodeInternal(Context context, Editable editable, ISuggestionDisplayer suggestionDisplayer, IIconInfoDisplayer iconInfoDisplayer, JsonParser parser, AniwaysDecoderResult result, boolean useSmallIcons, boolean isFromPaste, boolean fromTextWatcher) {
        if (result.getDeletes() != null && !result.getDeletes().isEmpty()) {
            for (Pair<Integer, Integer> delete : result.getDeletes()) {
                editable.delete(((Integer)delete.first).intValue(), ((Integer)delete.second).intValue());
            }
        }
        int offset = 0;
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        for (AniwaysDecoderIconData icon : result.getIcons()) {
            IAniwaysImageSpan[] imageSpans;
            int startIndex = icon.subphraseStartIndex + offset;
            String replacementText = icon.replacementText;
            int endIndex = startIndex + replacementText.length();
            Boolean set = true;
            for (IAniwaysImageSpan span : imageSpans = (IAniwaysImageSpan[])editable.getSpans(startIndex, endIndex, IAniwaysImageSpan.class)) {
                if (editable.getSpanStart((Object)span) < startIndex || editable.getSpanEnd((Object)span) > endIndex) {
                    set = false;
                    break;
                }
                editable.removeSpan((Object)span);
            }
            if (!set.booleanValue() || icon.icon == null) continue;
            Phrase phrase = parser.getPhraseByName(icon.phraseName);
            if (phrase == null) {
                if (icon.icon.hasEmojiFallback() && icon.phraseName != null && icon.phraseName.length() < 5) {
                    if (icon.icon.primaryPhrase == null || !icon.icon.primaryPhrase.isFullReplacement()) {
                        Log.w(true, TAG, "Icon with emoji fallback doesn't have a full replacement phrase . Id: " + icon.icon.id);
                        continue;
                    }
                    phrase = icon.icon.primaryPhrase;
                    String phraseName = icon.icon.primaryPhrase.getName();
                    editable.replace(startIndex, endIndex, (CharSequence)phraseName);
                    offset -= endIndex - startIndex;
                    offset += phraseName.length();
                } else {
                    Log.i(TAG, "received phrase name which is not present in the map: " + icon.phraseName + " Map version: " + parser.getKeywordsVersion());
                    phrase = new PhraseWithPartToReplace(icon.phraseName, icon.replacementText, icon.icon);
                }
            }
            IAniwaysImageSpan.ImageSpanMetadata meta = new IAniwaysImageSpan.ImageSpanMetadata(isFromPaste ? IAniwaysImageSpan.IconSelectionOrigin.Paste : IAniwaysImageSpan.IconSelectionOrigin.Unknown, icon.icon.assetType, icon.icon.assetProvider);
            offset += AniwaysIconConverter.insertAniwaysIconToText(context, (Spannable)editable, icon.icon, startIndex, phrase, suggestionDisplayer, iconInfoDisplayer, meta, config.makeNonAniwaysIconsSmart, useSmallIcons, false);
        }
        AniwaysIconConverter.handleUncoveredEmoji(editable, 0, editable.length(), parser, context, suggestionDisplayer, iconInfoDisplayer, useSmallIcons, isFromPaste, fromTextWatcher);
        if (AnalyticsReporter.isInitialized()) {
            // empty if block
        }
    }

    static boolean handleUncoveredEmoji(Editable text, int start, int end, JsonParser parser, Context context, ISuggestionDisplayer suggestionDisplayer, IIconInfoDisplayer iconInfoDisplayer, boolean useSmallIcons, boolean fromPaste, boolean fromTextWatcher) {
        int skip;
        boolean result = false;
        if (start > 0 && end > start && Character.isLowSurrogate(text.charAt(start))) {
            --start;
        }
        if (end > 0 && end < text.length() && Character.isHighSurrogate(text.charAt(end - 1))) {
            ++end;
        }
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        for (int i = start; i < end; i += skip) {
            skip = 0;
            IconData icon = null;
            if (icon == null) {
                int nextUnicode;
                int unicode = Character.codePointAt((CharSequence)text, i);
                skip = Character.charCount(unicode);
                if (unicode > 255) {
                    icon = parser.getEmoji(unicode);
                }
                boolean secondUnicodeExists = false;
                int followUnicode = -1;
                if (icon == null && i + skip < end && (icon = parser.getEmoji(new int[]{unicode, followUnicode = Character.codePointAt((CharSequence)text, i + skip)})) != null) {
                    secondUnicodeExists = true;
                    skip += Character.charCount(followUnicode);
                }
                if (icon != null && i + skip < end && (nextUnicode = Character.codePointAt((CharSequence)text, i + skip)) == EmojiWithVarientSelector.EMOJI_VARIENT_SELECTOR) {
                    IconData oldIcon = icon;
                    icon = secondUnicodeExists ? parser.getEmojiWithVarientSelector(new int[]{unicode, followUnicode}) : parser.getEmojiWithVarientSelector(unicode);
                    if (icon == null) {
                        icon = new EmojiWithVarientSelector(oldIcon);
                        parser.addEmojiWithVarientSelector(icon);
                    }
                    skip += Character.charCount(nextUnicode);
                }
            }
            if (icon == null) continue;
            boolean isCovering = false;
            IAniwaysImageSpan[] spans = (IAniwaysImageSpan[])text.getSpans(i, i + skip, IAniwaysImageSpan.class);
            if (spans != null && spans.length > 0) {
                for (IAniwaysImageSpan span : spans) {
                    int startSpan = text.getSpanStart((Object)span);
                    int endSpan = text.getSpanEnd((Object)span);
                    if (startSpan == i + skip || endSpan == i) continue;
                    isCovering = true;
                }
            }
            if (isCovering || icon.primaryPhrase == null || !icon.primaryPhrase.isFullReplacement()) continue;
            IAniwaysImageSpan.ImageSpanMetadata meta = new IAniwaysImageSpan.ImageSpanMetadata(fromPaste ? IAniwaysImageSpan.IconSelectionOrigin.Paste : (fromTextWatcher ? IAniwaysImageSpan.IconSelectionOrigin.OtherKeyboard : IAniwaysImageSpan.IconSelectionOrigin.Unknown), icon.assetType, icon.assetProvider);
            AniwaysIconConverter.insertAniwaysIconToText(context, (Spannable)text, icon, i, icon.primaryPhrase, suggestionDisplayer, iconInfoDisplayer, meta, config.makeNonAniwaysIconsSmart, useSmallIcons, true);
            result = true;
        }
        return result;
    }

    private static String safeSubstring(String text, int start, String expected) {
        try {
            String substring = text.substring(start, start + expected.length());
            if (!substring.equalsIgnoreCase(expected)) {
                throw new Exception("Expected != substring. Expected: " + expected + ". Substring: " + substring);
            }
            return substring;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Error in safe substring. Text: " + text + ". start: " + start + " . Length: " + (expected == null ? "NULL" : Integer.valueOf(expected.length())) + ". Expected: " + expected);
            return expected;
        }
    }

    private static String encodeAniwaysMessageV2(AniwaysDecoderResult decoderResult, boolean forceDoNotReplacePhraseWithEmoji, boolean justBringBackOriginalText, boolean alsoConvertNonContextualIconsToText) {
        String result = decoderResult.getMessage().toString();
        AniwaysPrivateConfig cfg = AniwaysPrivateConfig.getInstance();
        Log.d(TAG, "Encoding message: " + result);
        Log.d(TAG, "Encoding message params: cfg.encodeEmojisWithEmojiUnicode: " + cfg.encodeEmojisWithEmojiUnicode + ". cfg.encodeIconsWithEmojiReplacementWithEmojiUnicode: " + cfg.encodeIconsWithEmojiReplacementWithEmojiUnicode + ". forceDoNotReplacePhraseWithEmoji: " + forceDoNotReplacePhraseWithEmoji + ". justBringBackOriginalText: " + justBringBackOriginalText);
        if (decoderResult.getIcons().isEmpty()) {
            Log.d(TAG, "No icons to encode. Returning");
            return result;
        }
        int offset = 0;
        for (AniwaysDecoderIconData icon : decoderResult.getIcons()) {
            int decoderRadix;
            int subphraseInsidePhraseIndex;
            String emojiUnicode;
            String replacementUnicode;
            String phraseName = icon.phraseName;
            String replacedString = icon.replacementText;
            IconData iconData = icon.icon;
            if (iconData == null) {
                Log.e(true, TAG, "No icon id found for icon: " + icon);
                continue;
            }
            int offsetToAdd = 0;
            if (icon.icon.id == cfg.animatedGifImageId) {
                Log.d(TAG, "Removing icon for Animated gif: " + icon + ". Offset: " + offset + ". Message: " + result);
                replacementUnicode = icon.icon.getUnicodeToReplaceText();
                Log.d(TAG, "icon for Animated gif. Unicode: " + replacementUnicode + ". text: " + replacedString + ". Actual string there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, replacementUnicode));
                result = AniwaysIconConverter.replaceAtLocation(result, icon.subphraseStartIndex + offset, replacementUnicode.length(), "");
                offsetToAdd -= replacementUnicode.length();
                if (icon.phraseStartIndex > 0 && result.subSequence(icon.phraseStartIndex - 1 + offset, icon.phraseStartIndex + offset).toString().equalsIgnoreCase(SPACE)) {
                    result = AniwaysIconConverter.replaceAtLocation(result, icon.phraseStartIndex - 1 + offset, 1, "");
                    --offsetToAdd;
                }
                offset += offsetToAdd;
                continue;
            }
            if (justBringBackOriginalText) {
                if (IAniwaysImageSpan.IconSelectionOrigin.isFromContextualReplacement(icon.selectionOrigin)) {
                    replacementUnicode = icon.icon.getUnicodeToReplaceText();
                    Log.d(TAG, "Replacing emoji unicode back to text. Unicode: " + replacementUnicode + ". text: " + replacedString + ". Actual string there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, replacementUnicode));
                    result = AniwaysIconConverter.replaceAtLocation(result, icon.subphraseStartIndex + offset, replacementUnicode.length(), replacedString);
                    offsetToAdd -= replacementUnicode.length();
                    offsetToAdd += replacedString.length();
                } else if (alsoConvertNonContextualIconsToText) {
                    if (!icon.icon.hasEmojiFallback()) {
                        replacementUnicode = icon.icon.getUnicodeToReplaceText();
                        Log.d(TAG, "Replacing emoji unicode back to text. Unicode: " + replacementUnicode + ". text: " + replacedString + ". Actual string there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, replacementUnicode));
                        result = AniwaysIconConverter.replaceAtLocation(result, icon.subphraseStartIndex + offset, replacementUnicode.length(), replacedString);
                        offsetToAdd -= replacementUnicode.length();
                        offsetToAdd += replacedString.length();
                    }
                } else {
                    replacementUnicode = icon.icon.getUnicodeToReplaceText();
                    Log.d(TAG, "removing non contextual icon. Unicode: " + replacementUnicode + ". text: " + replacedString + ". Actual string there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, replacementUnicode));
                    result = AniwaysIconConverter.replaceAtLocation(result, icon.subphraseStartIndex + offset, replacementUnicode.length(), "");
                    offsetToAdd -= replacementUnicode.length();
                }
                offset += offsetToAdd;
                continue;
            }
            Log.d(TAG, "Encoding icon: " + icon + ". Offset: " + offset + ". Message: " + result);
            if (icon.icon.assetType == AssetType.Emoji && cfg.encodeEmojisWithEmojiUnicode) {
                if (forceDoNotReplacePhraseWithEmoji && !justBringBackOriginalText) {
                    replacementUnicode = icon.icon.getUnicodeToReplaceText();
                    Log.d(TAG, "Replacing emoji unicode back to text. Unicode: " + replacementUnicode + ". text: " + phraseName + ". Actual string there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, replacementUnicode));
                    result = AniwaysIconConverter.replaceAtLocation(result, icon.subphraseStartIndex + offset, replacementUnicode.length(), phraseName);
                    offsetToAdd -= replacementUnicode.length();
                    offsetToAdd += phraseName.length();
                } else {
                    Log.d(TAG, "Leaving emoji as is: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, icon.icon.getUnicodeRepresentation()));
                    emojiUnicode = icon.icon.getUnicodeRepresentation();
                    subphraseInsidePhraseIndex = icon.subphraseStartIndex - icon.phraseStartIndex;
                    try {
                        phraseName = AniwaysIconConverter.replaceAtLocation(phraseName, subphraseInsidePhraseIndex, replacedString.length(), emojiUnicode);
                        Log.d(TAG, "Converting subphrase to emoji unicode: Phrase name: " + phraseName + ". Part to replace: " + replacedString + ". Emoji unicode: " + emojiUnicode + ". Emoji unicode there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, emojiUnicode));
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        Log.e(true, TAG, "Caught a StringIndexOutOfBoundsException. PN: " + phraseName + ". RS: " + replacedString + ". phrase index: " + icon.phraseStartIndex + ". Subphrase index: " + icon.subphraseStartIndex, ex);
                        continue;
                    }
                    replacedString = emojiUnicode;
                }
            } else if (icon.icon.hasEmojiFallback() && cfg.encodeIconsWithEmojiReplacementWithEmojiUnicode && !forceDoNotReplacePhraseWithEmoji) {
                emojiUnicode = icon.icon.getUnicodeRepresentation();
                subphraseInsidePhraseIndex = icon.subphraseStartIndex - icon.phraseStartIndex;
                try {
                    phraseName = AniwaysIconConverter.replaceAtLocation(phraseName, subphraseInsidePhraseIndex, replacedString.length(), emojiUnicode);
                    Log.d(TAG, "Converting subphrase to emoji unicode: Phrase name: " + phraseName + ". Part to replace: " + replacedString + ". Emoji unicode: " + emojiUnicode + ". Emoji unicode there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, emojiUnicode));
                }
                catch (StringIndexOutOfBoundsException ex) {
                    Log.e(true, TAG, "Caught a StringIndexOutOfBoundsException. PN: " + phraseName + ". RS: " + replacedString + ". phrase index: " + icon.phraseStartIndex + ". Subphrase index: " + icon.subphraseStartIndex, ex);
                    continue;
                }
                replacedString = emojiUnicode;
            } else {
                replacementUnicode = icon.icon.getUnicodeToReplaceText();
                Log.d(TAG, "Replacing emoji unicode back to text. Unicode: " + replacementUnicode + ". text: " + replacedString + ". Actual string there: " + AniwaysIconConverter.safeSubstring(result, icon.subphraseStartIndex + offset, replacementUnicode));
                result = AniwaysIconConverter.replaceAtLocation(result, icon.subphraseStartIndex + offset, replacementUnicode.length(), replacedString);
                offsetToAdd -= replacementUnicode.length();
                offsetToAdd += replacedString.length();
            }
            String iconIdString = Integer.toString(icon.icon.id, AniwaysPrivateConfig.getInstance().decoderRadix);
            int l = iconIdString.length();
            int baseChunkSize = AniwaysPrivateConfig.getInstance().decoderChunkSize;
            int length = l + 1;
            int numberOfNeededChunks = (int)Math.ceil((float)length / (float)baseChunkSize);
            int maxPossibleChunks = decoderRadix = AniwaysPrivateConfig.getInstance().decoderRadix;
            String lengthBit = Integer.toString(numberOfNeededChunks - 1, decoderRadix);
            if (numberOfNeededChunks > maxPossibleChunks) {
                Log.e(true, TAG, "Id is too long: " + iconIdString);
            }
            int sequenceLength = numberOfNeededChunks * baseChunkSize;
            for (int i = iconIdString.length(); i < sequenceLength - 1; ++i) {
                iconIdString = '0' + iconIdString;
            }
            iconIdString = lengthBit + iconIdString;
            String[] codepointStrings = AniwaysPrivateConfig.getInstance().decoderCodepointStrings;
            for (int i = 0; i < decoderRadix; ++i) {
                iconIdString = iconIdString.replace(Integer.toString(i, decoderRadix), codepointStrings[i]);
            }
            result = AniwaysIconConverter.insertToString(result, iconIdString, icon.phraseStartIndex + offset);
            String delimiter = AniwaysPrivateConfig.getInstance().delimiterString;
            result = AniwaysIconConverter.insertToString(result, delimiter, icon.subphraseStartIndex + (offset += iconIdString.length()));
            result = AniwaysIconConverter.insertToString(result, delimiter, icon.subphraseStartIndex + (offset += delimiter.length()) + replacedString.length());
            result = AniwaysIconConverter.insertToString(result, delimiter, icon.phraseStartIndex + (offset += delimiter.length()) + phraseName.length());
            offset += delimiter.length();
            offset += offsetToAdd;
        }
        Log.d(TAG, "Returning encoded message: " + result);
        return result;
    }

    protected static String replaceAtLocation(String str, int index, int length, String stringToInsert) {
        String beforeRemove = str.substring(0, index);
        String afterRemove = str.substring(index + length);
        str = beforeRemove + stringToInsert + afterRemove;
        return str;
    }

    private static String insertToString(String source, String insert, int position) {
        String before = source.substring(0, position);
        String after = source.substring(position);
        source = before + insert + after;
        return source;
    }

    private static AniwaysDecoderResult decodeAniwaysMessageV2(Editable message, AniwaysDecoderResult result, JsonParser parser) {
        String messageString;
        int iconIdSequenceLocation;
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        if (result == null) {
            result = new AniwaysDecoderResult(message);
        }
        while ((iconIdSequenceLocation = AniwaysIconConverter.indexOfAny(messageString = (message = Editable.Factory.getInstance().newEditable((CharSequence)result.getMessage())).toString(), AniwaysPrivateConfig.getInstance().decoderCodepointStrings)) >= 0) {
            String lengthBitString = messageString.substring(iconIdSequenceLocation, iconIdSequenceLocation + 1);
            int lengthBit = AniwaysIconConverter.parseUnicodeCharsToInt(result, lengthBitString) + 1;
            int sequenceLength = AniwaysPrivateConfig.getInstance().decoderChunkSize * lengthBit;
            int encodeSequenceLocationEnd = iconIdSequenceLocation + sequenceLength;
            if (messageString.length() < encodeSequenceLocationEnd) {
                result.setError("Received editable with sequence end out of the string: " + message.toString());
                break;
            }
            String encodingString = messageString.substring(iconIdSequenceLocation + 1, encodeSequenceLocationEnd);
            int iconId = AniwaysIconConverter.parseUnicodeCharsToInt(result, encodingString);
            if (result.getError() != null) break;
            if (iconId < 0) {
                result.setError("Length < 0:" + message);
                break;
            }
            int startPhraseIndex = iconIdSequenceLocation;
            message = message.delete(iconIdSequenceLocation, encodeSequenceLocationEnd);
            result.addDelete(iconIdSequenceLocation, encodeSequenceLocationEnd);
            String delimiter = AniwaysPrivateConfig.getInstance().delimiterString;
            int startSubphraseIndex = message.toString().indexOf(delimiter);
            if (startSubphraseIndex == -1) {
                result.setError("Could not find startSubphrase:" + message);
                break;
            }
            message = message.delete(startSubphraseIndex, startSubphraseIndex + 1);
            result.addDelete(startSubphraseIndex, startSubphraseIndex + 1);
            int endSubphraseIndex = message.toString().indexOf(delimiter);
            if (endSubphraseIndex == -1) {
                result.setError("Could not find endSubphrase:" + message);
                break;
            }
            if (iconId == AniwaysPrivateConfig.getInstance().viralLinkImageId) {
                message = message.delete(startSubphraseIndex, endSubphraseIndex);
                result.addDelete(startSubphraseIndex, endSubphraseIndex);
                endSubphraseIndex = message.toString().indexOf(delimiter);
                if (endSubphraseIndex == -1) {
                    result.setError("Could not find endSubphrase:" + message);
                    break;
                }
            }
            message = message.delete(endSubphraseIndex, endSubphraseIndex + 1);
            result.addDelete(endSubphraseIndex, endSubphraseIndex + 1);
            int endPhraseIndex = message.toString().indexOf(delimiter);
            if (endPhraseIndex == -1) {
                result.setError("Could not find endPhrase:" + message);
                break;
            }
            message = message.delete(endPhraseIndex, endPhraseIndex + 1);
            result.addDelete(endPhraseIndex, endPhraseIndex + 1);
            if (iconId == AniwaysPrivateConfig.getInstance().viralLinkImageId) {
                result.setMessage(message);
                continue;
            }
            String replacementText = message.subSequence(startSubphraseIndex, endSubphraseIndex).toString();
            String phraseName = message.subSequence(startPhraseIndex, endPhraseIndex).toString();
            IconData icon = parser.getIconById(iconId);
            if (icon == null) {
                Log.v(TAG, "Could not find icon and phrase definitions for icon id: " + iconId + ". So, creating new ones. Message: " + message);
                icon = new IconData(iconId, "Unknown", false, null, null, AssetType.Emoticons, IAniwaysImageSpan.AssetProvider.Aniways, false);
                icon.primaryPhrase = new Phrase(phraseName, icon);
            }
            result.addIcon(startPhraseIndex, startSubphraseIndex, replacementText, phraseName.toLowerCase(Locale.US), icon, IAniwaysImageSpan.IconSelectionOrigin.Unknown);
            result.setMessage(message);
        }
        if (AnalyticsReporter.isInitialized()) {
            // empty if block
        }
        return result;
    }

    private static int indexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        int tmp = 0;
        for (String search : searchStrs) {
            if (search == null || (tmp = str.indexOf(search)) == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private static int parseUnicodeCharsToInt(AniwaysDecoderResult decoderResult, String source) {
        Integer result;
        block4: {
            int decoderRadix = AniwaysPrivateConfig.getInstance().decoderRadix;
            String[] codepointStrings = AniwaysPrivateConfig.getInstance().decoderCodepointStrings;
            String baseDecoderRadixString = source;
            for (int i = 0; i < decoderRadix; ++i) {
                baseDecoderRadixString = baseDecoderRadixString.replace(codepointStrings[i], Integer.toString(i, decoderRadix));
            }
            result = -1;
            if (baseDecoderRadixString.length() > 0) {
                try {
                    result = Integer.valueOf(baseDecoderRadixString, decoderRadix);
                }
                catch (NumberFormatException ex) {
                    if (decoderResult == null) break block4;
                    decoderResult.setError("Could not parse chars to int: " + source, ex);
                }
            }
        }
        return result;
    }

    static String getOriginalString(Spannable source, boolean alsoConvertNonContextualIconsToText, boolean expectSuggestionSpans) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        AniwaysDecoderResult decoderResult = AniwaysIconConverter.encodeInternal(source, expectSuggestionSpans);
        return AniwaysIconConverter.encodeAniwaysMessageV2(decoderResult, false, true, alsoConvertNonContextualIconsToText);
    }

    private static void removeAllTextViewSpecificSpans(Spannable spannable) {
        IAniwaysIconInfoSpan[] spans = (IAniwaysIconInfoSpan[])spannable.getSpans(0, spannable.length(), IAniwaysIconInfoSpan.class);
        if (spans == null || spans.length == 0) {
            return;
        }
        for (IAniwaysIconInfoSpan span : spans) {
            spannable.removeSpan((Object)span);
        }
    }

    private static void removeAllEditTextSpecificSpans(Spannable spannable) {
        IAniwaysWordMarkerSpan[] bcSpans = (IAniwaysWordMarkerSpan[])spannable.getSpans(0, spannable.length(), IAniwaysWordMarkerSpan.class);
        if (bcSpans == null || bcSpans.length == 0) {
            return;
        }
        for (IAniwaysWordMarkerSpan span : bcSpans) {
            spannable.removeSpan((Object)span);
        }
        AniwaysSuggestionSpan[] sSpans = (AniwaysSuggestionSpan[])spannable.getSpans(0, spannable.length(), AniwaysSuggestionSpan.class);
        if (sSpans == null || sSpans.length == 0) {
            return;
        }
        for (AniwaysSuggestionSpan span : sSpans) {
            spannable.removeSpan((Object)span);
        }
    }

    static void removeAllAniwaysSpans(Spannable spannable) {
        IAniwaysImageSpan[] iSpans;
        AniwaysSuggestionSpan[] sSpans;
        IAniwaysWordMarkerSpan[] bcSpans = (IAniwaysWordMarkerSpan[])spannable.getSpans(0, spannable.length(), IAniwaysWordMarkerSpan.class);
        if (bcSpans != null && bcSpans.length != 0) {
            for (IAniwaysWordMarkerSpan span : bcSpans) {
                spannable.removeSpan((Object)span);
            }
        }
        if ((sSpans = (AniwaysSuggestionSpan[])spannable.getSpans(0, spannable.length(), AniwaysSuggestionSpan.class)) != null && sSpans.length != 0) {
            for (AniwaysSuggestionSpan span : sSpans) {
                spannable.removeSpan((Object)span);
            }
        }
        if ((iSpans = (IAniwaysImageSpan[])spannable.getSpans(0, spannable.length(), IAniwaysImageSpan.class)) != null && iSpans.length != 0) {
            for (IAniwaysImageSpan span : iSpans) {
                spannable.removeSpan((Object)span);
            }
        }
    }

    public static String getAniwaysStickerUrl(CharSequence text) {
        int offset;
        long startTime = System.currentTimeMillis();
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        IconData icon = null;
        if (TextUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        int length = text.length();
        for (offset = 0; offset < length && text.charAt(offset) == ' '; ++offset) {
        }
        String string = text.subSequence(offset, length).toString();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int numIconsFound = 0;
        while (true) {
            int endPhraseIndex;
            String delimiter;
            int iconIdSequenceLocation;
            if ((iconIdSequenceLocation = AniwaysIconConverter.indexOfAny(string, AniwaysPrivateConfig.getInstance().decoderCodepointStrings)) != 0) {
                if (numIconsFound != 0) {
                    return null;
                }
                int skip = 0;
                int end = string.length() >= 6 ? 6 : (string.length() >= 4 ? 4 : (string.length() >= 2 ? 2 : 0));
                JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
                for (int i = 0; i < end; i += skip) {
                    int nextUnicode;
                    skip = 0;
                    if (icon != null) continue;
                    int unicode = Character.codePointAt(text, i);
                    skip = Character.charCount(unicode);
                    if (unicode > 255) {
                        icon = parser.getEmoji(unicode);
                    }
                    boolean secondUnicodeExists = false;
                    int followUnicode = -1;
                    if (icon == null && i + skip < end && (icon = parser.getEmoji(new int[]{unicode, followUnicode = Character.codePointAt(text, i + skip)})) != null) {
                        secondUnicodeExists = true;
                        skip += Character.charCount(followUnicode);
                    }
                    if (icon != null && i + skip < end && (nextUnicode = Character.codePointAt(text, i + skip)) == EmojiWithVarientSelector.EMOJI_VARIENT_SELECTOR) {
                        IconData oldIcon = icon;
                        icon = secondUnicodeExists ? parser.getEmojiWithVarientSelector(new int[]{unicode, followUnicode}) : parser.getEmojiWithVarientSelector(unicode);
                        if (icon == null) {
                            icon = new EmojiWithVarientSelector(oldIcon);
                            parser.addEmojiWithVarientSelector(icon);
                        }
                        skip += Character.charCount(nextUnicode);
                    }
                    if (icon != null) break;
                }
                if (icon == null) {
                    return null;
                }
                ++numIconsFound;
                string = string.substring(skip);
                if (!TextUtils.isEmpty((CharSequence)(string = string.trim()))) continue;
                break;
            }
            String lengthBitString = string.substring(iconIdSequenceLocation, iconIdSequenceLocation + 1);
            int lengthBit = AniwaysIconConverter.parseUnicodeCharsToInt(null, lengthBitString) + 1;
            int sequenceLength = AniwaysPrivateConfig.getInstance().decoderChunkSize * lengthBit;
            int encodeSequenceLocationEnd = iconIdSequenceLocation + sequenceLength;
            if (string.length() < encodeSequenceLocationEnd) {
                Log.w(true, TAG, "Received string with sequence end out of the string: " + string);
                return null;
            }
            String encodingString = string.substring(iconIdSequenceLocation + 1, encodeSequenceLocationEnd);
            int iconId = AniwaysIconConverter.parseUnicodeCharsToInt(null, encodingString);
            if (iconId < 0) {
                Log.w(true, TAG, "Length < 0: " + string);
                return null;
            }
            if (iconId == AniwaysPrivateConfig.getInstance().animatedGifImageId) {
                return null;
            }
            int startPhraseIndex = iconIdSequenceLocation;
            int startSubphraseIndex = (string = string.substring(encodeSequenceLocationEnd)).indexOf(delimiter = AniwaysPrivateConfig.getInstance().delimiterString);
            if (startSubphraseIndex == -1) {
                Log.w(true, TAG, "Could not find startSubphrase: " + string);
                return null;
            }
            int endSubphraseIndex = (string = string.substring(startSubphraseIndex + 1)).indexOf(delimiter);
            if (endSubphraseIndex == -1) {
                Log.w(true, TAG, "Could not find endSubphrase: " + string);
                return null;
            }
            if (iconId == AniwaysPrivateConfig.getInstance().viralLinkImageId) {
                string = string.substring(endSubphraseIndex);
                endSubphraseIndex = 0;
            }
            if ((endPhraseIndex = (string = string.substring(endSubphraseIndex + 1)).indexOf(delimiter)) == -1) {
                Log.w(true, TAG, "Could not find endPhrase: " + string);
                return null;
            }
            string = string.substring(endPhraseIndex + 1);
            if (iconId == AniwaysPrivateConfig.getInstance().viralLinkImageId) {
                if (!TextUtils.isEmpty((CharSequence)(string = string.trim())) || numIconsFound != 1) continue;
                break;
            }
            if (numIconsFound > 0) {
                return null;
            }
            icon = AniwaysPhraseReplacementData.getDataParser().getIconById(iconId);
            if (icon == null) {
                Log.v(TAG, "Could not find icon and phrase definitions for icon id: " + iconId + ". So, creating new ones. Message: " + string);
                icon = new IconData(iconId, "Unknown", false, null, null, AssetType.Emoticons, IAniwaysImageSpan.AssetProvider.Aniways, false);
                icon.primaryPhrase = new Phrase("unknown", icon);
            }
            if (icon.assetType != AssetType.Emoticons && icon.assetType != AssetType.Emoji) {
                return null;
            }
            ++numIconsFound;
            if (TextUtils.isEmpty((CharSequence)(string = string.trim()))) break;
        }
        if (AnalyticsReporter.isInitialized()) {
            AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Verbose, startTime, "Is Message Aniways Sticker", "Is Message Aniways Sticker", String.valueOf(length), TAG, "num chars");
        }
        return AniwaysPrivateConfig.getInstance().getIconUrl(icon, true, false);
    }
}

