/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.aniways.IAniwaysIconInfoSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;

public class AniwaysExternalIconInfoSpan
implements IAniwaysIconInfoSpan {
    private static final String TAG = "AniwaysExternalIconInfoSpan";
    private long dismissEventTime = -2L;
    private Context mContext;
    private String mExternalActivityPackage;
    private String mExternalWebsite;
    private IconData iconData;

    public AniwaysExternalIconInfoSpan(IconData icon, Context context) {
        this.mContext = context;
        this.mExternalActivityPackage = icon.getExternalActivityPackage();
        this.mExternalWebsite = icon.getExternalWebsite();
        this.iconData = icon;
    }

    @Override
    public void onClick(IAniwaysTextContainer textContainer, long clickEventTime) {
        try {
            if (this.dismissEventTime != clickEventTime) {
                if (!TextUtils.isEmpty((CharSequence)this.mExternalActivityPackage)) {
                    Intent launchIntent = this.mContext.getPackageManager().getLaunchIntentForPackage(this.mExternalActivityPackage);
                    if (launchIntent != null) {
                        Log.i(TAG, "Starting external application: " + this.mExternalActivityPackage);
                        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application", this.mExternalActivityPackage, this.iconData.getFileName(), 0L);
                        this.mContext.startActivity(launchIntent);
                    } else {
                        try {
                            Log.i(TAG, "External application package " + this.mExternalActivityPackage + " not found, trying to start google market");
                            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on Google market", this.mExternalActivityPackage, this.iconData.getFileName(), 0L);
                            this.mContext.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + this.mExternalActivityPackage))));
                        }
                        catch (ActivityNotFoundException anfe) {
                            Log.i(TAG, "Google market not found on device starting browser, openApp: " + this.mExternalActivityPackage);
                            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on browser", this.mExternalActivityPackage, this.iconData.getFileName(), 0L);
                            this.mContext.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + this.mExternalActivityPackage))));
                        }
                    }
                } else if (!TextUtils.isEmpty((CharSequence)this.mExternalWebsite)) {
                    Intent i = new Intent("android.intent.action.VIEW");
                    i.setData(Uri.parse((String)this.mExternalWebsite));
                    Log.i(TAG, "Starting browser with url: " + this.mExternalWebsite);
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External link", this.mExternalWebsite, this.iconData.getFileName(), 0L);
                    this.mContext.startActivity(i);
                }
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught exception in onClick", ex);
        }
    }

    @Override
    public void setDismissEventTime(long dismissEventTime) {
        this.dismissEventTime = dismissEventTime;
    }
}

