/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.EditText;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.aniways.Aniways;
import com.aniways.AniwaysEditTextAndTextViewCommonPart;
import com.aniways.AniwaysIconConverter;
import com.aniways.AniwaysSuggestionSpan;
import com.aniways.AssetType;
import com.aniways.IAniwaysDynamicImageSpan;
import com.aniways.IAniwaysGestureResponder;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IAniwaysTextEditor;
import com.aniways.IAniwaysTextWatcher;
import com.aniways.IAniwaysWordMarkerSpan;
import com.aniways.ISuggestionDisplayer;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.analytics.utils.ContextualEventData;
import com.aniways.contextual.ContextualPopup;
import com.aniways.data.AniwaysAnimatedAssetInfo;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.GiphyIconData;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.emoticons.button.AniwaysRecentIconsManager;
import com.aniways.quick.action.ContextualItemSelectedByUserEvent;
import com.aniways.quick.action.ContextualPopupCreationContext;
import com.aniways.quick.action.EventAggregator;
import com.aniways.quick.action.IEvent;
import com.aniways.quick.action.IEventListener;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.service.utils.AniwaysServiceUtils;
import com.aniways.volley.toolbox.Volley;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import org.json.JSONObject;

public class AniwaysEditText
extends EditText
implements ISuggestionDisplayer,
IAniwaysGestureResponder,
IAniwaysTextEditor {
    private static final String TAG = "AniwaysEditText";
    public static final int REVERT_TO_TEXT = 374;
    private AniwaysEditTextAndTextViewCommonPart mAniwaysEditTextAndTextViewerCommonPart;
    private UUID mMessageId = UUID.randomUUID();
    private IAniwaysWordMarkerSpan mActiveMarkerSpan;
    private HashSet<onContentSelectedListener> mContentSelectedListeners = new HashSet();
    private boolean showIndicationForGifSelectionInEditText = true;
    private static boolean ignoredDueToLandscape = false;
    private ContextualPopup popup;

    public AniwaysEditText(Context context) {
        this(context, null);
    }

    public AniwaysEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (!this.isInEditMode()) {
            this.mAniwaysEditTextAndTextViewerCommonPart = new AniwaysEditTextAndTextViewCommonPart((TextView)this);
            this.registerToContentSelectedEvents();
            this.registerGoingToBackgroundDetector();
        }
    }

    public AniwaysEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.mAniwaysEditTextAndTextViewerCommonPart = new AniwaysEditTextAndTextViewCommonPart((TextView)this);
            this.registerToContentSelectedEvents();
            this.registerGoingToBackgroundDetector();
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerGoingToBackgroundDetector() {
        if (!Utils.isAndroidVersionAtLeast(14)) {
            return;
        }
        this.getContext().registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onLowMemory() {
            }

            public void onTrimMemory(int level) {
                if (level == 20 && AniwaysEditText.this.popup != null && AniwaysEditText.this.popup.isShowing()) {
                    Log.i(AniwaysEditText.TAG, "Dismissing popup since going to background");
                    AniwaysEditText.this.popup.dismiss();
                }
            }
        });
    }

    private void registerToContentSelectedEvents() {
        EventAggregator.getInstance().register(TAG, new IEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notify(IEvent event) {
                try {
                    ContextualItemSelectedByUserEvent contextualItemSelectedByUserEvent;
                    ContextualItemSelectedByUserEvent contextualItemSelectedByUserEvent2 = contextualItemSelectedByUserEvent = event instanceof ContextualItemSelectedByUserEvent ? (ContextualItemSelectedByUserEvent)event : null;
                    if (contextualItemSelectedByUserEvent != null) {
                        final IconData selectedIcon = contextualItemSelectedByUserEvent.assetInfo.getIconData();
                        final Phrase phrase = contextualItemSelectedByUserEvent.popupCreationContext.phrase;
                        final AniwaysSuggestionSpan suggestionSpan = contextualItemSelectedByUserEvent.popupCreationContext.suggestionSpan;
                        final IAniwaysImageSpan.IconSelectionOrigin selectionOrigin = contextualItemSelectedByUserEvent.popupCreationContext.selectionOrigin;
                        final int pos = contextualItemSelectedByUserEvent.selectedGridItemInfo.getPosition();
                        final int rowNum = contextualItemSelectedByUserEvent.selectedGridItemInfo.getRow();
                        final int numRows = contextualItemSelectedByUserEvent.selectedGridItemInfo.getNumRows();
                        final int columnNum = contextualItemSelectedByUserEvent.selectedGridItemInfo.getColumn();
                        final int numColumns = contextualItemSelectedByUserEvent.selectedGridItemInfo.getNumColumns();
                        final int totalNumberOfItems = contextualItemSelectedByUserEvent.selectedGridItemInfo.getTotalNumberOfItems();
                        final IAniwaysImageSpan previousImageSpan = contextualItemSelectedByUserEvent.popupCreationContext.previousImageSpan;
                        final IconData previousIcon = previousImageSpan == null ? null : previousImageSpan.getIcon();
                        AniwaysPrivateConfig cfg = AniwaysPrivateConfig.getInstance();
                        if (selectedIcon != null && selectedIcon.assetType == AssetType.AnimatedGif) {
                            if (selectedIcon.assetProvider == IAniwaysImageSpan.AssetProvider.Giphy) {
                                JSONObject json = ((AniwaysAnimatedAssetInfo)contextualItemSelectedByUserEvent.assetInfo).getJson();
                                Object anim = Volley.getImageLoader().getCached(((AniwaysAnimatedAssetInfo)contextualItemSelectedByUserEvent.assetInfo).getLowQualityAnimatedGifUrl(), cfg.getMaxWidthForCache(selectedIcon), cfg.getMaxHeightForCache(selectedIcon), selectedIcon.getFileName());
                                int size = 220000;
                                if (anim != null && anim instanceof byte[]) {
                                    size = ((byte[])anim).length;
                                }
                                onContentSelectedListener.GiphySelectedData data = new onContentSelectedListener.GiphySelectedData(json, size);
                                if (AniwaysEditText.this.showIndicationForGifSelectionInEditText) {
                                    selectedIcon.iconSelectionTag = data;
                                    AniwaysEditText.this.insetTextCoveredWithIconAfterPhrase(selectedIcon, suggestionSpan, phrase, new IAniwaysImageSpan.ImageSpanMetadata(selectedIcon, selectionOrigin));
                                } else {
                                    for (onContentSelectedListener listener : AniwaysEditText.this.mContentSelectedListeners) {
                                        listener.onGiphySelected(data);
                                    }
                                }
                                AnalyticsReporter.reportContextualEvent(new ContextualEventData(AnalyticsReporter.PhrasesEventAction.selected, AniwaysEditText.this.mMessageId, phrase, new IconData[]{selectedIcon}, AniwaysStoreManager.isIconUnlocked(selectedIcon), null, false, null, 0, null, 0, 0, pos, totalNumberOfItems, rowNum, columnNum, numRows, numColumns, 0, null, null, new IAniwaysImageSpan.ImageSpanMetadata(selectedIcon, selectionOrigin), -1));
                                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Picked Animated Gif-" + (Object)((Object)selectionOrigin), phrase.getPhraseSubPhraseString(), ((GiphyIconData)selectedIcon).idInGiphy, 0L);
                            } else {
                                Log.w(true, AniwaysEditText.TAG, "User selected animated Gif with provider which is not Giphy: " + (Object)((Object)selectedIcon.assetProvider));
                            }
                        } else if (selectedIcon != null && (selectedIcon.assetType == AssetType.Emoticons || selectedIcon.assetType == AssetType.Emoji)) {
                            final String[] selectedIconPath = new String[]{"X_delete - "};
                            if (selectedIcon.id == 374) {
                                AniwaysEditText.this.replaceImageWithItsText(previousImageSpan, suggestionSpan, false);
                                assert (previousImageSpan != null);
                                selectedIconPath[0] = selectedIconPath[0] + previousImageSpan.getIcon().getFileName();
                            } else if (AniwaysEditText.this.popup != null) {
                                AniwaysEditText.this.popup.handleLockedIconSelectedEvent(contextualItemSelectedByUserEvent, new AniwaysAction<Boolean>(){

                                    @Override
                                    public void call(Boolean success) {
                                        AniwaysEditText.this.onSuggestionSelected(selectedIcon, previousImageSpan, suggestionSpan, selectionOrigin);
                                        selectedIconPath[0] = selectedIcon.getFileName();
                                        AniwaysRecentIconsManager.addRecentIcon(selectedIcon.id, selectedIcon.assetType);
                                        AnalyticsReporter.reportContextualEvent(new ContextualEventData(AnalyticsReporter.PhrasesEventAction.selected, AniwaysEditText.this.mMessageId, phrase, new IconData[]{selectedIcon}, AniwaysStoreManager.isIconUnlocked(selectedIcon), previousIcon, false, null, 0, null, 0, 0, pos + 1, totalNumberOfItems, rowNum, columnNum, numRows, numColumns, 0, null, null, new IAniwaysImageSpan.ImageSpanMetadata(selectedIcon, selectionOrigin), -1));
                                    }
                                });
                            }
                            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Picked Icon-" + (Object)((Object)selectionOrigin), phrase.getPhraseSubPhraseString(), selectedIconPath[0], 0L);
                            if (previousImageSpan != null) {
                                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Switched Icon", phrase.getPhraseSubPhraseString(), previousImageSpan.getIcon().getFileName() + " - " + selectedIconPath[0], 0L);
                            }
                            AniwaysEditText.this.mActiveMarkerSpan = null;
                        }
                        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, contextualItemSelectedByUserEvent.popupCreationContext.startTimeUserInPopup, "User Action", "Time To Select Icon", phrase.getPhraseSubPhraseString(), AniwaysEditText.TAG, "The phrase");
                        AniwaysEditText.this.mActiveMarkerSpan = null;
                    }
                }
                catch (Exception e) {
                    Log.e(true, AniwaysEditText.TAG, "on selected contextual content by user exception", e);
                }
                finally {
                    ContextualPopup.dismissAllOpenPopups();
                }
            }
        });
    }

    public boolean onTextContextMenuItem(int id2) {
        try {
            return this.mAniwaysEditTextAndTextViewerCommonPart.onTextContextMenuItem(id2);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception onTextContextMenuItem. id is: " + id2, ex);
            return true;
        }
    }

    public void registerContentSelectedListener(onContentSelectedListener listener, boolean showIndicationForGifSelectionInEditText) {
        this.showIndicationForGifSelectionInEditText = showIndicationForGifSelectionInEditText;
        this.mContentSelectedListeners.add(listener);
    }

    public void unregisterContentSelectedListener(onContentSelectedListener listener) {
        this.mContentSelectedListeners.remove(listener);
    }

    public boolean dispatchKeyEventPreIme(@NonNull KeyEvent event) {
        try {
            return this.mAniwaysEditTextAndTextViewerCommonPart.dispatchKeyEventPreIme(event);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in dispatchKeyEventPreIme. Event is: " + event, ex);
            return true;
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        try {
            return this.mAniwaysEditTextAndTextViewerCommonPart.onTouchEvent(event);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in onTouchEvent. Event is: " + event, ex);
            return true;
        }
    }

    @Override
    public void displaySuggestions(final AniwaysSuggestionSpan suggestionSpan, JsonParser parser, final IAniwaysImageSpan.IconSelectionOrigin selectionOrigin) {
        if (AniwaysStatics.getApplicationContext().getResources().getConfiguration().orientation == 2) {
            ignoredDueToLandscape = true;
            return;
        }
        long startTime = System.currentTimeMillis();
        Phrase phrase = suggestionSpan.phrase;
        Editable text = this.getText();
        int[] startEnd = new int[]{text.getSpanStart((Object)suggestionSpan), text.getSpanEnd((Object)suggestionSpan)};
        Utils.setMaxMinStartEnd(startEnd);
        int start = startEnd[0];
        int end = startEnd[1];
        IAniwaysImageSpan[] imageSpans = (IAniwaysImageSpan[])this.getText().getSpans(start, end, IAniwaysImageSpan.class);
        IAniwaysImageSpan previousImageSpan = imageSpans.length > 0 ? imageSpans[0] : null;
        ContextualPopup.dismissAllOpenPopups();
        final ContextualPopupCreationContext context = new ContextualPopupCreationContext(phrase, suggestionSpan, parser, previousImageSpan, selectionOrigin, System.currentTimeMillis(), this.mMessageId, (View)this);
        this.popup = new ContextualPopup(this.getContext(), context);
        this.popup.addTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    suggestionSpan.setDismissEventTime(event.getEventTime());
                }
                return false;
            }
        });
        IAniwaysWordMarkerSpan[] wordMarkerSpans = (IAniwaysWordMarkerSpan[])this.getText().getSpans(start, end, IAniwaysWordMarkerSpan.class);
        IAniwaysWordMarkerSpan targetMarkerSpan = null;
        IAniwaysWordMarkerSpan[] iAniwaysWordMarkerSpanArray = wordMarkerSpans;
        int n = iAniwaysWordMarkerSpanArray.length;
        for (int i = 0; i < n; ++i) {
            IAniwaysWordMarkerSpan wordMarkerSpan;
            final IAniwaysWordMarkerSpan finalWordMarkerSpan = wordMarkerSpan = iAniwaysWordMarkerSpanArray[i];
            targetMarkerSpan = wordMarkerSpan;
            wordMarkerSpan.setSelected(this, true);
            this.popup.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    finalWordMarkerSpan.setSelected(AniwaysEditText.this, false);
                    AniwaysEditText.this.mActiveMarkerSpan = null;
                    AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, context.startTimeUserInPopup, "User Action", "Time user spent in popup-" + (Object)((Object)selectionOrigin), "0", AniwaysEditText.TAG, "");
                }
            });
        }
        if (this.mActiveMarkerSpan != null) {
            this.mActiveMarkerSpan.setSelected(this, false);
        }
        this.mActiveMarkerSpan = targetMarkerSpan;
        if (ignoredDueToLandscape) {
            ignoredDueToLandscape = false;
            final ContextualPopup finalPopup = this.popup;
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    finalPopup.show((View)AniwaysEditText.this);
                }
            }, 250L);
        } else {
            this.popup.show((View)this);
        }
        if (selectionOrigin == IAniwaysImageSpan.IconSelectionOrigin.ContextualManual) {
            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display Suggestions-" + (Object)((Object)selectionOrigin), phrase.getPhraseSubPhraseString(), "", 0L);
            AnalyticsReporter.reportContextualEvent(new ContextualEventData(AnalyticsReporter.PhrasesEventAction.tapped, this.mMessageId, phrase, new IconData[]{}, false, previousImageSpan == null ? null : previousImageSpan.getIcon(), false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, -1));
        }
        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Verbose, startTime, "Performance", "Display Suggestions Popup", "", TAG, "");
    }

    void replaceSuggestionWithIcon(AniwaysSuggestionSpan suggestionSpan, JsonParser parser, IAniwaysImageSpan.IconSelectionOrigin selectionOrigin) {
        Phrase phrase = suggestionSpan.phrase;
        IconData[] icons = phrase.emoticonsPhraseAssetBuilder.icons;
        if (icons == null || icons.length == 0) {
            Log.w(true, TAG, "No icons for phrase: " + phrase + " . Keywords version is: " + parser.getKeywordsVersion());
            return;
        }
        IconData icon = icons[0];
        this.onSuggestionSelected(icon, null, suggestionSpan, selectionOrigin);
    }

    private void replaceWithIcon(IconData icon, IAniwaysImageSpan previousImageSpan, AniwaysSuggestionSpan suggestionSpan, IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata, boolean removeSuggestionSpan) {
        if (suggestionSpan == null) {
            Log.e(true, TAG, "SuggestionSpan is null");
            return;
        }
        this.mAniwaysEditTextAndTextViewerCommonPart.removeTheAniwaysTextWatcher();
        if (previousImageSpan != null) {
            this.replaceImageWithItsText(previousImageSpan, suggestionSpan, true);
        }
        int startOfReplacementText = this.getText().getSpanStart((Object)suggestionSpan);
        int endOfReplacementText = this.getText().getSpanEnd((Object)suggestionSpan);
        if (startOfReplacementText < 0) {
            Log.w(true, TAG, "Suggestion span is not in text. Text is: " + this.getText().toString());
            return;
        }
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (removeSuggestionSpan) {
            this.getText().removeSpan((Object)suggestionSpan);
            AniwaysIconConverter.insertAniwaysIconToText(this.getContext(), (Spannable)this.getText(), icon, startOfReplacementText, suggestionSpan.phrase, this, null, imageSpanMetadata, false, false, false);
        } else {
            AniwaysIconConverter.insertAniwaysIconToText(this.getContext(), (Spannable)this.getText(), suggestionSpan, icon, imageSpanMetadata, false);
        }
        int lengthDiff = endOfReplacementText - startOfReplacementText - icon.getUnicodeToReplaceText().length();
        this.setText((CharSequence)this.getText());
        if (selectionStart < endOfReplacementText && selectionEnd > startOfReplacementText) {
            this.setSelection(endOfReplacementText);
        } else {
            if (selectionEnd >= endOfReplacementText) {
                selectionEnd -= lengthDiff;
            }
            if (selectionStart >= endOfReplacementText) {
                selectionStart -= lengthDiff;
            }
            this.setSelection(selectionStart, selectionEnd);
        }
        if (this.getText().length() == selectionStart && selectionStart == endOfReplacementText - lengthDiff) {
            this.getText().append((CharSequence)" ");
            this.setSelection(selectionStart + 1);
        }
        this.mAniwaysEditTextAndTextViewerCommonPart.addTheAniwaysTextWatcher();
    }

    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        if (AniwaysPrivateConfig.getInstance().isImeFlagNoExtractUiForced) {
            outAttrs.imeOptions |= 0x10000000;
            this.setImeOptions(outAttrs.imeOptions);
        }
        return super.onCreateInputConnection(outAttrs);
    }

    private void onSuggestionSelected(IconData selectedIcon, IAniwaysImageSpan previousImageSpan, AniwaysSuggestionSpan suggestionSpan, IAniwaysImageSpan.IconSelectionOrigin selectionOrigin) {
        this.replaceWithIcon(selectedIcon, previousImageSpan, suggestionSpan, new IAniwaysImageSpan.ImageSpanMetadata(selectedIcon, selectionOrigin), false);
    }

    private void replaceImageWithItsText(IAniwaysImageSpan imageSpan, AniwaysSuggestionSpan suggestionSpan, boolean keepSuggestionSpan) {
        Phrase phrase;
        Editable text = this.getText();
        int start = text.getSpanStart((Object)imageSpan);
        int end = text.getSpanEnd((Object)imageSpan);
        text.removeSpan((Object)imageSpan);
        text.removeSpan((Object)suggestionSpan);
        if (imageSpan instanceof IAniwaysDynamicImageSpan) {
            this.mAniwaysEditTextAndTextViewerCommonPart.onRemoveDynamicImageSpan((IAniwaysDynamicImageSpan)imageSpan);
        }
        if (suggestionSpan.originalText.equalsIgnoreCase((phrase = imageSpan.getPhrase()).getPartToReplace())) {
            text.replace(start, end, (CharSequence)suggestionSpan.originalText);
        } else {
            text.replace(start, end, (CharSequence)phrase.getPartToReplace());
        }
        if (keepSuggestionSpan) {
            text.setSpan((Object)suggestionSpan, start, start + imageSpan.getPhrase().getLengthOfPartToReplace(), 33);
        }
    }

    @Override
    public void onSingleTap(MotionEvent event) {
        try {
            AniwaysSuggestionSpan[] suggestionSpan;
            int pos = this.mAniwaysEditTextAndTextViewerCommonPart.getPositionOfTouchEventInText(event);
            Log.d(TAG, "pos of touch event in text: " + pos);
            if (pos != -1 && (suggestionSpan = (AniwaysSuggestionSpan[])this.getText().getSpans(pos, pos, AniwaysSuggestionSpan.class)).length != 0) {
                long eventTime = -1L;
                if (event.getAction() == 0) {
                    eventTime = event.getEventTime();
                }
                suggestionSpan[0].onClick(eventTime, this.getText());
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in onSingleTap. Event is: " + event, ex);
        }
    }

    @Override
    public boolean callSuperOnTextContextMenuItem(int id2) {
        return super.onTextContextMenuItem(id2);
    }

    @Override
    public boolean callSuperOnTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    @Override
    public boolean callSuperDispatchKeyEventPreIme(KeyEvent event) {
        return super.dispatchKeyEventPreIme(event);
    }

    public Editable getText() {
        if (!this.isInEditMode()) {
            AniwaysStatics.makeSureAniwaysIsInitialized(false);
        }
        return super.getText();
    }

    @Override
    public void setText(CharSequence text, boolean justCallSuper) {
        if (justCallSuper) {
            super.setText(text, TextView.BufferType.EDITABLE);
        } else {
            this.setText(text, TextView.BufferType.EDITABLE);
        }
    }

    public String getOriginalText() {
        Editable text;
        try {
            text = this.getText();
        }
        catch (ClassCastException ex) {
            text = Editable.Factory.getInstance().newEditable((CharSequence)"");
            Log.v(TAG, "set text cast exception caught");
        }
        return Aniways.getOriginalString(this.getContext(), (Spannable)text);
    }

    public void onSendingMessage() {
        Editable oldText;
        Log.d(TAG, "On message sent called");
        try {
            oldText = this.getText();
        }
        catch (ClassCastException ex) {
            oldText = Editable.Factory.getInstance().newEditable((CharSequence)"");
            Log.v(TAG, "cast exception caught in on send message");
        }
        if (TextUtils.isEmpty((CharSequence)oldText)) {
            Log.w(true, TAG, "onSendingMessage called when old text is null or empty");
            return;
        }
        AniwaysServiceUtils.setLastUserActivityTime(this.getContext(), System.currentTimeMillis());
        if (this.showIndicationForGifSelectionInEditText) {
            this.sendIndicationOfSelectedAnimatedGifs();
        }
        GoogleAnalyticsReporter.reportCustomDimention(4, AniwaysPhraseReplacementData.getDataParser().getKeywordsVersion());
        String originalText = this.getOriginalText();
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Message Sent", originalText, originalText.length());
        AnalyticsReporter.reportMessageSentEvent(this.mMessageId, originalText);
        ArrayList<RecognizedPhrase> recognizedPhrases = this.getRecognizedPhrases(true);
        if (recognizedPhrases != null && recognizedPhrases.size() > 0) {
            int serialNumber = 0;
            for (RecognizedPhrase rp : recognizedPhrases) {
                ++serialNumber;
                Phrase phrase = rp.phrase;
                String imageName = "Not Replaced";
                if (rp.isCoveredByImage()) {
                    imageName = rp.icon.getFileName();
                    if (rp.imageSpanMetadata.isFromAniwaysKeyboard()) {
                        imageName = "From button: " + imageName;
                    } else if (rp.imageSpanMetadata.isFromUnknownKeyboard()) {
                        imageName = "From app: " + imageName;
                    }
                }
                if (phrase == null) {
                    Log.e(true, TAG, "phrase is null");
                    continue;
                }
                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Sent Phrase Statistics", phrase.getPhraseSubPhraseString(), imageName, 0L);
                if (!rp.isCoveredByImage() || rp.imageSpanMetadata.isFromContextualReplacement()) {
                    AnalyticsReporter.reportContextualEvent(new ContextualEventData(AnalyticsReporter.PhrasesEventAction.suggested, this.mMessageId, phrase, null, false, null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, serialNumber, null, null, rp.imageSpanMetadata, rp.getStartIndex()));
                }
                if (!rp.isCoveredByImage()) continue;
                if (rp.imageSpanMetadata.wasSelectedThroughAniways()) {
                    AnalyticsReporter.reportContextualEvent(new ContextualEventData(AnalyticsReporter.PhrasesEventAction.sent, this.mMessageId, phrase, new IconData[]{rp.icon}, AniwaysStoreManager.isIconUnlocked(rp.icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, serialNumber, null, null, rp.imageSpanMetadata, -1));
                    continue;
                }
                Log.d(TAG, "Reporting icon from non Aniways keyboard/paste/unknown source");
                AnalyticsReporter.reportContextualEvent(new ContextualEventData(AnalyticsReporter.PhrasesEventAction.sentExternalContent, this.mMessageId, phrase, new IconData[]{rp.icon}, AniwaysStoreManager.isIconUnlocked(rp.icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, serialNumber, null, null, rp.imageSpanMetadata, -1));
            }
        }
    }

    private void sendIndicationOfSelectedAnimatedGifs() {
        Editable spannable = this.getText();
        if (spannable == null) {
            return;
        }
        IAniwaysImageSpan[] spans = (IAniwaysImageSpan[])spannable.getSpans(0, spannable.length(), IAniwaysImageSpan.class);
        if (spans == null || spans.length == 0) {
            return;
        }
        for (IAniwaysImageSpan span : spans) {
            IconData icon = span.getIcon();
            Object selectionTag = icon.iconSelectionTag;
            if (selectionTag == null) continue;
            if (icon.assetProvider == IAniwaysImageSpan.AssetProvider.Giphy) {
                if (selectionTag instanceof onContentSelectedListener.GiphySelectedData) {
                    for (onContentSelectedListener listener : this.mContentSelectedListeners) {
                        listener.onGiphySelected((onContentSelectedListener.GiphySelectedData)selectionTag);
                    }
                    continue;
                }
                Log.e(true, TAG, "Encountered non GiphySelectedData selection Tag when provider is Giphy: " + selectionTag.getClass().getName());
                continue;
            }
            Log.w(true, TAG, "Encountered non Giphy asset provider: " + (Object)((Object)icon.assetProvider));
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        Log.d(TAG, "setText Start");
        if (this.isInEditMode()) {
            super.setText(text, type);
            return;
        }
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            Editable oldText;
            if (text == null) {
                text = "";
            }
            try {
                oldText = this.getText();
            }
            catch (ClassCastException ex) {
                oldText = Editable.Factory.getInstance().newEditable((CharSequence)"");
                Log.v(TAG, "set text cast exception caught");
            }
            if (text.length() == 0 && oldText != text && oldText.length() > 0 && !AniwaysPrivateConfig.getInstance().appIsCallingOnSendingMessage) {
                this.onSendingMessage();
            }
            if (oldText != text) {
                Log.i(TAG, "Setting a new text");
                this.mMessageId = UUID.randomUUID();
            } else {
                Log.i(TAG, "Setting the same text");
            }
            try {
                if (this.mAniwaysEditTextAndTextViewerCommonPart != null && text != oldText) {
                    text = Editable.Factory.getInstance().newEditable(text);
                    JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
                    if (text.length() > 0) {
                        Log.d(TAG, "Start decode");
                        AniwaysIconConverter.decodeMessage(this.getContext(), (Editable)text, this, null, this.mAniwaysEditTextAndTextViewerCommonPart, parser, null, false, false, false, false);
                        Log.d(TAG, "End decode");
                    }
                }
                Log.d(TAG, "superSetText Start");
                super.setText(text, type);
                Log.d(TAG, "superSetText End");
                if (this.mAniwaysEditTextAndTextViewerCommonPart != null) {
                    this.mAniwaysEditTextAndTextViewerCommonPart.onSetText(text, (Spannable)oldText);
                }
            }
            catch (IndexOutOfBoundsException ex) {
                Log.e(true, TAG, "Caught IndexOutOfBoundsException in setText. Text is: " + text + " . Type is: " + type.toString(), ex);
            }
            Log.d(TAG, "setText End");
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in setText. Text is: " + text, ex);
        }
    }

    public ArrayList<RecognizedPhrase> getRecognizedPhrases(boolean includeCoveredByImage) {
        IAniwaysImageSpan[] imageSpans;
        Editable text = this.getText();
        ArrayList<RecognizedPhrase> result = new ArrayList<RecognizedPhrase>();
        if (text == null || text.length() <= 0) {
            return result;
        }
        AniwaysSuggestionSpan[] suggestionSpans = (AniwaysSuggestionSpan[])text.getSpans(0, text.length(), AniwaysSuggestionSpan.class);
        if (suggestionSpans != null && suggestionSpans.length > 0) {
            for (AniwaysSuggestionSpan ss : suggestionSpans) {
                int start = text.getSpanStart((Object)ss);
                int end = text.getSpanEnd((Object)ss);
                RecognizedPhrase recognizedPhrase = new RecognizedPhrase(ss.phrase);
                recognizedPhrase.setStartIndex(start);
                recognizedPhrase.setEndIndex(start);
                IAniwaysImageSpan[] imageSpans2 = (IAniwaysImageSpan[])text.getSpans(start, end, IAniwaysImageSpan.class);
                if (imageSpans2 != null && imageSpans2.length > 0) {
                    for (IAniwaysImageSpan is : imageSpans2) {
                        int isStart = text.getSpanStart((Object)is);
                        int isEnd = text.getSpanEnd((Object)is);
                        if (isStart != start || isEnd != end) continue;
                        recognizedPhrase.icon = is.getIcon();
                        recognizedPhrase.imageSpanMetadata = is.getImageSpanMetadata();
                    }
                }
                if (recognizedPhrase.isCoveredByImage() && !includeCoveredByImage) continue;
                result.add(recognizedPhrase);
            }
        }
        if ((imageSpans = (IAniwaysImageSpan[])text.getSpans(0, text.length(), IAniwaysImageSpan.class)) != null && imageSpans.length > 0) {
            for (IAniwaysImageSpan is : imageSpans) {
                int start = text.getSpanStart((Object)is);
                int end = text.getSpanEnd((Object)is);
                RecognizedPhrase recognizedPhrase = new RecognizedPhrase(is.getPhrase());
                suggestionSpans = (AniwaysSuggestionSpan[])text.getSpans(start, end, AniwaysSuggestionSpan.class);
                boolean foundSuggestionSpan = false;
                if (suggestionSpans != null && suggestionSpans.length > 0) {
                    for (AniwaysSuggestionSpan ss : suggestionSpans) {
                        int ssStart = text.getSpanStart((Object)ss);
                        int ssEnd = text.getSpanEnd((Object)ss);
                        if (ssStart != start || ssEnd != end) continue;
                        foundSuggestionSpan = true;
                        break;
                    }
                }
                if (foundSuggestionSpan) continue;
                recognizedPhrase.icon = is.getIcon();
                recognizedPhrase.imageSpanMetadata = is.getImageSpanMetadata();
                if (includeCoveredByImage) {
                    result.add(recognizedPhrase);
                }
                Log.d(TAG, "Found icon from app");
                if (recognizedPhrase.imageSpanMetadata.isFromUnknownKeyboard() || recognizedPhrase.imageSpanMetadata.isIconSentSeperatelyFromText()) continue;
                Log.w(false, TAG, "Found icon whitout suggestion span which is not from the app");
            }
        }
        return result;
    }

    public void setSelection(int start, int stop) {
        try {
            this.mAniwaysEditTextAndTextViewerCommonPart.setSelection(start, stop);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in setSelection. Start is: " + start + ". stop is: " + stop, ex);
        }
    }

    public void setSelection(int index) {
        try {
            if (this.mAniwaysEditTextAndTextViewerCommonPart != null) {
                this.mAniwaysEditTextAndTextViewerCommonPart.setSelection(index);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in setSelection. index is: " + index, ex);
        }
    }

    public void extendSelection(int index) {
        try {
            this.mAniwaysEditTextAndTextViewerCommonPart.extendSelection(index);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in extendSelection. index is: " + index, ex);
        }
    }

    public void selectAll() {
        try {
            this.mAniwaysEditTextAndTextViewerCommonPart.selectAll();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught excedption in selectAll", ex);
        }
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        if (this.isInEditMode() || this.mAniwaysEditTextAndTextViewerCommonPart == null) {
            Log.w(false, TAG, "not removing text change listeners through aniways since mAniwaysEditTextAndTextViewerCommonPart is null");
            super.removeTextChangedListener(watcher);
            return;
        }
        this.mAniwaysEditTextAndTextViewerCommonPart.removeTextChangedListener(watcher);
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.isInEditMode() || this.mAniwaysEditTextAndTextViewerCommonPart == null) {
            Log.w(false, TAG, "not adding text change listeners through aniways since mAniwaysEditTextAndTextViewerCommonPart is null");
            super.addTextChangedListener(watcher);
            return;
        }
        this.mAniwaysEditTextAndTextViewerCommonPart.addTextChangedListener(watcher);
    }

    @Override
    public void callSuperSetSelection(int start, int stop) {
        super.setSelection(start, stop);
    }

    @Override
    public void callSuperSetSelection(int index) {
        super.setSelection(index);
    }

    @Override
    public void callSuperExtendSelection(int index) {
        super.extendSelection(index);
    }

    @Override
    public void callSuperSelectAll() {
        super.selectAll();
    }

    @Override
    public void callSuperRemoveTextChangedListener(TextWatcher watcher) {
        super.removeTextChangedListener(watcher);
    }

    @Override
    public void callSuperAddTextChangedListener(TextWatcher watcher) {
        super.addTextChangedListener(watcher);
        super.onDetachedFromWindow();
    }

    protected void onDetachedFromWindow() {
        this.mAniwaysEditTextAndTextViewerCommonPart.onDetachFromWindow();
        super.onDetachedFromWindow();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mAniwaysEditTextAndTextViewerCommonPart.onLayoutCalled();
    }

    Point getPointOfPositionInText(int position, boolean fromTop) {
        return this.mAniwaysEditTextAndTextViewerCommonPart.getPointOfPositionInText(position, fromTop);
    }

    public void insetTextCoveredWithIconAfterPhrase(IconData selectedIcon, AniwaysSuggestionSpan suggestionSpan, Phrase phrase, IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata) {
        Editable editable = this.getText();
        if (editable == null) {
            return;
        }
        int oldSelectionStart = this.getSelectionStart();
        int oldSelectionEnd = this.getSelectionEnd();
        int spanEnd = editable.getSpanEnd((Object)suggestionSpan);
        if (spanEnd < 0) {
            Log.e(true, TAG, "SuggestionSpan not in Text, so not adding icon. Is Null: " + (suggestionSpan == null) + ". Text: " + editable.toString());
            return;
        }
        int marginBetweenPartToReplacAndPhraseEnd = phrase.getMarginBetweenEndOfPartToReplaceToPhraseEnd();
        int phraseEnd = spanEnd + marginBetweenPartToReplacAndPhraseEnd;
        this.mAniwaysEditTextAndTextViewerCommonPart.removeTheAniwaysTextWatcher();
        String spacesToAdd = "  ";
        try {
            if (phraseEnd != editable.length() && editable.subSequence(phraseEnd, phraseEnd + 1).toString().equals(" ")) {
                spacesToAdd = " ";
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Could not add spaces to make room for icon.", ex);
        }
        editable.insert(phraseEnd, (CharSequence)spacesToAdd);
        String phraseName = phrase.getName();
        this.getText().insert(phraseEnd + 1, (CharSequence)phraseName);
        int selectionOffset = phraseName.length() + spacesToAdd.length();
        if (oldSelectionStart >= phraseEnd) {
            this.setSelection(oldSelectionStart + selectionOffset, oldSelectionEnd + selectionOffset);
        } else if (oldSelectionEnd >= phraseEnd) {
            this.setSelection(oldSelectionStart, oldSelectionEnd + selectionOffset);
        }
        int indexOfPartToReplace = phraseEnd + 1 + phrase.getIndexOfPartToReplaceInPhrase();
        AniwaysSuggestionSpan ass = new AniwaysSuggestionSpan(phrase, this, phrase.getPartToReplace());
        ass.spawninSpan = suggestionSpan;
        this.getText().setSpan((Object)ass, indexOfPartToReplace, indexOfPartToReplace + phrase.getPartToReplace().length(), 33);
        this.replaceWithIcon(selectedIcon, null, ass, imageSpanMetadata, true);
        Log.d(TAG, "in insetTextCoveredWithIcon - adding back text changed listener..");
        this.mAniwaysEditTextAndTextViewerCommonPart.addTheAniwaysTextWatcher();
    }

    public void insetTextCoveredWithIcon(IconData selectedIcon, int selectionStart, int selectionEnd, Phrase phrase, IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata, boolean addSuggestionSpan) {
        Log.d(TAG, "in insetTextCoveredWithIcon");
        this.mAniwaysEditTextAndTextViewerCommonPart.removeTheAniwaysTextWatcher();
        String phraseName = phrase.getName();
        this.getText().replace(selectionStart, selectionEnd, (CharSequence)phraseName, 0, phraseName.length());
        this.setSelection(selectionStart + phraseName.length());
        int indexOfPartToReplace = selectionStart + phrase.getIndexOfPartToReplaceInPhrase();
        AniwaysSuggestionSpan ass = new AniwaysSuggestionSpan(phrase, this, phrase.getPartToReplace());
        this.getText().setSpan((Object)ass, indexOfPartToReplace, indexOfPartToReplace + phrase.getPartToReplace().length(), 33);
        this.replaceWithIcon(selectedIcon, null, ass, imageSpanMetadata, !addSuggestionSpan);
        Log.d(TAG, "in insetTextCoveredWithIcon - adding back text changed listener..");
        this.mAniwaysEditTextAndTextViewerCommonPart.addTheAniwaysTextWatcher();
    }

    @Override
    public IAniwaysTextWatcher addTheAniwaysTextWatcher() {
        return this.mAniwaysEditTextAndTextViewerCommonPart.addTheAniwaysTextWatcher();
    }

    @Override
    public IAniwaysTextWatcher removeTheAniwaysTextWatcher() {
        return this.mAniwaysEditTextAndTextViewerCommonPart.removeTheAniwaysTextWatcher();
    }

    public UUID getMessageId() {
        return this.mMessageId;
    }

    public IAniwaysTextContainer getTextContainer() {
        return this.mAniwaysEditTextAndTextViewerCommonPart;
    }

    public class RecognizedPhrase {
        public Phrase phrase;
        IconData icon;
        IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata;
        private int startIndex;
        private int endIndex;

        RecognizedPhrase(Phrase p) {
            this.phrase = p;
            this.icon = null;
            this.imageSpanMetadata = null;
        }

        boolean isCoveredByImage() {
            return this.icon != null;
        }

        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public void setEndIndex(int endIndex) {
            this.endIndex = endIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }
    }

    public static interface onContentSelectedListener {
        public void onGiphySelected(GiphySelectedData var1);

        public void onGiphyRemoved(GiphySelectedData var1);

        public static class GiphySelectedData {
            public JSONObject jsonEntry;
            public int size;

            public GiphySelectedData(JSONObject jsonEntry, int size) {
                this.jsonEntry = jsonEntry;
                this.size = size;
            }
        }
    }
}

