/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.os.Handler;
import android.os.Looper;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.View;
import com.aniways.AniwaysAnimatedGifSpan;
import com.aniways.AniwaysEditText;
import com.aniways.AniwaysEditTextAndTextViewCommonPart;
import com.aniways.AniwaysLoadingImageSpan;
import com.aniways.IAniwaysDynamicImageSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.Log;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.volley.toolbox.IResponseListener;
import java.util.HashSet;

public class AniwaysDynamicImageSpansContainer {
    private static final String TAG = "AniwaysLoadingImageSpansContainer";
    private HashSet<IAniwaysDynamicImageSpan> mSpans = new HashSet();
    IAniwaysTextContainer mTextContainer;
    IAniwaysDynamicImageSpan.InvalidateListener mInvalidateListener;

    public AniwaysDynamicImageSpansContainer(IAniwaysTextContainer textContainer) {
        this.mTextContainer = textContainer;
        this.mInvalidateListener = new IAniwaysDynamicImageSpan.InvalidateListener(){
            boolean invalidateCalledInThisDrawCycle = false;

            @Override
            public void invalidate(IAniwaysDynamicImageSpan span) {
                if (this.invalidateCalledInThisDrawCycle) {
                    return;
                }
                Spannable spannable = AniwaysDynamicImageSpansContainer.this.mTextContainer.getText();
                if (spannable == null) {
                    Log.w(true, AniwaysDynamicImageSpansContainer.TAG, "received null spannable from text container");
                    this.invalidateCalledInThisDrawCycle = false;
                    return;
                }
                int start = spannable.getSpanStart((Object)span);
                int end = spannable.getSpanEnd((Object)span);
                if (start >= 0 && end > 0) {
                    spannable.removeSpan((Object)span);
                    spannable.setSpan((Object)span, start, end, 33);
                    this.invalidateCalledInThisDrawCycle = true;
                    AniwaysDynamicImageSpansContainer.this.mTextContainer.getView().invalidate();
                } else {
                    this.invalidateCalledInThisDrawCycle = false;
                }
            }

            @Override
            public void onDraw() {
                this.invalidateCalledInThisDrawCycle = false;
            }
        };
    }

    public void addDynamicImageSpan(final IAniwaysDynamicImageSpan span) {
        this.mSpans.add(span);
        if (span.isLoadingImageSpan()) {
            final AniwaysLoadingImageSpan loadingImageSpan = (AniwaysLoadingImageSpan)span;
            loadingImageSpan.registerResponseListener(this, new IResponseListener(){

                @Override
                public void onError() {
                    AniwaysDynamicImageSpansContainer.this.removeDynamicImagespan(span, false, false, false);
                    AniwaysDynamicImageSpansContainer.this.mTextContainer.onErrorLoadingImage();
                }

                @Override
                public void onSuccess() {
                    Spannable spannable = AniwaysDynamicImageSpansContainer.this.mTextContainer.getText();
                    boolean replaced = loadingImageSpan.replaceWithImageSpan(spannable, AniwaysDynamicImageSpansContainer.this.mTextContainer.getView().getContext(), AniwaysDynamicImageSpansContainer.this.mTextContainer.getIconInfoDisplayer(), AniwaysDynamicImageSpansContainer.this);
                    if (!replaced) {
                        if (AniwaysDynamicImageSpansContainer.this.mTextContainer instanceof AniwaysEditTextAndTextViewCommonPart) {
                            View v = ((AniwaysEditTextAndTextViewCommonPart)AniwaysDynamicImageSpansContainer.this.mTextContainer).getView();
                            if (v instanceof AniwaysEditText) {
                                Log.v(AniwaysDynamicImageSpansContainer.TAG, "Span not replaced in EditText, probably because text it covered was deleted");
                            } else {
                                Log.e(true, AniwaysDynamicImageSpansContainer.TAG, "Span not replaced. Text container class is: " + v.getClass().getSimpleName());
                            }
                        } else {
                            Log.e(true, AniwaysDynamicImageSpansContainer.TAG, "Span not replaced. Text container class is: " + AniwaysDynamicImageSpansContainer.this.mTextContainer.getClass().getSimpleName());
                        }
                    }
                    Log.d(AniwaysDynamicImageSpansContainer.TAG, "detaching from span after replacing with image. Success: " + replaced);
                    AniwaysDynamicImageSpansContainer.this.removeDynamicImagespan(span, replaced, !replaced, false);
                    AniwaysDynamicImageSpansContainer.this.mTextContainer.onLoadedImageSuccessfuly();
                }
            });
        } else if (span instanceof AniwaysAnimatedGifSpan) {
            ((AniwaysAnimatedGifSpan)span).registerInvalidateListener(this, this.mInvalidateListener);
        }
        span.onAddedToContainer(this);
    }

    private void removeDynamicImagespan(final IAniwaysDynamicImageSpan span, final boolean success, final boolean error, boolean sync) {
        this.mSpans.remove(span);
        if (sync) {
            this.removeDynamicImageSpanInner(span, success, error);
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post((Runnable)new NonThrowingRunnable(TAG, "removeLoadingImagespan. Success: " + success + ". Error: " + error, ""){

            @Override
            public void innerRun() {
                AniwaysDynamicImageSpansContainer.this.removeDynamicImageSpanInner(span, success, error);
            }
        });
    }

    private void removeDynamicImageSpanInner(IAniwaysDynamicImageSpan span, boolean success, boolean error) {
        span.onRemovedFromContainer(this);
    }

    public void onDetachFromWindowCalled() {
        for (IAniwaysDynamicImageSpan span : this.mSpans) {
            span.onDetachedFromWindowCalled();
        }
    }

    public void onLayoutCalled() {
        for (IAniwaysDynamicImageSpan span : this.mSpans) {
            span.onLayoutCalled();
        }
    }

    public void onSetText(Spannable text, Spannable oldText) {
        IAniwaysDynamicImageSpan[] spans;
        if (!TextUtils.isEmpty((CharSequence)oldText) && !oldText.equals(text) && (spans = (IAniwaysDynamicImageSpan[])oldText.getSpans(0, oldText.length(), IAniwaysDynamicImageSpan.class)) != null) {
            for (IAniwaysDynamicImageSpan span : spans) {
                this.removeDynamicImagespan(span, false, false, true);
            }
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        spans = (IAniwaysDynamicImageSpan[])text.getSpans(0, text.length(), IAniwaysDynamicImageSpan.class);
        if (spans != null) {
            for (IAniwaysDynamicImageSpan span : spans) {
                this.addDynamicImageSpan(span);
            }
        }
    }

    public void onRemoveSpan(IAniwaysDynamicImageSpan span) {
        this.removeDynamicImagespan(span, false, false, true);
    }
}

