package com.aniways.ui;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;

import com.aniways.Log;
import com.aniways.data.AniwaysStatics;

/**
 * Created by moran on 12/9/2014.
 */
public class AniwaysUiUtil {

    private static final String TAG = "AniwaysUiUtil";

    public static int convertDipsToPixels(int dips){
        Context applicationContext = AniwaysStatics.getApplicationContext();

        if (applicationContext == null){
            String erroMessage = "Trying to use null application context";
            Log.e(true, TAG, erroMessage);

            throw new NullPointerException(erroMessage);
        }

        Resources r = applicationContext.getResources();
        float px = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dips, r.getDisplayMetrics());
        return (int)px;
    }

    public static DisplayMetrics getScreenDisplayMatrix(){
        WindowManager windowManager = (WindowManager) AniwaysStatics.getApplicationContext().getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics dm = new DisplayMetrics();

        windowManager.getDefaultDisplay().getMetrics(dm);

        return dm;
    }

    public static float convertPixelsToDips(float pixels) {
        Context applicationContext = AniwaysStatics.getApplicationContext();

        if (applicationContext == null){
            String erroMessage = "Trying to use null application context";
            Log.e(true, TAG, erroMessage);

            throw new NullPointerException(erroMessage);
        }

        Resources r = applicationContext.getResources();
        float dips = pixels / applicationContext.getResources().getDisplayMetrics().density;
        return dips;
    }
}
