package com.aniways.data;

import com.aniways.AssetType;
import com.aniways.service.utils.AniwaysAction;

import java.util.LinkedList;
import java.util.List;

public class PhraseAssetInfoExtractor {
    private static final int EMPTY_REQUEST_ID = -1;
    private List<IAniwaysAssetInfo> assetInfoItems;
    private boolean requestPending;
    private int currentRequestId = EMPTY_REQUEST_ID;
    private PhraseAssetInfoBuilderBase phraseAssetInfoBuilder;
    private final AssetType assetType;

    public PhraseAssetInfoExtractor(AssetType assetType) {
        this.assetType = assetType;
    }

    public void extract(Phrase phrase, final AniwaysAction<List<IAniwaysAssetInfo>> callback) {
        //There might be a case which we are in the middle of fetching urls for previous phrase,
        // if so cancel all processing request and restart fetching for the new phrase
        if (requestPending) {
            cancelPendingRequest();
        }

        JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
        PhraseAssetInfoBuilderBase assetInfoBuilder = phrase.getAssetInfoBuilder(assetType);
        Phrase referencePhrase = assetInfoBuilder.getReferencePhrase(parser, phrase);
        // The reference phrase can also be the same phrase, null means that we are not supposed to get data for this phrase at all, not even from reference phrases
        if (referencePhrase != null) { //override the original phrase with the referenced one.
            phrase = referencePhrase;
        } else {
            callback.call(null);
            return;
        }

        resetMembers();

        final Phrase finalPhrase = phrase;

        // We get again since now its the reference phrase
        this.phraseAssetInfoBuilder = phrase.getAssetInfoBuilder(assetType);
        if (this.phraseAssetInfoBuilder == null || this.phraseAssetInfoBuilder.isEmpty()) {
            callback.call(null);
            return;
        }

        this.requestPending = true;
        this.currentRequestId = this.phraseAssetInfoBuilder.buildAssets(new AniwaysAction<List<IAniwaysAssetInfo>>() {

            @Override
            public void call(List<IAniwaysAssetInfo> items) {
                requestPending = false;

                if (items != null && !items.isEmpty()) {
                    assetInfoItems.addAll(items);
                    callback.call(assetInfoItems);
                }
                else {
                    callback.call(null);
                }
            }
        }, finalPhrase);
    }

    private void resetMembers() {
        this.assetInfoItems = new LinkedList<>();
        this.requestPending = false;
        this.currentRequestId = EMPTY_REQUEST_ID;
        this.phraseAssetInfoBuilder = null;
    }

    private void cancelPendingRequest() {
        if(phraseAssetInfoBuilder != null && currentRequestId != EMPTY_REQUEST_ID){
            phraseAssetInfoBuilder.cancelBuildAssetsRequest(currentRequestId);
        }
    }
}