package com.aniways.data;

import com.aniways.service.utils.AniwaysAction;

import java.util.HashMap;
import java.util.List;

public abstract class PhraseAssetInfoBuilderBase {

    protected static final HashMap<Integer, AssetInfoBuilderRequestContext> requests = new HashMap<>();
    private static int lastRequestId = 0;

    protected AniwaysAction<List<IAniwaysAssetInfo>> getCompletionCallback(final int requestId, final AssetInfoBuilderRequestContext ctx) {
        return new AniwaysAction<List<IAniwaysAssetInfo>>() {

            @Override
            public synchronized void call(List<IAniwaysAssetInfo> assetInfoItems) {
                ctx.numCallbacksFromBuilders++;

                if (assetInfoItems != null && !assetInfoItems.isEmpty()) {
                    ctx.assetInfoItems.addAll(assetInfoItems);
                }

                //waiting for all builders to return - now we can callback the caller.
                if (ctx.numBuilders == ctx.numCallbacksFromBuilders) {
                    ctx.callback.call(ctx.assetInfoItems);
                    requests.remove(requestId);
                }
            }
        };
    }

    protected static int getNewRequestId() {

        int retRequestId;
        synchronized (requests) {
            retRequestId = lastRequestId;
            lastRequestId++;
        }

        return retRequestId;
    }

    public void cancelBuildAssetsRequest(int requestId) {
        AssetInfoBuilderRequestContext ctx = requests.get(requestId);
        if (ctx != null) {
            if (ctx.builders == null) { return; }

            for (IAssetInfoBuilder builder : ctx.builders) {
                builder.cancelPendingRequests();
            }

            requests.remove(requestId);
        }
    }

    //TODO: Once we move to V3 and everything is standardized, these can be non abstract (implementation like in the AnimatedGif inheritor)
    // and we can delete lots of code from inheriting classes
    public abstract Phrase getReferencePhrase(JsonParser parser, Phrase phrase);

    public abstract boolean isEmpty();

    public abstract int buildAssets(AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase);
}