package com.aniways.data;

import com.aniways.IconData;

public class EmojiHashSet extends CustomHashSet<IconData> {

	public EmojiHashSet(int capacity) {
		super(capacity);
	}

	@Override
	protected void generateKeys(int capacity){
		keys = new IconData[capacity];
	}
	
	@Override
	public IconData put(IconData key) {
        if (key == NULL) throw new IllegalArgumentException("key cannot be " + NULL);
        if (size == keys.length) throw new IllegalStateException("map is full");

        int index = indexFor(key.firstEmojiCodepoint);
        while (keys[index] != NULL) {
            index = successor(index);
        }
        keys[index] = key;
        ++size;
        return key;
    }

	@Override
	public IconData get(IconData key) {
        throw new UnsupportedOperationException();
    }
	

    public IconData get(int key) {

        int index = indexFor(key);
        
        IconData candidate = keys[index]; 
        while (candidate != NULL) {
            if (candidate.firstEmojiCodepoint == key) {
                if(candidate.secondEmojiCodepoint == IconData.EMPTY_EMOJI_CODEPOINT){
                	return candidate;
                }
            }
            index = successor(index);
            candidate = keys[index]; 
        }

        return NULL;
    }
    
    public IconData get(int[] key) {

        int index = indexFor(key[0]);
        
        IconData candidate = keys[index]; 
        while (candidate != NULL) {
        	if (candidate.firstEmojiCodepoint == key[0]) {
                if(candidate.secondEmojiCodepoint == key[1]){
                	return candidate;
                }
            }
            index = successor(index);
            candidate = keys[index]; 
        }

        return NULL;
    }
    
    private int indexFor(int key) {
        return Math.abs((key % keys.length));
    }
}