package com.aniways.data;

import android.content.Context;
import android.content.SharedPreferences;

import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.service.utils.AniwaysServiceUtils;

import java.util.ArrayList;

/**
 * Encapsulates access to the application's settings.
 */
public class AppData
{
    private static String sEmptyArrayListString;
    private static String sSharedPreferencesFileName;
    private static Context sApplicationContext;
    private static SharedPreferences sPreferences;
    private static final String TAG = "AniwaysAppData";

    //TODO: static init block - not sure about this convention we (me ,Yoav and Shai) should discuss our coding convention.
    static {

        sApplicationContext = AniwaysStatics.getApplicationContext();
        sSharedPreferencesFileName = AniwaysServiceUtils.SHARED_PREFERENCES;
        sPreferences = sApplicationContext.getSharedPreferences(sSharedPreferencesFileName, Utils.getSharedPreferencesFlags());

        try
        {
            sEmptyArrayListString = ObjectSerializer.serialize(new ArrayList<String>());
        }
        catch (Exception e)
        {
            Log.w(false, TAG, "Failed serializing an empty ArrayList<String>.");
        }
    }

    public static int getInt(String key)
    {
        return getInt(key, 0);
    }

    public static int getInt(String key, int defaultValue)
    {
        verifyInit();

        return sPreferences.getInt(key, defaultValue);
    }

    public static void putInt(String key, int value)
    {
        verifyInit();

        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public static boolean getBoolean(String key, boolean defaultValue){
        return sPreferences.getBoolean(key, defaultValue);
    }

    public static void putBoolean(String key, boolean value){
        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putBoolean(key,value);
        editor.commit();
    }

    public static String getString(String key)
    {
        verifyInit();

        return sPreferences.getString(key, "");
    }

    public static void putString(String key, String value)
    {
        verifyInit();

        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    @SuppressWarnings("unchecked")
    public static ArrayList<String> getStringList(String key)
    {
        verifyInit();

        ArrayList<String> retStringList = new ArrayList<>();

        try
        {
            String serializedStringList = sPreferences.getString(key, sEmptyArrayListString);
            retStringList = (ArrayList<String>)ObjectSerializer.deserialize(serializedStringList);
        }
        catch (Exception e)
        {
            Log.e(false, TAG, "Failed while deserializing the value under key: '" + key + "'.");
        }

        return retStringList;
    }

    public static void putStringList(String key, ArrayList<String> value)
    {
        verifyInit();

        SharedPreferences.Editor editor = sPreferences.edit();

        try
        {
            editor.putString(key, ObjectSerializer.serialize(value));
        }
        catch (Exception e)
        {
            Log.e(false, TAG, "Failed while serializing the value to be stored under key: '" + key + "'.");
        }

        editor.commit();
    }

    /**
     * Increments an integer value stored under the specified key by 1.
     * If the value was not previously stored, the value will be set to 1.
     *
     * @param key The application settings key under which the specified value should be saved.
     * @return The value after incrementing.
     */
    public static synchronized int incrementInt(String key)
    {
        verifyInit();

        int retValue = sPreferences.getInt(key, 0) + 1;

        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putInt(key, retValue);
        editor.commit();

        return retValue;
    }

    private static void verifyInit()
    {
        if (sSharedPreferencesFileName == null)
        {
            Log.e(true, TAG, "using AppData before initializing");
        }
    }
}