package com.aniways.bugsnag.android;

import com.aniways.Log;

public class Logger extends com.aniways.bugsnag.Logger {
    @Override
    public void debug(String message) {
        Log.d(LOG_PREFIX, message);
    }

    @Override
    public void info(String message) {
        Log.i(LOG_PREFIX, message);
    }

    @Override
    public void warn(String message) {
        Log.eToGaOnly(true, LOG_PREFIX, message, null);
    }

    @Override
    public void warn(String message, Throwable e) {
        Log.eToGaOnly(true, LOG_PREFIX, message, e);
    }
}
