package com.aniways.analytics.models;

import java.util.Calendar;

import org.json.JSONObject;

public class Track extends BasePayload {
	
	public final static String TYPE = "track";
    private static final String EVENT_DATA_KEY = "event_data";
	private static final String PROPERTIES_KEY = "event_properties";
	
	public Track (JSONObject obj) {
		super(obj);
	}

	public Track(EventProperties properties, Calendar timestamp, Context metaData, Context eventData) {

		super(timestamp, metaData);

		put("type", TYPE);

        setEventData(eventData);
		setProperties(properties);
	}

	public EventProperties getProperties() {
		JSONObject object = getObject(PROPERTIES_KEY);
		if (object == null) return null;
		else return new EventProperties(object);
	}

	public void setProperties(EventProperties properties) {
		this.put(PROPERTIES_KEY, properties);
	}

    public void setEventData(Context eventData) {
        if (eventData != null){
            this.put(EVENT_DATA_KEY, eventData);
        }
    }
}
