package com.aniways.analytics.models;

import java.util.Calendar;

import org.json.JSONObject;

public class Screen extends Track {
	
	public final static String TYPE = "screen";
	
	private static final String SCREEN_KEY = "screen";
	
	public Screen (JSONObject obj) {
		super(obj);
	}
	
	public Screen(String screen, 
				 EventProperties properties, 
				 Calendar timestamp,
				 Context context) {

		super(properties, timestamp, context, null);

		put("type", TYPE);
		
		setScreen(screen);
	}

	public String getScreen() {
		return this.optString(SCREEN_KEY, null);
	}

	public void setScreen(String screen) {
		this.put(SCREEN_KEY, screen);
	}
}
