package com.aniways.analytics.models;

import java.util.Calendar;
import java.util.TimeZone;

import org.json.JSONObject;

public class BasePayload extends EasyJSONObject {
	
	private final static String TIMESTAMP_KEY = "timestamp";
	private final static String CONTEXT_KEY = "meta_data";
	
	public BasePayload (JSONObject obj) {
		super(obj);
	}
	
	public BasePayload(Calendar timestamp, 
					   Context context) {

		// we want to time stamp the events in case they get 
		// batched in the future
		if (timestamp == null) {
			timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
		}
		if (context == null) context = new Context();
		
		setTimestamp(timestamp);
		setContext(context);
	}

	public Calendar getTimestamp() {
		return getCalendar(TIMESTAMP_KEY);
	}

	public void setTimestamp(Calendar timestamp) {
		super.put(TIMESTAMP_KEY, timestamp);
	}

	public Context getContext() {
		JSONObject object = getObject(CONTEXT_KEY);
		if (object == null) return null;
		else return new Context(object);
	}

	public void setContext(Context context) {
		this.put(CONTEXT_KEY, context);
	}

}