package com.aniways.analytics.info;

import com.aniways.Log;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.service.utils.AniwaysServiceUtils;

import org.json.JSONObject;

import android.app.AlarmManager;
import android.content.Context;

public class User implements Info<JSONObject> {

	private static final String TAG = "AniwaysAnalyticsContextUser";

	@Override
	public String getKey() {
		return "user";
	}

	@Override
	public JSONObject get(Context context) {

		EasyJSONObject user = new EasyJSONObject();

		try{

			String userId = "unknown";
			
			// Not sending because its PII
			//AccountManager am = AccountManager.get(context);
			//Account[] accounts = am.getAccountsByType(null);
			//if(accounts != null && accounts.length > 0){
			//	for (Account a: accounts) {
			//		if (a != null && a.name != null && a.name.contains("@gmail.com")) {
			//			// Cut everything after the @gmail.com..
			//			int endIndex = a.name.indexOf("@gmail.com") + 10;
			//			userId = a.name.substring(0, endIndex);
			//			break;
			//		}
			//	}
			//}

			user.put("userId", userId);
			
			long now = System.currentTimeMillis();
			long appInstallTime = AniwaysServiceUtils.getAppInstallTime(context, now);
			long timeFromInstall = now - appInstallTime;
			user.put("TimeFromInstallDays", Math.round(timeFromInstall / AlarmManager.INTERVAL_DAY));
		}
		catch (Exception ex) {
			Log.eToGaOnly(true, TAG, "Caught Exception in Location info", ex);
		}

		return user;
	}

}
