package com.aniways.analytics.info;

import com.aniways.Log;
import com.aniways.analytics.models.EasyJSONObject;
import org.json.JSONObject;

import android.content.Context;
import android.telephony.TelephonyManager;

public class Locale implements Info<JSONObject> {

	private static final String TAG = "AniwaysAnalyticsContextLocale";

	@Override
	public String getKey() {
		return "locale";
	}

	@Override
	public JSONObject get(Context context) {

		EasyJSONObject locale = new EasyJSONObject();

		try{
			TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);

			locale.put("carrier",  manager.getNetworkOperatorName());
			locale.put("country",  java.util.Locale.getDefault().getDisplayCountry());
			locale.put("countryIso3",  java.util.Locale.getDefault().getISO3Country());
			locale.put("language", java.util.Locale.getDefault().getLanguage());
			locale.put("languageIso3", java.util.Locale.getDefault().getISO3Language());
			locale.put("displayLanguage", java.util.Locale.getDefault().getDisplayLanguage());
			
			try {
		        final TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
		        final String simCountry = tm.getSimCountryIso();
		        if (simCountry != null) { // SIM country code is available
		            String simCountryString = simCountry.toLowerCase(java.util.Locale.US);
		            locale.put("simCountry",  simCountryString);
		        }
		       if (tm.getPhoneType() != TelephonyManager.PHONE_TYPE_CDMA) { // device is not 3G (would be unreliable)
		            String networkCountry = tm.getNetworkCountryIso();
		            if (networkCountry != null) { // network country code is available
		                String networkCountryString = networkCountry.toLowerCase(java.util.Locale.US);
		                locale.put("networkCountry",  networkCountryString);
		            }
		        }
		    }
			catch (Exception ex) {
				Log.eToGaOnly(true, TAG, "Caught Exception in Locale sim or nw country code", ex);
			}
			
			String localeCode = context.getResources().getConfiguration().locale.getCountry();
			locale.put("countryCode",  localeCode);
			
		}
		catch (Exception ex) {
			Log.eToGaOnly(true, TAG, "Caught Exception in Locale info", ex);
		}

		return locale;
	}
}
