package com.aniways.analytics.info;

import com.aniways.analytics.models.EasyJSONObject;

import java.util.LinkedList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A manager that uses plugin information getters to construct
 *  an object that contains contextual information about the Android device
 *
 */
public class InfoManager {

	private List<Info<?>> managers; 
	
	public InfoManager() {
		managers = new LinkedList<Info<?>>();

		managers.add(new Build());
		managers.add(new Device());
		managers.add(new User());
		managers.add(new Display());
		managers.add(new Locale());
		managers.add(new Location());
		managers.add(new Telephony());
		managers.add(new Wifi());
	}


    /**
     * Restructure the json to be aligned with the V3 analytics requirements.
     */
    public JSONObject buildV3(android.content.Context context) throws JSONException {
        JSONObject info = build(context);

        EasyJSONObject newInfoObj = new EasyJSONObject();

        newInfoObj.put("os", info.getJSONObject("device").getString("os"));
        newInfoObj.put("sdk_version", info.getJSONObject("device").getString("sdk"));
        newInfoObj.put("application_id", info.getJSONObject("build").getString("appId") );
        newInfoObj.put("installation_id", info.getJSONObject("device").getString("installationId"));
        newInfoObj.put("os_version", info.getJSONObject("device").getString("release"));
        newInfoObj.put("device_country", info.getJSONObject("location").getString("countryCode"));
        newInfoObj.put("language", info.getJSONObject("locale").getString("languageIso3"));
        newInfoObj.put("device_model", info.getJSONObject("device").getString("model"));
        newInfoObj.put("device_manufacturer", info.getJSONObject("device").getString("manufacturer"));
        newInfoObj.put("extra_data", info);

        return newInfoObj;
    }

    /**
     * Builds an object that contains contextual information about the phone
     * @param context Android context for the phone
     * @return JSONObject containing parsed information about the phone
     */
	public JSONObject build(android.content.Context context) {
		
		EasyJSONObject info = new EasyJSONObject();
		
		for (Info<?> manager : managers) {
			String key = manager.getKey();
			Object val = manager.get(context);
            if(val == null){
                val = new EasyJSONObject();
            }
			
			if (val != null) {
				info.putObject(key, val);
			}
		}
		
		return info;
	}
	
}
