package com.aniways.analytics.info;

import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.Constants;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.analytics.utils.AndroidUtils;
import com.aniways.data.Installation;
import com.aniways.service.task.DownloadJSONFileTask;

import org.json.JSONObject;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

public class Device implements Info<JSONObject> {

	private static final String TAG = "AniwaysAnalyticsContextDevice";

	@Override
	public String getKey() {
		return "device";
	}

	@SuppressLint("NewApi") @Override
	public JSONObject get(Context context) {

		EasyJSONObject device = new EasyJSONObject();

		try{
			device.put("os", DownloadJSONFileTask.ANDROID);
			device.put("sdk", Build.VERSION.SDK_INT);
			device.put("release",  Build.VERSION.RELEASE);
			device.put("brand", Build.BRAND);
			device.put("manufacturer",  Build.MANUFACTURER);
			device.put("model",  Build.MODEL);
			device.put("installationId", Installation.id(context));
			device.put("maxMemory", Runtime.getRuntime().maxMemory() / (1024*1024));

			ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
			if(am != null){
				device.put("memClass", am.getMemoryClass());
				if(Utils.isAndroidVersionAtLeast(11)){
					device.put("memClassLargeHeap", am.getLargeMemoryClass());
				}
			}

			// Android ID
			// Issues on 2.2, some phones have same Android ID due to manufacturer
			// error
			String androidId = android.provider.Settings.Secure.getString(context.getContentResolver(), android.provider.Settings.Secure.ANDROID_ID);

			if (!(TextUtils.isEmpty(androidId) || androidId.equals("9774d56d682e549c"))) {
				androidId = "unknown";
			}

			device.put("androidId", androidId);

			// Serial number
			// Guaranteed to be on all non phones in 2.3+
			String serialNumber = "unknown";
			try {
				serialNumber = (String) Build.class.getField("SERIAL").get(null);
				if (TextUtils.isEmpty(serialNumber)) {
					serialNumber = "unknown";
				}
			} catch (Exception e) {
				serialNumber = "unknown";
			}
			device.put("serialNumber", serialNumber);

			// Telephony ID
			// Guaranteed to be on all phones, requires READ_PHONE_STATE permission
			String telephonyId = "unknown";
			if (AndroidUtils.permissionGranted(context, Constants.Permission.READ_PHONE_STATE) && 
					context.getPackageManager().hasSystemFeature("android.hardware.telephony")) {

				TelephonyManager telephone = ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE));
				telephonyId = telephone.getDeviceId();
				if (TextUtils.isEmpty(telephonyId)) {
					telephonyId = "unknown";
				}
			}
			device.put("telephonyId", serialNumber);
		}
		catch (Exception ex) {
			Log.eToGaOnly(true, TAG, "Caught Exception in Device info", ex);
		}

		return device;	
	}

}
