package com.aniways.analytics.info;

import com.aniways.Log;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import org.json.JSONObject;

import android.content.Context;

public class  Config {

	private static final String TAG = "AniwaysAnalyticsContextConfig";

	public static String getKey() {
		return "config";
	}

	public static JSONObject get(Context context) {

		EasyJSONObject config = new EasyJSONObject();

		try{
			
			AniwaysPrivateConfig cfg = AniwaysPrivateConfig.getInstance();
			
			config.put("code", cfg.version);
			config.put("name", cfg.versionName);
			config.put("keywordsVersion", AniwaysPhraseReplacementData.getParsedKeywordsVersion(context));
			config.put("isLowMemory", cfg.isLowMemoryDevice());
			config.put("isExtremeLowMemory", cfg.isExtremeLowMemoryDevice());
			
			// User config
			config.put("contextualIconSuggestionsEnabled", cfg.contextualIconSuggestionsEnabled);
			config.put("contextualAnimationsSuggestionsEnabled", cfg.contextualAnimationsSuggestionsEnabled);
			config.put("contextualMusicSuggestionsEnabled", cfg.contextualMusicSuggestionsEnabled);
			config.put("contextualLocationBasedSuggestionsEnabled", cfg.contextualLocationBasedSuggestionsEnabled);
			config.put("contextualContentSuggestionsEnabled", cfg.contextualContentSuggestionsEnabled);
			config.put("contextualSuggestionsEnabled", cfg.contextualSuggestionsEnabled);
		}
		catch (Exception ex) {
			Log.eToGaOnly(true, TAG, "Caught Exception in config info", ex);
		}

		return config;
	}

}
