package com.aniways.analytics.db;

import com.aniways.analytics.models.BasePayload;
import java.util.List;

/**
 * Handles communication with the database
 * on its own thread to achieve SQL thread safety.
 *
 */
public interface IPayloadDatabaseLayer {

	//
	// Callbacks
	// 
	
	/**
	 * Called when an enqueue completes.
	 *
	 */
	public interface EnqueueCallback {
		/**
		 * Called when an enqueue finishes.
		 * @param success Whether the enqueue was successful.
		 * @param count The new database size
		 */
		public void onEnqueue(boolean success, long rowCount);
	}
	
	/**
	 * Callback for when a database payload query returns
	 * @author ivolo
	 *
	 */
	public interface PayloadCallback {
		public void onPayload(long minId, long maxId, List<BasePayload> payloads);
	}
	
	public interface ErrorPayloadCallback {
		public void onPayload(long minId, long maxId, String payload);
	}
	
	/**
	 * Callback for when payloads are removed from the database
	 * @author ivolo
	 *
	 */
	public interface RemoveCallback {
		public void onRemoved(int removed);
	}

}
