package com.aniways.analytics;

import com.aniways.IconData;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.analytics.models.EventProperties;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.quick.action.ContextualPopupStateHolder;

import org.json.JSONArray;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/**
 * Created by moran on 2/5/2015.
 */
public class ContextualPopupStateReporter {

    public static void reportScreenEvent(ContextualPopupStateHolder popupStateHolder, long closingTime){
        final Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

        EventProperties props = new EventProperties();

        props.put("category","screen");
        props.put("action", "popup");
        props.put("page_index",popupStateHolder.pageIndex);
        props.put("page_index_out_of",popupStateHolder.totalPages);
        props.put("state",popupStateHolder.isInRevealMoreState? "reveal more":"regular");
        props.put("asset_type", popupStateHolder.currentAssetType);
        props.put("content_lines", popupStateHolder.contentLines);
        props.put("entry_method", popupStateHolder.entryMethod);
        props.put("exit_method", popupStateHolder.exitMethod);
        props.put("previous_screen", popupStateHolder.previousScreen);
        props.put("next_screen", popupStateHolder.nextScreen);
        props.put("popup_origin", popupStateHolder.popupOrigin.getStringRepresentation());
        props.put("time_open", closingTime - popupStateHolder.popupOpenStartTime);
        props.put("phrase", popupStateHolder.phraseName);

        addProviderToContentIds(popupStateHolder, props);

        AniwaysAnalyticsReporter.track(props, timestamp);
    }

    private static void addProviderToContentIds(ContextualPopupStateHolder popupStateHolder, EventProperties props) {
        if (popupStateHolder.popupAssetInfos == null || popupStateHolder.popupAssetInfos.isEmpty()){
            return;
        }

        EasyJSONObject providerNameToIds = new EasyJSONObject();
        HashMap<String,ArrayList<String>> map = new HashMap<>();

        for (IAniwaysAssetInfo assetInfo : popupStateHolder.popupAssetInfos){
            IconData iconData = assetInfo.getIconData();
            if (iconData == null){
                continue;
            }

            String key = iconData.assetProvider.toString().toLowerCase();

            if (!map.containsKey(key)){
                map.put(key, new ArrayList<String>());
            }

            map.get(key).add(iconData.getAssetIdFromProvider());
        }

        for (Map.Entry<String,ArrayList<String>> entry: map.entrySet()){
            providerNameToIds.put(entry.getKey(),new JSONArray(entry.getValue()));
        }

        props.put("content_ids", providerNameToIds);
    }
}
