package com.aniways;

import pl.droidsonroids.gif.GifDrawable;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;

import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.GiphyIconData;
import com.aniways.data.Phrase;

public class IconData implements IImageSpanFactory
{	
	public static final int EMPTY_EMOJI_CODEPOINT = -1;
	private static final String EXTENSION = ".png";
	public static final String ANIMATED_EXTENSION = ".gif";
	// TODO: find why this doesnt work with using "\u1f6c5"???
	private static final String DEFAULT_UNICODE_REPRESENTATION = new String(new int[] { Integer.parseInt("1f6c5", 16) }, 0, 1);  // The least popular emoji of them all
	private static final String TAG = "AniwaysIconData";
	private static final double USE_INTRINSIC_SIZE = 0;

	// Primary phrase
	public Phrase primaryPhrase;
	public String family;
	public int id;
	public boolean isLocked;
	public AssetType assetType;
    public IAniwaysImageSpan.AssetProvider assetProvider;
    private final boolean animated;
    public int firstEmojiCodepoint = EMPTY_EMOJI_CODEPOINT;
	public int secondEmojiCodepoint = EMPTY_EMOJI_CODEPOINT;
    public Object iconSelectionTag; //TODO: Consider putting this on the ImageSpanMetadata, if can confirm that the metadada object will indeed be put on the image span at all times..
                                    //TODO: Use generics to make sure the right type is always here..

    public IconData(int id, String family, boolean isLocked, Phrase primaryPhrase, String unicodeRepresentation, AssetType assetType, IAniwaysImageSpan.AssetProvider assetProvider, boolean animated){
		this.id = id;
		this.family = family;
		this.isLocked = isLocked;
		this.primaryPhrase = primaryPhrase;
		this.assetType = assetType;
        this.assetProvider = assetProvider;
        this.animated = animated;
        extractUnicodeRepresentation(unicodeRepresentation);
	}

	protected IconData(IconData other){
		this(other.id, other.family, other.isLocked, other.primaryPhrase, null, other.assetType, other.assetProvider, other.animated);
		this.firstEmojiCodepoint = other.firstEmojiCodepoint;
		this.secondEmojiCodepoint = other.secondEmojiCodepoint;
        this.iconSelectionTag = other.iconSelectionTag;
	}

	public boolean isInFamily(String family){
		return this.family.equalsIgnoreCase(family);
	}

	public boolean isLocked(){
		return this.isLocked;
	}

    public boolean isEmoji(){
        return assetType == AssetType.Emoji;
    }

	public boolean isAnimated(){
		// TODO: maybe remove this method and return asset type, or check if name contains animated
        return animated;
	}

	/*
	 * Returns true also if it is an emoji
	 */
	public boolean hasEmojiFallback(){
		return firstEmojiCodepoint != EMPTY_EMOJI_CODEPOINT;
	}

	public String getUnicodeRepresentation(){
		if(firstEmojiCodepoint == EMPTY_EMOJI_CODEPOINT){
			return null;
		}

		return new String(new int[] { firstEmojiCodepoint, secondEmojiCodepoint }, 0, secondEmojiCodepoint == EMPTY_EMOJI_CODEPOINT ? 1 : 2);
	}

	public String getUnicodeToReplaceText(){
		// Try to get the unicode representation (in case this icon has an emoji fallback)
		String response = getUnicodeRepresentation();
		if (response == null){
			// If the icon doen't have an emoji fallback then return the default unicode
			response = DEFAULT_UNICODE_REPRESENTATION;
		}
		return response;
	}

	public String getFileName()
	{
		return Integer.toString(this.id) + (isAnimated() ? ANIMATED_EXTENSION : EXTENSION);
	}

	@Override
	public boolean equals(Object o){
		if(!(o instanceof IconData)){
			return false;
		}

		// TODO: see if there is a better cast here for performance
		return equals((IconData) o);
	}

	public boolean equals(IconData o){
		return this.id == o.id;
	}

	@Override
	public int hashCode(){
		return this.id;
	}

	// We use this in the events, so do not change!!
	@Override
	public String toString(){
		return "ID: " + this.id + ". Family: " + this.family + ". Asset type: " + this.assetType + ". Asset provider: " + this.assetProvider +
				". has emoji fallback: " + this.hasEmojiFallback() + ". Primary Phrase: " + this.primaryPhrase + ". IsLocked: " + this.isLocked + 
				". Unicode to replace text: " + this.getUnicodeToReplaceText();
	}

	private void extractUnicodeRepresentation(String unicodesString){
		if(unicodesString == null){
			return;
		}
		String[] unicodeStrings = unicodesString.split("-");
		this.firstEmojiCodepoint = Integer.parseInt(unicodeStrings[0], 16); 
		//this.firstEmojiUnicode = Character.toChars(code);
		if(unicodeStrings.length == 1){
			return;
		}
		this.secondEmojiCodepoint = Integer.parseInt(unicodeStrings[1], 16); 
		//this.secondEmojiUnicode = Character.toChars(code);
	}

	public boolean hasExternalData() {
		return false;
	}

	public String getExternalActivityPackage(){
		Log.e(true, TAG, "getExternalActivityPackage called on IconData");
		return null;
	}

	public String getExternalWebsite(){
		Log.e(true, TAG, "getExternalWebsite called on IconData");
		return null;
	}

	@Override
	public AniwaysImageSpan createImageSpan(Object data, Phrase phrase,
			IAniwaysImageSpan.IconSelectionOrigin selectionOrigin,
			Context context, int width, int height, IIconInfoDisplayer iconInfoDisplayer) {
		if(isAnimated()){
			AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();

			if (iconInfoDisplayer != null){
				return new AniwaysAnimatedGifSpan((byte[]) data, phrase, this, selectionOrigin, width, height);
			} else {
                Bitmap bitmap = AniwaysBitmapDecodeUtils.decodeBitmapFromByteArray((byte[]) data, config.getMaxWidthForCache(this), config.getMaxHeightForCache(this), getFileName(), false);
				return new AniwaysImageSpan(bitmap, phrase, this, selectionOrigin, context, width, height);
			}
		}

		return new AniwaysImageSpan((Bitmap)data, phrase, this, selectionOrigin, context, width, height);
	}

	public Drawable setDrawableBounds(Drawable drawable, int maxWidth, int maxHeight){
        if(drawable == null){
            return null;
        }

		int height = getIconHeight(drawable, maxHeight);
		int width = getIconWidth(drawable, maxWidth);

		drawable.setBounds(0,0,width,height);
		return drawable;
	}

	/**
	 * Calculate the height of the icon and preserve aspect ratio with its width.
	 * If the height >= width then get the max height. Otherwise get max height * aspect ratio
	 * TODO: Here, and in het height, deal with getting the intrinsic height const in the drawables cache
	 */
	private static int getIconHeight(Drawable d, int maxHeight){
		return getIconHeight(d.getIntrinsicWidth(), d.getIntrinsicHeight(), maxHeight);
	}

	private static int getIconHeight(int intrinsicWidth, int intrinsicHeight, int maxHeight){
		if(maxHeight == USE_INTRINSIC_SIZE){
			maxHeight = intrinsicHeight;
		}

		if(intrinsicHeight >= intrinsicWidth){
			return maxHeight;
		}

		float ratio = (float)intrinsicHeight / (float)intrinsicWidth;
		int result = Math.round(maxHeight * ratio);
		return result;
	}

	/**
	 * Calculate the width of the icon and preserve aspect ratio with its height.
	 * If the width >= height then get the max width. Otherwise get max width * aspect ratio
	 */
	private static int getIconWidth(Drawable d, int maxWidth){
		return getIconWidth(d.getIntrinsicWidth(), d.getIntrinsicHeight(), maxWidth);
	}

	private static int getIconWidth(int intrinsicWidth, int intrinsicHeight, int maxWidth){
		if(maxWidth == USE_INTRINSIC_SIZE){
			maxWidth = intrinsicWidth;
		}

		if(intrinsicWidth >= intrinsicHeight){
			return maxWidth;
		}

		float ratio = (float)intrinsicWidth / (float)intrinsicHeight;
		int result = Math.round(maxWidth * ratio);
		return result;
	}

    //TODO: this should also be a member class and merged with the generateDrawable method, but we need to think it through because it is used also in Volley where
    //      I am not sure will always have an IconData object. Also, some icons need to be drawn as animations depending on circumstances, so not always true
    //      to maje the generateDrawable method return animation
	public static Drawable generateAnimatedDrawable(byte[] data) {
		Drawable gifDrawable = null;
		try{
			gifDrawable = new GifDrawable(data);
		} catch (Throwable ex) {
			Log.e(true, TAG, "Failed to create an animated gif drawable", ex);
		}
		return gifDrawable;
	}

    public String getUrl(boolean useSmallEmoji, boolean displayBig, boolean displayBanner) {
        return null;
    }

    public Drawable generateDrawable(Bitmap image, Context ctx) {

        if(ctx == null){
            Log.e(true, TAG, "context is null");
            return null;
        }
        if(image == null){
            Log.e(true, TAG, "image is null");
            return null;
        }

        return new BitmapDrawable(ctx.getResources(), image);
    }

    public String getAssetIdFromProvider(){
        return String.valueOf(id);
    }
}