package com.aniways;

/**
 * Defines the different asset types.
 */
public enum AssetType {
    Unknown      (-1),
	Emoticons (0),
	Emoji     (1),
    Sticker (2),
    AnimatedGif (3),
    Image (4),
    Video (5),
    Music (6),
    Place (7),
    Settings(8);

	private final int mAssetCode;

	AssetType(int assetCode) {
		mAssetCode = assetCode;
	}

	public int getAssetCode(){
		return mAssetCode;
	}

	public static AssetType getAssetType(int assetCode){
		switch (assetCode){
			case 0: return Emoticons;
			case 1: return Emoji; //TODO: remove this
            case 2: return Sticker;
            case 3: return AnimatedGif;
            case 4: return Image;
            case 5: return Video;
            case 6: return Music;
            case 7: return Place;
			default: return Unknown;
		}
	}
}
