/**
 * 
 */
package com.aniways;

import java.util.List;

import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

/**
 * @author Shai
 *
 */
public class AniwaysVerticalLinearLayout extends LinearLayout {
	private static final String TAG = "AniwaysVerticalLinearLayout";
	//private static final String XML_NS = "http://schemas.android.com/apk/res/android";
	private LinearLayout mPlaceholder;
	private AniwaysEditText mEditText;
	private AniwaysEmoticonsOnDemandButton mButton;
	private boolean mSuccessfullyCreatedButton = false;


	public AniwaysVerticalLinearLayout(Context context)
	{
		this(context, null);
	}

	public AniwaysVerticalLinearLayout(Context context, AttributeSet attributeSet)
	{
		super(context, attributeSet);
		if(!this.isInEditMode()){
			//mAniwaysEditTextAndTextViewerCommonPart = new AniwaysEditTextAndTextViewCommonPart(this);
		}
		//int orientation = attributeSet.getAttributeIntValue(XML_NS, "orientation", -1);
		//if (orientation != -1) {
		//	setOrientation(orientation);
		//}

		init(context);
	}

	@SuppressLint("NewApi")
	public AniwaysVerticalLinearLayout(Context context, AttributeSet attrs, int defStyle){
		super(context, attrs, defStyle);
		init(context);
	}

	private void init(Context context) {
		setOrientation(LinearLayout.VERTICAL);
		LinearLayout placeholder = (LinearLayout) LayoutInflater.from(context).inflate(R.layout.aniways_emoticons_button_popup_placeholder, null);
		ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT); 
		this.addView(placeholder, params);
		mPlaceholder = placeholder;
	}



	//@Override
	//public int getOrientation(){
	//	return LinearLayout.VERTICAL;
	//}


	@Override
	public void addView(View child, int index, ViewGroup.LayoutParams params){
		// If the child should go last, then put it last before the popup placeholder

		int numChildren = this.getChildCount();
		if(index == numChildren || index < 0){
			index = numChildren - 1;
		}

		super.addView(child, index, params);
	}

	LinearLayout getPlaceholder(){
		return this.mPlaceholder;
	}

	AniwaysEditText getAniwaysEditText(){
		if(mEditText != null){
			return mEditText;
		}

		List<AniwaysEditText> editTexts = ViewUtils.find(this, AniwaysEditText.class);

		if(editTexts == null || editTexts.isEmpty()){
			return null;
		}

		return editTexts.get(0);
	}

	AniwaysEmoticonsOnDemandButton getEmoticonsButton(){
		if(mButton != null){
			return mButton;
		}

		List<AniwaysEmoticonsOnDemandButton> buttons = ViewUtils.find(this, AniwaysEmoticonsOnDemandButton.class);

		if(buttons == null || buttons.isEmpty()){
			return null;
		}

		return buttons.get(0);
	}

	@Override
	protected void onFinishInflate() {
		super.onFinishInflate();

		// Generate the cache for the button and the editText
		//getAniwaysEditText();
		//getEmoticonsButton();
		
		Log.i(TAG, "Finished inflating");

		// Hook the button up to the EditText and Placeholder
		// TODO: deal with nulls within
		if(!this.isInEditMode()){
			mSuccessfullyCreatedButton = new AniwaysEmoticonsButtonMaker().makeButtonAniwaysEmoticonsButton(getEmoticonsButton(), getPlaceholder(), this, getAniwaysEditText(), null, false);
			Log.v(TAG, "Finished inflate. Result: " + mSuccessfullyCreatedButton);
		}

	}

	@Override
	protected void onAttachedToWindow() {
		super.onAttachedToWindow();
		// Hook the button up to the EditText and Placeholder (in case this layout was not inflated, but constructed by code), or
		// the call after the inflate finish did not succeed (if some elements were added by code after inflate)..
		// TODO: deal with nulls within

		if(!this.isInEditMode()){
			if (!mSuccessfullyCreatedButton){
				mSuccessfullyCreatedButton = new AniwaysEmoticonsButtonMaker().makeButtonAniwaysEmoticonsButton(getEmoticonsButton(), getPlaceholder(), this, getAniwaysEditText(), null, false);
				Log.v(TAG, "Finished attaching. Result: " + mSuccessfullyCreatedButton);
			}
		}
	}

	static class LayoutTraverser {

		public interface Processor {
			void process(View view);
		}

		private final Processor processor;

		private LayoutTraverser(Processor processor) {
			this.processor = processor;
		}

		public static LayoutTraverser build(Processor processor) {
			return new LayoutTraverser(processor);
		}

		public void traverse(ViewGroup root, boolean firstPass) {
			final int childCount = root.getChildCount();
			if(firstPass){
				processor.process(root);
			}

			for (int i = 0; i < childCount; ++i) {
				final View child = root.getChildAt(i);
				processor.process(child);

				if (child instanceof ViewGroup) {
					traverse((ViewGroup) child, false);
				}
			}
		}
	}

}
