package com.aniways;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.content.Context;
import android.text.Spannable;
import android.text.Spanned;
import android.widget.EditText;

import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;


// Helper class to insert markers where there is text that can be replaced with an Icon
class AniwaysMarkerInserter {
	public static final Map<Pattern, String> KEYWORDS = new HashMap<Pattern, String>();
	private static final String TAG = "AniwaysMarkerInserter";
	public static boolean sMapComplete = false;

	// TODO: do not do this for the entire text.., only to the parts near the change
	// This method is only called from the AniwaysEditText, so we know that AniwaysStatics is initialized.
	// TODO: consider moving this method to AniwaysEditText, or make this class a private class for AniwaysEditText
	static boolean addSuggestionMarkersToText(Spannable spannable, ISuggestionDisplayer suggestionDisplayer, JsonParser parser, Context context){		

		if(!AniwaysPrivateConfig.getInstance().contextualIconSuggestionsEnabled){
			return false;
		}

		// Remove all marks that do not intersect image spans
		removeAllSpansThatDoNotIntersectImageSpan(spannable, 0, spannable.length(), AniwaysSuggestionSpan.class);
		removeAllSpansThatDoNotIntersectImageSpan(spannable, 0, spannable.length(), IAniwaysWordMarkerSpan.class);

		// This method is only called from the AniwaysEditText, so we know that AniwaysStatics is initialized.
		String s = spannable.toString().toLowerCase(Locale.US);

		// Split on word boundaries, and on non word boundaries if they are before or after a white space
		// in order to mark ':)' in ' :) ' . If we only look for word boundaries then ' :) ' will not be
		// split on the white spaces and we could not match it against the phrases hash set
		String[] words = s.split("\\b|\\B(?=\\W)");

		/*
		Log.d(TAG, "words: ");
		for (String word: words){
			Log.d(TAG, "'" + word + "'");
		}
		 */

		// TODO: add this when we want to not replace all words all the time
		/*
		SparseIntArray wordMarkerSpanPositions = new SparseIntArray();
		AniwaysWordMarkerSpan[] spans = spannable.getSpans(0, spannable.length(), AniwaysWordMarkerSpan.class);
		for(AniwaysWordMarkerSpan span : spans){
			int spanStart = spannable.getSpanStart(span);
			int spanEnd = spannable.getSpanEnd(span);
			wordMarkerSpanPositions.put(spanStart, spanEnd);
		}
		 */

		boolean hasChanges = false;
		boolean ignorePhraseDetected = false;
		HashSet<String> ignoreWords = AniwaysPrivateConfig.getInstance().autoreplaceIgnorePhrases;

		// This calculation is done to include the spaces between the words (they are in the words array, so a phrase with 3 words is 5 items in the arrat)
		int maxDepth = AniwaysPrivateConfig.getInstance().maxWordsInPhrase + AniwaysPrivateConfig.getInstance().maxWordsInPhrase - 1;
		int wordNumber = 0;
		int lengthSoFar = 0;
		int start = 0;
		int end = 0;
		for(String word: words){
			String origWord = word;
			StringBuilder sb = new StringBuilder(word);
			for(int i = 0; i < maxDepth; i++){
				start = lengthSoFar;
				if(i > 0){
					int lastWord = wordNumber + i; 
					if(lastWord >= words.length){
						break;
					}
					sb.append(words[lastWord]);
					word = sb.toString();
				}
				end = lengthSoFar + word.length();

				// Remove ignore phrases
				if(ignoreWords.contains(word)){
					ignorePhraseDetected = true;
					removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysSuggestionSpan.class);
					removeAllSpansIfCompletelyInRange(spannable, start, end, IAniwaysWordMarkerSpan.class);

					AniwaysIgnorePhraseSpan ignoreSpan = new AniwaysIgnorePhraseSpan();
					spannable.setSpan(ignoreSpan, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
					continue;
				}

				Phrase phrase = parser.getPhraseByName(word);
				if(phrase != null){
					int index = phrase.getIndexOfPartToReplaceInPhrase();
					start += index;
					end = start + phrase.getLengthOfPartToReplace();

					// TODO: add this when we want to not replace all words all the time
					/*
					if (wordMarkerSpanPositions.get(start, -1) == end){
						// There is already a suggestion span there..
						continue;
					}
					 */
					if(isRangeIntersectImageSpan(spannable, start, end)){
						continue;
					}

					// TODO: this is not optimal since it will not add this span if there is a span smaller than this
					// yet intersecting this one, but with one end outside of it
					boolean spanLargerThanRangeExists = removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysIgnorePhraseSpan.class);
					spanLargerThanRangeExists |= removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysSuggestionSpan.class);
					spanLargerThanRangeExists |= removeAllSpansIfCompletelyInRange(spannable, start, end, IAniwaysWordMarkerSpan.class);
					if (spanLargerThanRangeExists){
						continue;
					}

					String originalWord = spannable.subSequence(start, end).toString();
					AniwaysSuggestionSpan ass = new AniwaysSuggestionSpan(phrase, suggestionDisplayer, originalWord);

					// We put the text in the Work marker span in this way because we want to preserve letter capitalization
					// If we use phrase.getPartToReplace then we get all in lower case..
					IAniwaysWordMarkerSpan awms = new AniwaysNonSelectedWordMarkerSpan(context, originalWord, ((EditText) suggestionDisplayer).getTextSize());

					spannable.setSpan(awms, start, end, Spanned.SPAN_INCLUSIVE_INCLUSIVE);
					spannable.setSpan(ass, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
					hasChanges = true;
				}
			}
			lengthSoFar = lengthSoFar + origWord.length();
			wordNumber++;
		}

		if(ignorePhraseDetected){
			removeAllSpansIfCompletelyInRange(spannable, 0, spannable.length(), AniwaysIgnorePhraseSpan.class);
		}

		return hasChanges;
	}

	/**
	 * This is used for autoreplace..
	 * @param spannable
	 * @param phrases
	 * @param ignorePhrases
	 * @param parser
	 * @return
	 */
	static boolean addSuggestionMarkersToText(Spannable spannable, Pattern phrases, HashSet<String> ignorePhrases, JsonParser parser){		

		boolean hasChanges = false;
		if(phrases == null){
			return false;
		}
		if(ignorePhrases == null){
			ignorePhrases = new HashSet<String>();
		}
		
		Matcher m = phrases.matcher(spannable);
		while (m.find()) { 
			int start = m.start();
			int end = m.end();
			String name = m.group().toLowerCase(Locale.US);

			if(ignorePhrases.contains(name)){
				// We add the ignore phrases to the pattern so they are also detected. 
				// Then, when a phrase is detected, it is first checked
				// if it is in the ignore list before marking it. 
				// Since the regex finds the longest match, then if a phrase for 
				// auto replacement is inside an ignore phrase, the ignore phrase is detected and ignored and 
				// the phrase for auto replacement doesn't
				continue;
			}
			
			Phrase phrase = parser.getPhraseByName(name);
			// this could happen because the Aniways mapping doesn't contain such a phrase
			if (phrase == null){
				if(!parser.getKeywordsVersion().equalsIgnoreCase(AniwaysPhraseReplacementData.EMPTY_PARSER_VERSION)){
					Log.w(true, TAG, "The word is set to be autoreplaced, but is not in the mapping. " + name + ". parser version: " + parser.getKeywordsVersion());
				}
				continue;
			}
			int index = name.indexOf(phrase.getPartToReplace());
			start += index;
			end = start + phrase.getPartToReplace().length();

			if(isRangeIntersectImageSpan(spannable, start, end)){
				continue;
			}

			// TODO: this is not optimal since it will not add this span if there is a span smaller than this
			// yet intersecting this one, but with one end outside of it
			boolean spanLargerThanRangeExists = removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysSuggestionSpan.class);
			spanLargerThanRangeExists |= removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysIgnorePhraseSpan.class);
			if (spanLargerThanRangeExists){
				continue;
			}

			String originalText = spannable.subSequence(start, end).toString();
			AniwaysSuggestionSpan ass = new AniwaysSuggestionSpanForAutoreplace(phrase, null, originalText);
			try{
				spannable.setSpan(ass, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			}
			catch(IndexOutOfBoundsException ex){
				Log.e(true, TAG, "Error while setting suggestion span. Orig message: " + spannable + ". to lower: " + spannable.toString().toLowerCase(Locale.US) + ". Word: " + name + ". Start: " + start + ". End: " + end + ". Spannable length: " + spannable.length() + ". Phrase: " + phrase);
			}

			hasChanges = true;

		}

		return hasChanges;

	}


	/**
	 * @param <T>
	 * @param spannable
	 * @param start
	 * @param end
	 * @param cl
	 * @return
	 */
	private static <T> void removeAllSpansThatDoNotIntersectImageSpan(Spannable spannable, int start, int end, Class<T> cl) {

		T[] spans = spannable.getSpans(start, end, cl);
		for (T span : spans)
		{
			RemoveSpanIfNotIntersectImageSpan(spannable, span);
		}
	}

	/**
	 * @param <T>
	 * @param spannable
	 * @param start
	 * @param end
	 * @param cl
	 * @return
	 */
	private static <T> boolean removeAllSpansIfCompletelyInRange(Spannable spannable, int start, int end, Class<T> cl) {
		boolean spanBiggerThanRangeExists = false;
		T[] spans = spannable.getSpans(start, end, cl);
		for (T span : spans)
		{
			if (spannable.getSpanStart(span) >= start && spannable.getSpanEnd(span) <= end)
			{
				spannable.removeSpan(span);
			}
			else 
			{
				spanBiggerThanRangeExists = true;
			}
		}
		return spanBiggerThanRangeExists;
	}

	/**
	 * @param spannable
	 * @param span
	 */
	private static void RemoveSpanIfNotIntersectImageSpan(Spannable spannable, Object span) {
		boolean spansIntersect = isSpanIntersectImageSpan(spannable, span);
		if(!spansIntersect){
			spannable.removeSpan(span);
		}
	}

	/**
	 * @param spannable
	 * @param span
	 * @return
	 */
	private static boolean isSpanIntersectImageSpan(Spannable spannable, Object span) {
		int start = spannable.getSpanStart(span);
		int end = spannable.getSpanEnd(span);
		return isRangeIntersectImageSpan(spannable, start, end);
	}

	/**
	 * @param spannable
	 * @param start
	 * @param end
	 * @return
	 */
	private static boolean isRangeIntersectImageSpan(Spannable spannable, int start, int end) {
		IAniwaysImageSpan[] ImageSpans = spannable.getSpans(start, end, IAniwaysImageSpan.class);
		// Make sure the spans are intersected and not adjoined
		boolean spansIntersect = false;
		for (IAniwaysImageSpan is : ImageSpans)
		{
			int isStart = spannable.getSpanStart(is);
			int isEnd = spannable.getSpanEnd(is);
			if (!(isStart >= end || isEnd <= start)){
				spansIntersect = true;
			}
		}
		return spansIntersect;
	}

	// Obsolete

	/*
	 private static final Factory spannableFactory = Spannable.Factory.getInstance();

	private static void createMap(){
		// We assume here that the parser was already called and parsed the JSON object
		HashSet<String> positiveKeywords = AniwaysPhraseReplacementData.getPositivePhrasesForSubstitution();
		if(positiveKeywords == null || positiveKeywords.isEmpty()){
			Log.e("MI", "No positive keywords");
		}
		for(String phrase : positiveKeywords){
			addPattern(KEYWORDS, phrase);
		}
		sMapComplete = true; 
	}

	private static void addPattern(Map<Pattern,String> map, String keyword) {
		//map.put(Pattern.compile(Pattern.quote(keyword)), keyword);
		map.put(Pattern.compile("\\b"+keyword+"\\b"), keyword);
	} 

	 */


	/*
	public static boolean addSuggestionMarkersToText(Spannable spannable, ISuggestionDisplayer suggestionDisplayer) throws Exception {		


		if (!sMapComplete){
			createMap();
		}

		// Remove all marks that do not intersect image spans
		removeAllSpansThatDoNotIntersectImageSpan(spannable, 0, spannable.length(), AniwaysSuggestionSpan.class);
		removeAllSpansThatDoNotIntersectImageSpan(spannable, 0, spannable.length(), AniwaysWordMarkerSpan.class);

		boolean hasChanges = false;
		Map<Pattern, String> keywords = KEYWORDS;
		for (Entry<Pattern, String> entry : keywords.entrySet()) {
			Matcher matcher = entry.getKey().matcher(spannable.toString().toLowerCase(Locale.US));
			while (matcher.find()) {
				int start = matcher.start();
				int end = matcher.end();
				if(start == end){
					continue;
				}
				if(isRangeIntersectImageSpan(spannable, start, end)){
					continue;
				}
				boolean spanLargerThanRangeExists = removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysSuggestionSpan.class);
				spanLargerThanRangeExists |= removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysWordMarkerSpan.class);
				if (spanLargerThanRangeExists){
					continue;
				}

				String s = spannable.subSequence(start, end).toString().toLowerCase(Locale.US);
				Phrase phrase = getPhraseFromString(s);

				int index = s.indexOf(phrase.getPartToReplace());

				start += index;
				end = start + phrase.getPartToReplace().length();
				AniwaysWordMarkerSpan bcs = new AniwaysWordMarkerSpan();
				AniwaysSuggestionSpan ass = new AniwaysSuggestionSpan(phrase, suggestionDisplayer);					
				spannable.setSpan(bcs, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
				spannable.setSpan(ass, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
				hasChanges = true;
			}
		}

		return hasChanges;
	}
	 */
}

class AniwaysIgnorePhraseSpan{

}
