package com.aniways;

import com.aniways.data.Phrase;

//not inheriting clickable span so it will not look like a link
public class AniwaysInternalIconInfoSpan implements IAniwaysIconInfoSpan
{
	private static final String TAG = "AniwaysInternalIconInfoSpan";
	private IIconInfoDisplayer mIconInfoDisplayer;
	public Phrase phrase;
	public IconData icon;
	public String originalText;
    private long dismissEventTime = -2;

	public AniwaysInternalIconInfoSpan(Phrase phrase, IconData icon, IIconInfoDisplayer iconInfoDisplayer, String originalText)
	{
		this.phrase = phrase;
		this.mIconInfoDisplayer = iconInfoDisplayer;
		this.icon = icon;
		this.originalText = originalText;
	}

	public void onClick(IAniwaysTextContainer textContainer, long clickEventTime) {
		try{
            if(dismissEventTime != clickEventTime){
              mIconInfoDisplayer.displayIconInfo(this, textContainer);
            }
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught exception in onClick", ex);
		}
	}

    public void setDismissEventTime(long dismissEventTime) {
        this.dismissEventTime = dismissEventTime;
    }
}
