package com.aniways;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.text.style.ImageSpan;

import com.aniways.data.GiphyIconData;
import com.aniways.data.Phrase;

public class AniwaysImageSpan extends ImageSpan implements IAniwaysImageSpan
{
	private static final String TAG = "AniwaysImageSpan";
    private Phrase phrase;
	private IconData icon;
    private ImageSpanMetadata metadata;
	
	public AniwaysImageSpan(Bitmap image, Phrase phrase, IconData icon, IconSelectionOrigin selectionOrigin, Context context, int maxWidth, int maxHeight)
	{
		this(icon == null ? null : icon.generateDrawable(image, context), phrase, icon, selectionOrigin, maxWidth, maxHeight);
	}
	
	protected AniwaysImageSpan(Drawable drawable, Phrase phrase, IconData icon, IconSelectionOrigin selectionOrigin, int maxWidth, int maxHeight){
		super(icon == null ? null : icon.setDrawableBounds(drawable, maxWidth, maxHeight));
		this.icon = icon;
		this.phrase = phrase;
		this.metadata = new ImageSpanMetadata(icon, selectionOrigin);
	}

	@Override
	public Phrase getPhrase() {
		return this.phrase;
	}
	
	@Override
	public IconData getIcon() {
		return this.icon;
	}

    @Override
    public ImageSpanMetadata getImageSpanMetadata() {
        return metadata;
    }

	@Override
	public boolean isLoadingImageSpan() {
		return false;
	}
}

