package com.aniways;

import android.graphics.Point;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.View;

import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.quick.action.ActionItem;
import com.aniways.quick.action.QuickAction;

/**
 * Created by Shai on 09/05/2014.
 */
public class AniwaysIconInfoDisplayer implements IIconInfoDisplayer {

    private static final String TAG = "AniwaysIconInfoDisplayer";
    private QuickAction mQuickAction;

    public AniwaysIconInfoDisplayer() {
    }

	@Override
	public void displayIconInfo(final AniwaysInternalIconInfoSpan infoSpan,
			IAniwaysTextContainer textContainer) {

		long startTime = System.currentTimeMillis();
		String origText = infoSpan.originalText;
		Phrase phrase = infoSpan.phrase;
		Spannable text = textContainer.getText();
		if(origText == null){
			Log.w(true, TAG, "Original text is null. Taking part to replace. Phrase: " + phrase.toString() + ". Text: " + text);
			origText = phrase.getPartToReplace();
		}

        int[] startEnd = new int[] {text.getSpanStart(infoSpan), text.getSpanEnd(infoSpan)};
        Utils.setMaxMinStartEnd(startEnd);
        int start = startEnd[0];
        int end = startEnd[1];

        // calculate center point if arrow comes above or below the line
        Point[] centerPoints = AniwaysEditTextAndTextViewCommonPart.calculateCenterPointsForAboveAndBelowLine(start, end, textContainer);
        if(centerPoints == null){
            // This happens since get point of position in text (down the calling line) returns null after recent layout change
            Log.w(true, TAG, "Not displaying icon info since cannot calculate center point of text in the control");
            return;
        }

        // Create the popup
        QuickAction quickAction = createAndSetNewQuickAction(textContainer.getView(), null, false);
        quickAction.setTouchInterceptor(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if(event.getAction() == MotionEvent.ACTION_OUTSIDE){
                  infoSpan.setDismissEventTime(event.getEventTime());
                }
                return false;

            }
        });
        ActionItem item = new ActionItem(0, origText, null, null);
        quickAction.addActionIconInfo(item);

        //setup the action item click listener
        quickAction.setOnActionItemClickListener(new QuickAction.OnActionItemClickListener() {
            @Override
            public void onItemClick(QuickAction quickAction, int pos, int actionId) {
                //ActionItem actionItem = quickAction.getActionItem(pos);
                if(quickAction.isShowing()){
                    //mAniwaysEditTextAndTextViewerCommonPart.mQuickAction.dismiss();
                }
            }
        });

        String iconPath = infoSpan.icon.getFileName();
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display Icon Info", origText, iconPath, 0);
//        AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayInfo, null, phrase, new IconData[]{infoSpan.icon}, AniwaysStoreManager.isIconUnlocked(infoSpan.icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0,null,null, IAniwaysImageSpan.ImageSpanMetadata.Empty);

        quickAction.showAndCloseAfterDelay(centerPoints[0], centerPoints[1], false);
        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Verbose, startTime, "Performance", "Display Icon Info", "", TAG, "");
    }

	QuickAction createAndSetNewQuickAction(View anchor, JsonParser parser,
			boolean showCreditsIfStoreIsEnabled) {
		if (this.mQuickAction != null && this.mQuickAction.isShowing()) {
			this.mQuickAction.dismiss();
		}
		this.mQuickAction = new QuickAction(anchor.getContext(), anchor,
				parser, showCreditsIfStoreIsEnabled, true, false);
		return mQuickAction;
	}
}
