package com.aniways;

import java.util.ArrayList;
import java.util.List;

import android.view.GestureDetector;
import android.view.MotionEvent;

class AniwaysGestureListener extends GestureDetector.SimpleOnGestureListener { 
	private List<MotionEvent> mRecordedEvents;
	private IAniwaysGestureResponder mGestureResponder;
	private boolean mRecordEvents = false;
	private static final String TAG = "AniwaysGestureListener";

	public AniwaysGestureListener(IAniwaysGestureResponder gestureResponder){
		super();
		this.mGestureResponder = gestureResponder;
		this.mRecordedEvents = new ArrayList<MotionEvent>();
	}

	@Override
	public boolean onDown(MotionEvent event) {  
		return true;
	}

	@Override
	public boolean onSingleTapUp(MotionEvent event) {
		Log.d(TAG, "In onSingleTapUp. Action: " + event.getAction() +  " Recording Events: " + ismRecordEvents());
		return true;
	}

	@Override
	public boolean onSingleTapConfirmed(MotionEvent event) {
		Log.d(TAG, "In onSingleTapConfirmed. Action: " + event.getAction() +  " Recording Events: " + ismRecordEvents());
		mGestureResponder.onSingleTap(event);

		// The recorded events are only for double tap
		clearRecordedEvents();

		return true;
	}

	@Override
	public boolean onDoubleTapEvent(MotionEvent event) {
		//Log.d(TAG, "In onDoubleTapEvent");
		return true;
	}

	@Override
	public boolean onDoubleTap(MotionEvent event) {
		Log.d(TAG, "In onDoubleTap. Action: " + event.getAction() +  " Recording Events: " + ismRecordEvents());

		// If we are recording events it means that they were not send to the EditText cause we are
		// on an AniwaysSuggesitonSpan and we want to handle clicks ourselves.
		// Here, in the double click we play back the events to the EditText to handle them.
		playBackEventsIfRecording();

		return true;
	}

	@Override
	public void onLongPress(MotionEvent event){
		Log.d(TAG, "In onLongPress. Action: " + event.getAction() +  " Recording Events: " + ismRecordEvents());
		
		// If we are recording events it means that they were not send to the EditText cause we are
		// on an AniwaysSuggesitonSpan and we want to handle clicks ourselves.
		// Here, in the long press we play back the events to the EditText to handle them.
		playBackEventsIfRecording();
	}
	
	public void onShowPress(MotionEvent event) {
		Log.d(TAG, "In onShowPress. Action: " + event.getAction() +  " Recording Events: " + ismRecordEvents());
    }

	public boolean ismRecordEvents() {
		return mRecordEvents;
	}

	public void setRecordEvents(boolean recordEvents) {
		this.mRecordEvents = recordEvents;
		if(!recordEvents){
			//Log.d(TAG, "clearing recorded events");
			clearRecordedEvents();
		}
	}

	public void recordEvent(MotionEvent event) {
		this.mRecordedEvents.add(MotionEvent.obtain(event));
	}

	private void clearRecordedEvents(){
		if(mRecordedEvents == null || mRecordedEvents.isEmpty()){
			return;
		}

		// Recycle all events - this is required by the Android SDK for events that we are finished using
		for(MotionEvent event : mRecordedEvents){
			event.recycle();
		}
		
		Log.d(TAG, "Clearing recorded events..");

		mRecordedEvents.clear();
		this.mRecordEvents = false;
	}

	private void playBackEventsIfRecording(){
		if(ismRecordEvents()){
			for (MotionEvent moEvent: this.mRecordedEvents){
				Log.d(TAG, "Sending event to super. Action: " + moEvent.getAction());
				this.mGestureResponder.callSuperOnTouchEvent(moEvent);
			}
		}
		clearRecordedEvents();
	}
}
