/**
 * 
 */
package com.aniways;

import java.util.ArrayList;
import java.util.List;

import android.text.Editable;
import android.util.Pair;

/**
 * @author Shai
 *
 */
public class AniwaysDecoderResult {
	private List<AniwaysDecoderIconData> mIconData;
	private List<Pair<Integer,Integer>> mDeletes;
	private Editable mMessage;
	private AniwaysDecoderError mError;
	
	public AniwaysDecoderResult(Editable message) {
		mIconData = new ArrayList<AniwaysDecoderIconData>(); 
		mDeletes = new ArrayList<Pair<Integer,Integer>>();
		this.mMessage = message;
		this.mError = null;
	}

	public void setError(String message) {
		this.setError(message, null);
	}

	public void setError(String message, Exception e) {
		this.mError = new AniwaysDecoderError(message, e);
	}

	public AniwaysDecoderError getError() {
		return this.mError;
	}
	
	public void setMessage(Editable message) {
		this.mMessage = message;
	}
	
	public Editable getMessage() {
		return this.mMessage;
	}

	public void addIcon(int phraseStartIndex, int subphraseStartIndex, String replacementText, String phraseName, IconData icon, IAniwaysImageSpan.IconSelectionOrigin selectionOrigin) {
		mIconData.add(new AniwaysDecoderIconData(phraseStartIndex, subphraseStartIndex, replacementText, phraseName, icon, selectionOrigin));
	}
	
	public void addDelete(int start, int end) {
		mDeletes.add(new Pair<Integer,Integer>(start, end));
	}
	
	public List<AniwaysDecoderIconData> getIcons(){
		return this.mIconData;
	}
	
	/**
	 * The deletes are ordered, the indexes, are post the following deletes.
	 * Need this mechanism because of a bug in several android versions where editable.replace() removes the spans in some cases,
	 * so can't replace the contents of an editable text with the message in decoder result..
	 */
	public List<Pair<Integer,Integer>> getDeletes(){
		return this.mDeletes;
	}

}
