package com.aniways;

import android.text.TextUtils;

import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.data.PhrasesHashSet;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by moran on 12/4/2014.
 */
public class AniwaysCommercialPhraseMatcher {

    private static AniwaysCommercialPhraseMatcher instance;
    private String mCommercialPharsePatternString = null;
    private Pattern mCommercialPharsePattern = null;

    private AniwaysCommercialPhraseMatcher() {
    }

    public static AniwaysCommercialPhraseMatcher getInstance() {
        if (instance == null)
            instance = new AniwaysCommercialPhraseMatcher();

        return instance;
    }

    public Phrase isMatch(String text) {
        Phrase match = null;

        if (text == null || TextUtils.isEmpty(text))
            return null;

        JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
        if (parser == null)
            return null;

        buildCommercialPhrasesPattern(parser);

        //if unable to create pattern from commercial phrases
        if (mCommercialPharsePattern == null)
            return null;


        Matcher matcher = mCommercialPharsePattern.matcher(text);

        while (matcher.find()) {
            String matchedPhrase = matcher.group(0);
            if(TextUtils.isEmpty(matchedPhrase)){
            	continue;
            }
            match = parser.getCommercialPhrases().get(matchedPhrase.toLowerCase(Locale.US));
            break; //currently we are looking just for one match  - found first one break from loop
        }

        return match;
    }

    private void buildCommercialPhrasesPattern(JsonParser parser) {

        PhrasesHashSet commercialPhrases = parser.getCommercialPhrases();

        if (commercialPhrases == null)
            return;

        StringBuilder sb = new StringBuilder();

        for (Phrase phrase : commercialPhrases) {
            sb.append(Pattern.quote(phrase.getName()));
            sb.append("|");
        }

        sb.deleteCharAt(sb.length() - 1);

        String pattern = "(\\b|\\B(?=\\W))(" + sb.toString() + ")(\\b|\\B(?=\\W)|$)";

        if (mCommercialPharsePatternString == null || !mCommercialPharsePatternString.equals(pattern)) {
            mCommercialPharsePatternString = pattern;
            mCommercialPharsePattern = Pattern.compile(mCommercialPharsePatternString, Pattern.CASE_INSENSITIVE);
        }
    }
}
