package com.aniways;

import java.io.InputStream;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapFactory.Options;

import com.aniways.data.AniwaysPrivateConfig;

public class AniwaysBitmapDecodeUtils {

	private static final String TAG = "AniwaysBitmapDecodeUtils";
	
	public static Bitmap decodeBitmapFromByteArray(byte[] array, int maxWidth, int maxHeight, String imageName, boolean isFromNetwork){
		Options outOptions = new Options();
		outOptions.inJustDecodeBounds = true;
        if(array == null) {Log.w(true, TAG, "Null byte array, image name is:" + imageName +" . image is from network:" + isFromNetwork + ". maxWidth: " + maxWidth + " maxHeight: " + maxHeight);}
		BitmapFactory.decodeByteArray(array, 0, array.length, outOptions);
		
		Options inOptions = getInOptions(maxWidth, maxHeight, outOptions);

		// Decode bitmap with inSampleSize set
		Bitmap result = BitmapFactory.decodeByteArray(array, 0, array.length, inOptions);

		Log.v(TAG, "Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight);
		if(result == null){
			Log.w(true, TAG, "Could not deode image from byte array, image name is:" + imageName +" . image is from network:" + isFromNetwork + " Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight + ". maxWidth: " + maxWidth + " maxHeight: " + maxHeight + " origWidth: " + outOptions.outWidth + " origHeight: " + outOptions.outHeight);
		}
		return result;
	}
	
	public static Bitmap decodeBitmapFromStream(InputStream stream, int maxWidth, int maxHeight, String imageName, boolean isFromNetwork) {
		return decodeBitmapFromStream(stream, stream, maxWidth, maxHeight, imageName, isFromNetwork);
	}
	
	public static Bitmap decodeBitmapFromStream(InputStream stream, InputStream streamForDecodeBounds, int maxWidth, int maxHeight, String imageName, boolean isFromNetwork) {

		Options outOptions = new Options();
		outOptions.inJustDecodeBounds = true;

		BitmapFactory.decodeStream(streamForDecodeBounds, null, outOptions);
		
		Options inOptions = getInOptions(maxWidth, maxHeight, outOptions);

		// Decode bitmap with inSampleSize set
		Bitmap result = BitmapFactory.decodeStream(stream, null, inOptions);

		Log.v(TAG, "Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight);
		if(result == null){
			Log.w(true, TAG, "Could not deode image from stream, image name is:" + imageName +" . image is from network:" + isFromNetwork + " Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight + ". maxWidth: " + maxWidth + " maxHeight: " + maxHeight + " origWidth: " + outOptions.outWidth + " origHeight: " + outOptions.outHeight);
		}
		return result;
	}

	private static Options getInOptions(int maxWidth, int maxHeight, Options outOptions) {
		int sampleSize = 1;
		if(maxHeight != 0 || maxWidth != 0){
			sampleSize = calculateInSampleSize(outOptions, maxWidth, maxHeight);
		}
		Log.v(TAG, "Calculated sample size to be: " + sampleSize + " maxWidth: " + maxWidth + " maxHeight: " + maxHeight + " origWidth: " + outOptions.outWidth + " origHeight: " + outOptions.outHeight);

		// Set decode options
		Options inOptions = new Options(); // Create new cause some phones font like the out bounds to be filled
		inOptions.inInputShareable = true;
		inOptions.inPurgeable = true;
		inOptions.inSampleSize = sampleSize;
		inOptions.inJustDecodeBounds = false;
		if(AniwaysPrivateConfig.getInstance().isLowMemoryDevice()){
			inOptions.inPreferredConfig = Bitmap.Config.ARGB_4444;
		}
		return inOptions;
	}

	private static int calculateInSampleSize(Options options, int maxWidth,
			int maxHeight) {
		// Raw height and width of image
		final int height = options.outHeight;
		final int width = options.outWidth;

		if(maxWidth == 0) {
			maxWidth = width;
		}

		if(maxHeight == 0){
			maxHeight = height;
		}

		int inSampleSize = 1;

		if (height > maxHeight || width > maxWidth) {

			// Calculate ratios of height and width to requested height and width
			final int heightRatio = (int)Math.floor((float) height / (float) maxHeight);
			final int widthRatio = (int)Math.floor((float) width / (float) maxWidth);

			// Choose the biggest ratio as inSampleSize value, this will guarantee
			// that the picture will be scaled down so that the biggest dimension will be 
			// still >= max dimension, but small as possible
			inSampleSize = heightRatio < widthRatio ? widthRatio : heightRatio;
		}

		return Math.min(inSampleSize, AniwaysPrivateConfig.getInstance().maxInSampleSize);
	}

}
