/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager.protobuf.nano;

import aniways.com.google.tagmanager.protobuf.nano.MessageNano;
import aniways.com.google.tagmanager.protobuf.nano.WireFormatNano;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class CodedOutputByteBufferNano {
    private final byte[] buffer;
    private final int limit;
    private int position;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    private CodedOutputByteBufferNano(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.position = offset;
        this.limit = offset + length;
    }

    public static CodedOutputByteBufferNano newInstance(byte[] flatArray) {
        return CodedOutputByteBufferNano.newInstance(flatArray, 0, flatArray.length);
    }

    public static CodedOutputByteBufferNano newInstance(byte[] flatArray, int offset, int length) {
        return new CodedOutputByteBufferNano(flatArray, offset, length);
    }

    public void writeDouble(int fieldNumber, double value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeDoubleNoTag(value);
    }

    public void writeFloat(int fieldNumber, float value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFloatNoTag(value);
    }

    public void writeUInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt64NoTag(value);
    }

    public void writeInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value);
    }

    public void writeFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value);
    }

    public void writeBool(int fieldNumber, boolean value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeBoolNoTag(value);
    }

    public void writeString(int fieldNumber, String value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value);
    }

    public void writeGroup(int fieldNumber, MessageNano value) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value);
        this.writeTag(fieldNumber, 4);
    }

    public void writeMessage(int fieldNumber, MessageNano value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeMessageNoTag(value);
    }

    public void writeBytes(int fieldNumber, byte[] value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value);
    }

    public void writeByteArray(int fieldNumber, byte[] value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeByteArrayNoTag(value);
    }

    public void writeUInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeEnum(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeEnumNoTag(value);
    }

    public void writeSFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeSFixed32NoTag(value);
    }

    public void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeSFixed64NoTag(value);
    }

    public void writeSInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt32NoTag(value);
    }

    public void writeSInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt64NoTag(value);
    }

    public void writeDoubleNoTag(double value) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToLongBits(value));
    }

    public void writeFloatNoTag(float value) throws IOException {
        this.writeRawLittleEndian32(Float.floatToIntBits(value));
    }

    public void writeUInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(value);
    }

    public void writeInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(value);
    }

    public void writeInt32NoTag(int value) throws IOException {
        if (value >= 0) {
            this.writeRawVarint32(value);
        } else {
            this.writeRawVarint64(value);
        }
    }

    public void writeFixed64NoTag(long value) throws IOException {
        this.writeRawLittleEndian64(value);
    }

    public void writeFixed32NoTag(int value) throws IOException {
        this.writeRawLittleEndian32(value);
    }

    public void writeBoolNoTag(boolean value) throws IOException {
        this.writeRawByte(value ? 1 : 0);
    }

    public void writeStringNoTag(String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        this.writeRawVarint32(bytes.length);
        this.writeRawBytes(bytes);
    }

    public void writeGroupNoTag(MessageNano value) throws IOException {
        value.writeTo(this);
    }

    public void writeMessageNoTag(MessageNano value) throws IOException {
        this.writeRawVarint32(value.getCachedSize());
        value.writeTo(this);
    }

    public void writeBytesNoTag(byte[] value) throws IOException {
        this.writeRawVarint32(value.length);
        this.writeRawBytes(value);
    }

    public void writeByteArrayNoTag(byte[] value) throws IOException {
        this.writeRawVarint32(value.length);
        this.writeRawBytes(value);
    }

    public void writeUInt32NoTag(int value) throws IOException {
        this.writeRawVarint32(value);
    }

    public void writeEnumNoTag(int value) throws IOException {
        this.writeRawVarint32(value);
    }

    public void writeSFixed32NoTag(int value) throws IOException {
        this.writeRawLittleEndian32(value);
    }

    public void writeSFixed64NoTag(long value) throws IOException {
        this.writeRawLittleEndian64(value);
    }

    public void writeSInt32NoTag(int value) throws IOException {
        this.writeRawVarint32(CodedOutputByteBufferNano.encodeZigZag32(value));
    }

    public void writeSInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(CodedOutputByteBufferNano.encodeZigZag64(value));
    }

    public static int computeDoubleSize(int fieldNumber, double value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeDoubleSizeNoTag(value);
    }

    public static int computeFloatSize(int fieldNumber, float value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeFloatSizeNoTag(value);
    }

    public static int computeUInt64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeUInt64SizeNoTag(value);
    }

    public static int computeInt64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeInt64SizeNoTag(value);
    }

    public static int computeInt32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeInt32SizeNoTag(value);
    }

    public static int computeFixed64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeFixed64SizeNoTag(value);
    }

    public static int computeFixed32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeFixed32SizeNoTag(value);
    }

    public static int computeBoolSize(int fieldNumber, boolean value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeBoolSizeNoTag(value);
    }

    public static int computeStringSize(int fieldNumber, String value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeStringSizeNoTag(value);
    }

    public static int computeGroupSize(int fieldNumber, MessageNano value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) * 2 + CodedOutputByteBufferNano.computeGroupSizeNoTag(value);
    }

    public static int computeMessageSize(int fieldNumber, MessageNano value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeMessageSizeNoTag(value);
    }

    public static int computeBytesSize(int fieldNumber, byte[] value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeBytesSizeNoTag(value);
    }

    public static int computeByteArraySize(int fieldNumber, byte[] value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeByteArraySizeNoTag(value);
    }

    public static int computeUInt32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeUInt32SizeNoTag(value);
    }

    public static int computeEnumSize(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeEnumSizeNoTag(value);
    }

    public static int computeSFixed32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSFixed32SizeNoTag(value);
    }

    public static int computeSFixed64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSFixed64SizeNoTag(value);
    }

    public static int computeSInt32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSInt32SizeNoTag(value);
    }

    public static int computeSInt64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSInt64SizeNoTag(value);
    }

    public static int computeDoubleSizeNoTag(double value) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float value) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long value) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(value);
    }

    public static int computeInt64SizeNoTag(long value) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(value);
    }

    public static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            return CodedOutputByteBufferNano.computeRawVarint32Size(value);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean value) {
        return 1;
    }

    public static int computeStringSizeNoTag(String value) {
        try {
            byte[] bytes = value.getBytes("UTF-8");
            return CodedOutputByteBufferNano.computeRawVarint32Size(bytes.length) + bytes.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported.");
        }
    }

    public static int computeGroupSizeNoTag(MessageNano value) {
        return value.getSerializedSize();
    }

    public static int computeMessageSizeNoTag(MessageNano value) {
        int size = value.getSerializedSize();
        return CodedOutputByteBufferNano.computeRawVarint32Size(size) + size;
    }

    public static int computeBytesSizeNoTag(byte[] value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(value.length) + value.length;
    }

    public static int computeByteArraySizeNoTag(byte[] value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(value.length) + value.length;
    }

    public static int computeUInt32SizeNoTag(int value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(value);
    }

    public static int computeEnumSizeNoTag(int value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(value);
    }

    public static int computeSFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(CodedOutputByteBufferNano.encodeZigZag32(value));
    }

    public static int computeSInt64SizeNoTag(long value) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(CodedOutputByteBufferNano.encodeZigZag64(value));
    }

    public int spaceLeft() {
        return this.limit - this.position;
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void writeRawByte(byte value) throws IOException {
        if (this.position == this.limit) {
            throw new OutOfSpaceException(this.position, this.limit);
        }
        this.buffer[this.position++] = value;
    }

    public void writeRawByte(int value) throws IOException {
        this.writeRawByte((byte)value);
    }

    public void writeRawBytes(byte[] value) throws IOException {
        this.writeRawBytes(value, 0, value.length);
    }

    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        if (this.limit - this.position >= length) {
            System.arraycopy(value, offset, this.buffer, this.position, length);
            this.position += length;
        } else {
            throw new OutOfSpaceException(this.position, this.limit);
        }
    }

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeRawVarint32(WireFormatNano.makeTag(fieldNumber, wireType));
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(WireFormatNano.makeTag(fieldNumber, 0));
    }

    public void writeRawVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value);
                return;
            }
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawLittleEndian32(int value) throws IOException {
        this.writeRawByte(value & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte(value >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long value) throws IOException {
        this.writeRawByte((int)value & 0xFF);
        this.writeRawByte((int)(value >> 8) & 0xFF);
        this.writeRawByte((int)(value >> 16) & 0xFF);
        this.writeRawByte((int)(value >> 24) & 0xFF);
        this.writeRawByte((int)(value >> 32) & 0xFF);
        this.writeRawByte((int)(value >> 40) & 0xFF);
        this.writeRawByte((int)(value >> 48) & 0xFF);
        this.writeRawByte((int)(value >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        OutOfSpaceException(int position, int limit) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + position + " limit " + limit + ").");
        }
    }
}

