/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.ObjectAndStatic;
import aniways.com.google.tagmanager.Types;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class ValueEscapeUtil {
    private ValueEscapeUtil() {
    }

    static ObjectAndStatic<TypeSystem.Value> applyEscapings(ObjectAndStatic<TypeSystem.Value> value, int ... escapings) {
        ObjectAndStatic<TypeSystem.Value> escapedValue = value;
        for (int escaping : escapings) {
            escapedValue = ValueEscapeUtil.applyEscaping(escapedValue, escaping);
        }
        return escapedValue;
    }

    static String urlEncode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
    }

    private static ObjectAndStatic<TypeSystem.Value> applyEscaping(ObjectAndStatic<TypeSystem.Value> value, int escaping) {
        if (!ValueEscapeUtil.isValidStringType(value.getObject())) {
            Log.e("Escaping can only be applied to strings.");
            return value;
        }
        switch (escaping) {
            case 12: {
                return ValueEscapeUtil.escapeUri(value);
            }
        }
        Log.e("Unsupported Value Escaping: " + escaping);
        return value;
    }

    private static ObjectAndStatic<TypeSystem.Value> escapeUri(ObjectAndStatic<TypeSystem.Value> value) {
        try {
            String escapedString = ValueEscapeUtil.urlEncode(Types.valueToString(value.getObject()));
            return new ObjectAndStatic<TypeSystem.Value>(Types.objectToValue(escapedString), value.isStatic());
        }
        catch (UnsupportedEncodingException e) {
            Log.e("Escape URI: unsupported encoding", e);
            return value;
        }
    }

    private static boolean isValidStringType(TypeSystem.Value value) {
        return Types.valueToObject(value) instanceof String;
    }
}

