/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.containertag.proto.Serving;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.AdvertiserIdMacro;
import aniways.com.google.tagmanager.AdvertisingTrackingEnabledMacro;
import aniways.com.google.tagmanager.AdwordsClickReferrerMacro;
import aniways.com.google.tagmanager.AppIdMacro;
import aniways.com.google.tagmanager.AppNameMacro;
import aniways.com.google.tagmanager.AppVersionMacro;
import aniways.com.google.tagmanager.ArbitraryPixelTag;
import aniways.com.google.tagmanager.Cache;
import aniways.com.google.tagmanager.CacheFactory;
import aniways.com.google.tagmanager.ConstantMacro;
import aniways.com.google.tagmanager.ContainerVersionMacro;
import aniways.com.google.tagmanager.ContainsPredicate;
import aniways.com.google.tagmanager.CustomFunctionCall;
import aniways.com.google.tagmanager.DataLayer;
import aniways.com.google.tagmanager.DataLayerEventEvaluationInfoBuilder;
import aniways.com.google.tagmanager.DataLayerMacro;
import aniways.com.google.tagmanager.DataLayerWriteTag;
import aniways.com.google.tagmanager.DeviceIdMacro;
import aniways.com.google.tagmanager.DeviceNameMacro;
import aniways.com.google.tagmanager.EncodeMacro;
import aniways.com.google.tagmanager.EndsWithPredicate;
import aniways.com.google.tagmanager.EqualsPredicate;
import aniways.com.google.tagmanager.EventInfoBuilder;
import aniways.com.google.tagmanager.EventInfoDistributor;
import aniways.com.google.tagmanager.EventMacro;
import aniways.com.google.tagmanager.ExperimentMacroHelper;
import aniways.com.google.tagmanager.FunctionCallImplementation;
import aniways.com.google.tagmanager.GreaterEqualsPredicate;
import aniways.com.google.tagmanager.GreaterThanPredicate;
import aniways.com.google.tagmanager.GtmVersionMacro;
import aniways.com.google.tagmanager.HashMacro;
import aniways.com.google.tagmanager.InstallReferrerMacro;
import aniways.com.google.tagmanager.JoinerMacro;
import aniways.com.google.tagmanager.LanguageMacro;
import aniways.com.google.tagmanager.LessEqualsPredicate;
import aniways.com.google.tagmanager.LessThanPredicate;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.MacroEvaluationInfoBuilder;
import aniways.com.google.tagmanager.MobileAdwordsUniqueIdMacro;
import aniways.com.google.tagmanager.NoopEventInfoDistributor;
import aniways.com.google.tagmanager.NoopValueBuilder;
import aniways.com.google.tagmanager.ObjectAndStatic;
import aniways.com.google.tagmanager.OsVersionMacro;
import aniways.com.google.tagmanager.PlatformMacro;
import aniways.com.google.tagmanager.RandomMacro;
import aniways.com.google.tagmanager.RegexGroupMacro;
import aniways.com.google.tagmanager.RegexPredicate;
import aniways.com.google.tagmanager.ResolutionMacro;
import aniways.com.google.tagmanager.ResolvedFunctionCallBuilder;
import aniways.com.google.tagmanager.ResolvedPropertyBuilder;
import aniways.com.google.tagmanager.ResolvedRuleBuilder;
import aniways.com.google.tagmanager.ResourceUtil;
import aniways.com.google.tagmanager.RuleEvaluationStepInfoBuilder;
import aniways.com.google.tagmanager.RuntimeVersionMacro;
import aniways.com.google.tagmanager.SdkVersionMacro;
import aniways.com.google.tagmanager.StartsWithPredicate;
import aniways.com.google.tagmanager.TimeMacro;
import aniways.com.google.tagmanager.Types;
import aniways.com.google.tagmanager.UniversalAnalyticsTag;
import aniways.com.google.tagmanager.ValueBuilder;
import aniways.com.google.tagmanager.ValueEscapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Runtime {
    private static final ObjectAndStatic<TypeSystem.Value> DEFAULT_VALUE_AND_STATIC = new ObjectAndStatic<TypeSystem.Value>(Types.getDefaultValue(), true);
    private static final int MAX_CACHE_SIZE = 0x100000;
    static final String DEFAULT_RULE_NAME = "Unknown";
    static final String EXPERIMENT_SUPPLEMENTAL_NAME_PREFIX = "gaExperiment:";
    private final ResourceUtil.ExpandedResource mResource;
    private final EventInfoDistributor eventInfoDistributor;
    private final Map<String, FunctionCallImplementation> mTrackingTagMap;
    private final Map<String, FunctionCallImplementation> mPredicateMap;
    private final Map<String, FunctionCallImplementation> mMacroMap;
    private final Cache<ResourceUtil.ExpandedFunctionCall, ObjectAndStatic<TypeSystem.Value>> mFunctionCallCache;
    private final Cache<String, CachedMacro> mMacroEvaluationCache;
    private final Set<ResourceUtil.ExpandedRule> mRules;
    private final DataLayer mDataLayer;
    private final Map<String, MacroInfo> mMacroLookup;
    private volatile String mCurrentEventName;

    public Runtime(Context context, ResourceUtil.ExpandedResource resource, DataLayer dataLayer, CustomFunctionCall.CustomEvaluator functionCallMacroEvaluator, CustomFunctionCall.CustomEvaluator functionCallTagEvaluator, EventInfoDistributor eventInfoDistributor) {
        if (resource == null) {
            throw new NullPointerException("resource cannot be null");
        }
        this.mResource = resource;
        this.mRules = new HashSet<ResourceUtil.ExpandedRule>(resource.getRules());
        this.mDataLayer = dataLayer;
        this.eventInfoDistributor = eventInfoDistributor;
        CacheFactory.CacheSizeManager<ResourceUtil.ExpandedFunctionCall, ObjectAndStatic<TypeSystem.Value>> functionCacheSizeManager = new CacheFactory.CacheSizeManager<ResourceUtil.ExpandedFunctionCall, ObjectAndStatic<TypeSystem.Value>>(){

            @Override
            public int sizeOf(ResourceUtil.ExpandedFunctionCall key, ObjectAndStatic<TypeSystem.Value> value) {
                return value.getObject().getCachedSize();
            }
        };
        this.mFunctionCallCache = new CacheFactory<ResourceUtil.ExpandedFunctionCall, ObjectAndStatic<TypeSystem.Value>>().createCache(0x100000, functionCacheSizeManager);
        CacheFactory.CacheSizeManager<String, CachedMacro> macroCacheSizeManager = new CacheFactory.CacheSizeManager<String, CachedMacro>(){

            @Override
            public int sizeOf(String key, CachedMacro value) {
                return key.length() + value.getSize();
            }
        };
        this.mMacroEvaluationCache = new CacheFactory<String, CachedMacro>().createCache(0x100000, macroCacheSizeManager);
        this.mTrackingTagMap = new HashMap<String, FunctionCallImplementation>();
        this.addTrackingTag(new ArbitraryPixelTag(context));
        this.addTrackingTag(new CustomFunctionCall(functionCallTagEvaluator));
        this.addTrackingTag(new DataLayerWriteTag(dataLayer));
        this.addTrackingTag(new UniversalAnalyticsTag(context, dataLayer));
        this.mPredicateMap = new HashMap<String, FunctionCallImplementation>();
        this.addPredicate(new ContainsPredicate());
        this.addPredicate(new EndsWithPredicate());
        this.addPredicate(new EqualsPredicate());
        this.addPredicate(new GreaterEqualsPredicate());
        this.addPredicate(new GreaterThanPredicate());
        this.addPredicate(new LessEqualsPredicate());
        this.addPredicate(new LessThanPredicate());
        this.addPredicate(new RegexPredicate());
        this.addPredicate(new StartsWithPredicate());
        this.mMacroMap = new HashMap<String, FunctionCallImplementation>();
        this.addMacro(new AdvertiserIdMacro(context));
        this.addMacro(new AdvertisingTrackingEnabledMacro());
        this.addMacro(new AdwordsClickReferrerMacro(context));
        this.addMacro(new AppIdMacro(context));
        this.addMacro(new AppNameMacro(context));
        this.addMacro(new AppVersionMacro(context));
        this.addMacro(new ConstantMacro());
        this.addMacro(new ContainerVersionMacro(this));
        this.addMacro(new CustomFunctionCall(functionCallMacroEvaluator));
        this.addMacro(new DataLayerMacro(dataLayer));
        this.addMacro(new DeviceIdMacro(context));
        this.addMacro(new DeviceNameMacro());
        this.addMacro(new EncodeMacro());
        this.addMacro(new EventMacro(this));
        this.addMacro(new GtmVersionMacro());
        this.addMacro(new HashMacro());
        this.addMacro(new InstallReferrerMacro(context));
        this.addMacro(new JoinerMacro());
        this.addMacro(new LanguageMacro());
        this.addMacro(new MobileAdwordsUniqueIdMacro(context));
        this.addMacro(new OsVersionMacro());
        this.addMacro(new PlatformMacro());
        this.addMacro(new RandomMacro());
        this.addMacro(new RegexGroupMacro());
        this.addMacro(new ResolutionMacro(context));
        this.addMacro(new RuntimeVersionMacro());
        this.addMacro(new SdkVersionMacro());
        this.addMacro(new TimeMacro());
        this.mMacroLookup = new HashMap<String, MacroInfo>();
        for (ResourceUtil.ExpandedRule expandedRule : this.mRules) {
            MacroInfo info;
            String ruleName;
            ResourceUtil.ExpandedFunctionCall function;
            int i;
            if (eventInfoDistributor.debugMode()) {
                Runtime.verifyFunctionAndNameListSizes(expandedRule.getAddMacros(), expandedRule.getAddMacroRuleNames(), "add macro");
                Runtime.verifyFunctionAndNameListSizes(expandedRule.getRemoveMacros(), expandedRule.getRemoveMacroRuleNames(), "remove macro");
                Runtime.verifyFunctionAndNameListSizes(expandedRule.getAddTags(), expandedRule.getAddTagRuleNames(), "add tag");
                Runtime.verifyFunctionAndNameListSizes(expandedRule.getRemoveTags(), expandedRule.getRemoveTagRuleNames(), "remove tag");
            }
            for (i = 0; i < expandedRule.getAddMacros().size(); ++i) {
                function = expandedRule.getAddMacros().get(i);
                ruleName = DEFAULT_RULE_NAME;
                if (eventInfoDistributor.debugMode() && i < expandedRule.getAddMacroRuleNames().size()) {
                    ruleName = expandedRule.getAddMacroRuleNames().get(i);
                }
                info = Runtime.getOrAddMacroInfo(this.mMacroLookup, Runtime.getFunctionName(function));
                info.addRule(expandedRule);
                info.addAddMacroForRule(expandedRule, function);
                info.addAddMacroRuleNameForRule(expandedRule, ruleName);
            }
            for (i = 0; i < expandedRule.getRemoveMacros().size(); ++i) {
                function = expandedRule.getRemoveMacros().get(i);
                ruleName = DEFAULT_RULE_NAME;
                if (eventInfoDistributor.debugMode() && i < expandedRule.getRemoveMacroRuleNames().size()) {
                    ruleName = expandedRule.getRemoveMacroRuleNames().get(i);
                }
                info = Runtime.getOrAddMacroInfo(this.mMacroLookup, Runtime.getFunctionName(function));
                info.addRule(expandedRule);
                info.addRemoveMacroForRule(expandedRule, function);
                info.addRemoveMacroRuleNameForRule(expandedRule, ruleName);
            }
        }
        for (Map.Entry entry : this.mResource.getAllMacros().entrySet()) {
            for (ResourceUtil.ExpandedFunctionCall function : (List)entry.getValue()) {
                if (Types.valueToBoolean(function.getProperties().get(Key.NOT_DEFAULT_MACRO.toString())).booleanValue()) continue;
                Runtime.getOrAddMacroInfo(this.mMacroLookup, (String)entry.getKey()).setDefault(function);
            }
        }
    }

    public Runtime(Context context, ResourceUtil.ExpandedResource resource, DataLayer dataLayer, CustomFunctionCall.CustomEvaluator functionCallMacroEvaluator, CustomFunctionCall.CustomEvaluator functionCallTagEvaluator) {
        this(context, resource, dataLayer, functionCallMacroEvaluator, functionCallTagEvaluator, new NoopEventInfoDistributor());
    }

    public ResourceUtil.ExpandedResource getResource() {
        return this.mResource;
    }

    public synchronized void setSupplementals(List<Serving.Supplemental> supplementals) {
        for (Serving.Supplemental supplemental : supplementals) {
            if (supplemental.name == null || !supplemental.name.startsWith(EXPERIMENT_SUPPLEMENTAL_NAME_PREFIX)) {
                Log.v("Ignored supplemental: " + supplemental);
                continue;
            }
            ExperimentMacroHelper.handleExperimentSupplemental(this.mDataLayer, supplemental);
        }
    }

    public synchronized void evaluateTags(String currentEventName) {
        this.setCurrentEventName(currentEventName);
        EventInfoBuilder eventInfoBuilder = this.eventInfoDistributor.createDataLayerEventEvaluationEventInfo(currentEventName);
        DataLayerEventEvaluationInfoBuilder debugDataLayerBuilder = eventInfoBuilder.createDataLayerEventEvaluationInfoBuilder();
        for (ResourceUtil.ExpandedFunctionCall tag : this.calculateTagsToRun(this.mRules, debugDataLayerBuilder.createRulesEvaluation()).getObject()) {
            this.executeFunction(this.mTrackingTagMap, tag, new HashSet<String>(), debugDataLayerBuilder.createAndAddResult());
        }
        eventInfoBuilder.processEventInfo();
        this.setCurrentEventName(null);
    }

    public ObjectAndStatic<TypeSystem.Value> evaluateMacroReference(String macroName) {
        EventInfoBuilder eventInfoBuilder = this.eventInfoDistributor.createMacroEvalutionEventInfo(macroName);
        ObjectAndStatic<TypeSystem.Value> result = this.evaluateMacroReferenceCycleDetection(macroName, new HashSet<String>(), eventInfoBuilder.createMacroEvaluationInfoBuilder());
        eventInfoBuilder.processEventInfo();
        return result;
    }

    @VisibleForTesting
    synchronized void setCurrentEventName(String currentEventName) {
        this.mCurrentEventName = currentEventName;
    }

    synchronized String getCurrentEventName() {
        return this.mCurrentEventName;
    }

    @VisibleForTesting
    ObjectAndStatic<Set<ResourceUtil.ExpandedFunctionCall>> calculateMacrosToRun(String macroName, Set<ResourceUtil.ExpandedRule> rules, final Map<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>> addMacros, final Map<ResourceUtil.ExpandedRule, List<String>> addMacroRuleNames, final Map<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>> removeMacros, final Map<ResourceUtil.ExpandedRule, List<String>> removeMacroRuleNames, Set<String> pendingMacroExpansions, RuleEvaluationStepInfoBuilder debugRulesEvaluation) {
        return this.calculateGenericToRun(rules, pendingMacroExpansions, new AddRemoveSetPopulator(){

            @Override
            public void rulePassed(ResourceUtil.ExpandedRule rule, Set<ResourceUtil.ExpandedFunctionCall> add, Set<ResourceUtil.ExpandedFunctionCall> remove, ResolvedRuleBuilder debugRuleBuilder) {
                List thisAddMacro = (List)addMacros.get(rule);
                List thisMacroEnablingRuleNames = (List)addMacroRuleNames.get(rule);
                if (thisAddMacro != null) {
                    add.addAll(thisAddMacro);
                    debugRuleBuilder.getAddedMacroFunctions().translateAndAddAll(thisAddMacro, thisMacroEnablingRuleNames);
                }
                List thisRemoveMacro = (List)removeMacros.get(rule);
                List thisRemoveMacroRuleNames = (List)removeMacroRuleNames.get(rule);
                if (thisRemoveMacro != null) {
                    remove.addAll(thisRemoveMacro);
                    debugRuleBuilder.getRemovedMacroFunctions().translateAndAddAll(thisRemoveMacro, thisRemoveMacroRuleNames);
                }
            }
        }, debugRulesEvaluation);
    }

    @VisibleForTesting
    ObjectAndStatic<Set<ResourceUtil.ExpandedFunctionCall>> calculateTagsToRun(Set<ResourceUtil.ExpandedRule> rules, RuleEvaluationStepInfoBuilder debugRulesEvaluation) {
        return this.calculateGenericToRun(rules, new HashSet<String>(), new AddRemoveSetPopulator(){

            @Override
            public void rulePassed(ResourceUtil.ExpandedRule rule, Set<ResourceUtil.ExpandedFunctionCall> add, Set<ResourceUtil.ExpandedFunctionCall> remove, ResolvedRuleBuilder debugRuleBuilder) {
                add.addAll(rule.getAddTags());
                remove.addAll(rule.getRemoveTags());
                debugRuleBuilder.getAddedTagFunctions().translateAndAddAll(rule.getAddTags(), rule.getAddTagRuleNames());
                debugRuleBuilder.getRemovedTagFunctions().translateAndAddAll(rule.getRemoveTags(), rule.getRemoveTagRuleNames());
            }
        }, debugRulesEvaluation);
    }

    private static MacroInfo getOrAddMacroInfo(Map<String, MacroInfo> macroLookup, String key) {
        MacroInfo result = macroLookup.get(key);
        if (result == null) {
            result = new MacroInfo();
            macroLookup.put(key, result);
        }
        return result;
    }

    private ObjectAndStatic<Set<ResourceUtil.ExpandedFunctionCall>> calculateGenericToRun(Set<ResourceUtil.ExpandedRule> rules, Set<String> pendingMacroExpansions, AddRemoveSetPopulator setPopulator, RuleEvaluationStepInfoBuilder debugRulesEvaluation) {
        HashSet<ResourceUtil.ExpandedFunctionCall> add = new HashSet<ResourceUtil.ExpandedFunctionCall>();
        HashSet<ResourceUtil.ExpandedFunctionCall> remove = new HashSet<ResourceUtil.ExpandedFunctionCall>();
        boolean allStatic = true;
        for (ResourceUtil.ExpandedRule rule : rules) {
            ResolvedRuleBuilder debugRuleBuilder;
            ObjectAndStatic<Boolean> result = this.evaluatePredicatesInRule(rule, pendingMacroExpansions, debugRuleBuilder = debugRulesEvaluation.createResolvedRuleBuilder());
            if (result.getObject().booleanValue()) {
                setPopulator.rulePassed(rule, add, remove, debugRuleBuilder);
            }
            allStatic = allStatic && result.isStatic();
        }
        add.removeAll(remove);
        debugRulesEvaluation.setEnabledFunctions(add);
        return new ObjectAndStatic<Set<ResourceUtil.ExpandedFunctionCall>>(add, allStatic);
    }

    private static String getFunctionName(ResourceUtil.ExpandedFunctionCall functionCall) {
        return Types.valueToString(functionCall.getProperties().get(Key.INSTANCE_NAME.toString()));
    }

    private static void addFunctionImplToMap(Map<String, FunctionCallImplementation> addTo, FunctionCallImplementation impl) {
        if (addTo.containsKey(impl.getInstanceFunctionId())) {
            throw new IllegalArgumentException("Duplicate function type name: " + impl.getInstanceFunctionId());
        }
        addTo.put(impl.getInstanceFunctionId(), impl);
    }

    @VisibleForTesting
    void addMacro(FunctionCallImplementation macro) {
        Runtime.addFunctionImplToMap(this.mMacroMap, macro);
    }

    @VisibleForTesting
    void addTrackingTag(FunctionCallImplementation tag) {
        Runtime.addFunctionImplToMap(this.mTrackingTagMap, tag);
    }

    @VisibleForTesting
    void addPredicate(FunctionCallImplementation predicate) {
        Runtime.addFunctionImplToMap(this.mPredicateMap, predicate);
    }

    @VisibleForTesting
    ObjectAndStatic<Boolean> evaluatePredicate(ResourceUtil.ExpandedFunctionCall predicate, Set<String> pendingMacroExpansions, ResolvedFunctionCallBuilder debugFunctionCall) {
        ObjectAndStatic<TypeSystem.Value> result = this.executeFunction(this.mPredicateMap, predicate, pendingMacroExpansions, debugFunctionCall);
        Boolean predicateResult = Types.valueToBoolean(result.getObject());
        debugFunctionCall.setFunctionResult(Types.objectToValue(predicateResult));
        return new ObjectAndStatic<Boolean>(predicateResult, result.isStatic());
    }

    @VisibleForTesting
    ObjectAndStatic<Boolean> evaluatePredicatesInRule(ResourceUtil.ExpandedRule rule, Set<String> pendingMacroExpansions, ResolvedRuleBuilder debugRuleBuilder) {
        ObjectAndStatic<Boolean> result;
        boolean allStatic = true;
        for (ResourceUtil.ExpandedFunctionCall f : rule.getNegativePredicates()) {
            result = this.evaluatePredicate(f, pendingMacroExpansions, debugRuleBuilder.createNegativePredicate());
            if (result.getObject().booleanValue()) {
                debugRuleBuilder.setValue(Types.objectToValue(false));
                return new ObjectAndStatic<Boolean>(false, result.isStatic());
            }
            allStatic = allStatic && result.isStatic();
        }
        for (ResourceUtil.ExpandedFunctionCall f : rule.getPositivePredicates()) {
            result = this.evaluatePredicate(f, pendingMacroExpansions, debugRuleBuilder.createPositivePredicate());
            if (!result.getObject().booleanValue()) {
                debugRuleBuilder.setValue(Types.objectToValue(false));
                return new ObjectAndStatic<Boolean>(false, result.isStatic());
            }
            allStatic = allStatic && result.isStatic();
        }
        debugRuleBuilder.setValue(Types.objectToValue(true));
        return new ObjectAndStatic<Boolean>(true, allStatic);
    }

    private ObjectAndStatic<TypeSystem.Value> evaluateMacroReferenceCycleDetection(String macroName, Set<String> pendingMacroExpansions, MacroEvaluationInfoBuilder debugMacroEvaluation) {
        CachedMacro cachedResult = this.mMacroEvaluationCache.get(macroName);
        if (cachedResult != null && !this.eventInfoDistributor.debugMode()) {
            this.pushUnevaluatedValueToDataLayer(cachedResult.getPushAfterEvaluate(), pendingMacroExpansions);
            return cachedResult.getObjectAndStatic();
        }
        MacroInfo macroInfo = this.mMacroLookup.get(macroName);
        if (macroInfo == null) {
            Log.e("Invalid macro: " + macroName);
            return DEFAULT_VALUE_AND_STATIC;
        }
        ObjectAndStatic<Set<ResourceUtil.ExpandedFunctionCall>> macrosToRun = this.calculateMacrosToRun(macroName, macroInfo.getRules(), macroInfo.getAddMacros(), macroInfo.getAddMacroRuleNames(), macroInfo.getRemoveMacros(), macroInfo.getRemoveMacroRuleNames(), pendingMacroExpansions, debugMacroEvaluation.createRulesEvaluation());
        ResourceUtil.ExpandedFunctionCall macro = null;
        if (macrosToRun.getObject().isEmpty()) {
            macro = macroInfo.getDefault();
        } else {
            if (macrosToRun.getObject().size() > 1) {
                Log.w("Multiple macros active for macroName " + macroName);
            }
            macro = macrosToRun.getObject().iterator().next();
        }
        if (macro == null) {
            return DEFAULT_VALUE_AND_STATIC;
        }
        ObjectAndStatic<TypeSystem.Value> macroResult = this.executeFunction(this.mMacroMap, macro, pendingMacroExpansions, debugMacroEvaluation.createResult());
        boolean isStatic = macrosToRun.isStatic() && macroResult.isStatic();
        ObjectAndStatic<TypeSystem.Value> toReturn = macroResult == DEFAULT_VALUE_AND_STATIC ? DEFAULT_VALUE_AND_STATIC : new ObjectAndStatic<TypeSystem.Value>(macroResult.getObject(), isStatic);
        TypeSystem.Value pushAfterEvaluate = macro.getPushAfterEvaluate();
        if (toReturn.isStatic()) {
            this.mMacroEvaluationCache.put(macroName, new CachedMacro(toReturn, pushAfterEvaluate));
        }
        this.pushUnevaluatedValueToDataLayer(pushAfterEvaluate, pendingMacroExpansions);
        return toReturn;
    }

    private void pushUnevaluatedValueToDataLayer(TypeSystem.Value pushAfterEvaluate, Set<String> pendingMacroExpansions) {
        if (pushAfterEvaluate == null) {
            return;
        }
        ObjectAndStatic<TypeSystem.Value> evaluatedPush = this.macroExpandValue(pushAfterEvaluate, pendingMacroExpansions, new NoopValueBuilder());
        if (evaluatedPush != DEFAULT_VALUE_AND_STATIC) {
            Object pushValueAsObject = Types.valueToObject(evaluatedPush.getObject());
            if (pushValueAsObject instanceof Map) {
                Map pushValueAsMap = (Map)pushValueAsObject;
                this.mDataLayer.push(pushValueAsMap);
            } else if (pushValueAsObject instanceof List) {
                List pushValueAsList = (List)pushValueAsObject;
                for (Object item : pushValueAsList) {
                    if (item instanceof Map) {
                        Map pushValueAsMap = (Map)item;
                        this.mDataLayer.push(pushValueAsMap);
                        continue;
                    }
                    Log.w("pushAfterEvaluate: value not a Map");
                }
            } else {
                Log.w("pushAfterEvaluate: value not a Map or List");
            }
        }
    }

    private ObjectAndStatic<TypeSystem.Value> macroExpandValue(TypeSystem.Value value, Set<String> pendingMacroExpansions, ValueBuilder debugValueBuilder) {
        if (!value.containsReferences) {
            return new ObjectAndStatic<TypeSystem.Value>(value, true);
        }
        switch (value.type) {
            case 2: {
                TypeSystem.Value newValue = ResourceUtil.newValueBasedOnValue(value);
                newValue.listItem = new TypeSystem.Value[value.listItem.length];
                for (int i = 0; i < value.listItem.length; ++i) {
                    ObjectAndStatic<TypeSystem.Value> macroExpand = this.macroExpandValue(value.listItem[i], pendingMacroExpansions, debugValueBuilder.getListItem(i));
                    if (macroExpand == DEFAULT_VALUE_AND_STATIC) {
                        return DEFAULT_VALUE_AND_STATIC;
                    }
                    newValue.listItem[i] = macroExpand.getObject();
                }
                return new ObjectAndStatic<TypeSystem.Value>(newValue, false);
            }
            case 3: {
                TypeSystem.Value newValue = ResourceUtil.newValueBasedOnValue(value);
                if (value.mapKey.length != value.mapValue.length) {
                    Log.e("Invalid serving value: " + value.toString());
                    return DEFAULT_VALUE_AND_STATIC;
                }
                newValue.mapKey = new TypeSystem.Value[value.mapKey.length];
                newValue.mapValue = new TypeSystem.Value[value.mapKey.length];
                for (int i = 0; i < value.mapKey.length; ++i) {
                    ObjectAndStatic<TypeSystem.Value> macroExpandKey = this.macroExpandValue(value.mapKey[i], pendingMacroExpansions, debugValueBuilder.getMapKey(i));
                    ObjectAndStatic<TypeSystem.Value> macroExpandValue = this.macroExpandValue(value.mapValue[i], pendingMacroExpansions, debugValueBuilder.getMapValue(i));
                    if (macroExpandKey == DEFAULT_VALUE_AND_STATIC || macroExpandValue == DEFAULT_VALUE_AND_STATIC) {
                        return DEFAULT_VALUE_AND_STATIC;
                    }
                    newValue.mapKey[i] = macroExpandKey.getObject();
                    newValue.mapValue[i] = macroExpandValue.getObject();
                }
                return new ObjectAndStatic<TypeSystem.Value>(newValue, false);
            }
            case 4: {
                if (pendingMacroExpansions.contains(value.macroReference)) {
                    Log.e("Macro cycle detected.  Current macro reference: " + value.macroReference + "." + "  Previous macro references: " + pendingMacroExpansions.toString() + ".");
                    return DEFAULT_VALUE_AND_STATIC;
                }
                pendingMacroExpansions.add(value.macroReference);
                ObjectAndStatic<TypeSystem.Value> result = this.evaluateMacroReferenceCycleDetection(value.macroReference, pendingMacroExpansions, debugValueBuilder.createValueMacroEvaluationInfoExtension());
                result = ValueEscapeUtil.applyEscapings(result, value.escaping);
                pendingMacroExpansions.remove(value.macroReference);
                return result;
            }
            case 7: {
                TypeSystem.Value newValue = ResourceUtil.newValueBasedOnValue(value);
                newValue.templateToken = new TypeSystem.Value[value.templateToken.length];
                for (int i = 0; i < value.templateToken.length; ++i) {
                    ObjectAndStatic<TypeSystem.Value> macroExpand = this.macroExpandValue(value.templateToken[i], pendingMacroExpansions, debugValueBuilder.getTemplateToken(i));
                    if (macroExpand == DEFAULT_VALUE_AND_STATIC) {
                        return DEFAULT_VALUE_AND_STATIC;
                    }
                    newValue.templateToken[i] = macroExpand.getObject();
                }
                return new ObjectAndStatic<TypeSystem.Value>(newValue, false);
            }
        }
        Log.e("Unknown type: " + value.type);
        return DEFAULT_VALUE_AND_STATIC;
    }

    private ObjectAndStatic<TypeSystem.Value> executeFunction(Map<String, FunctionCallImplementation> implMap, ResourceUtil.ExpandedFunctionCall functionCall, Set<String> pendingMacroExpansions, ResolvedFunctionCallBuilder debugFunctionCall) {
        TypeSystem.Value functionIdValue = functionCall.getProperties().get(Key.FUNCTION.toString());
        if (functionIdValue == null) {
            Log.e("No function id in properties");
            return DEFAULT_VALUE_AND_STATIC;
        }
        String functionId = functionIdValue.functionId;
        FunctionCallImplementation impl = implMap.get(functionId);
        if (impl == null) {
            Log.e(functionId + " has no backing implementation.");
            return DEFAULT_VALUE_AND_STATIC;
        }
        ObjectAndStatic<TypeSystem.Value> cachedResult = this.mFunctionCallCache.get(functionCall);
        if (cachedResult != null && !this.eventInfoDistributor.debugMode()) {
            return cachedResult;
        }
        HashMap<String, TypeSystem.Value> expandedParams = new HashMap<String, TypeSystem.Value>();
        boolean allParamsStatic = true;
        for (Map.Entry<String, TypeSystem.Value> originalParam : functionCall.getProperties().entrySet()) {
            ResolvedPropertyBuilder debugProperty = debugFunctionCall.createResolvedPropertyBuilder(originalParam.getKey());
            ObjectAndStatic<TypeSystem.Value> result = this.macroExpandValue(originalParam.getValue(), pendingMacroExpansions, debugProperty.createPropertyValueBuilder(originalParam.getValue()));
            if (result == DEFAULT_VALUE_AND_STATIC) {
                return DEFAULT_VALUE_AND_STATIC;
            }
            if (result.isStatic()) {
                functionCall.updateCacheableProperty(originalParam.getKey(), result.getObject());
            } else {
                allParamsStatic = false;
            }
            expandedParams.put(originalParam.getKey(), result.getObject());
        }
        if (!impl.hasRequiredKeys(expandedParams.keySet())) {
            Log.e("Incorrect keys for function " + functionId + " required " + impl.getRequiredKeys() + " had " + expandedParams.keySet());
            return DEFAULT_VALUE_AND_STATIC;
        }
        boolean cacheable = allParamsStatic && impl.isCacheable();
        ObjectAndStatic<TypeSystem.Value> result = new ObjectAndStatic<TypeSystem.Value>(impl.evaluate(expandedParams), cacheable);
        if (cacheable) {
            this.mFunctionCallCache.put(functionCall, result);
        }
        debugFunctionCall.setFunctionResult(result.getObject());
        return result;
    }

    private static void verifyFunctionAndNameListSizes(List<ResourceUtil.ExpandedFunctionCall> functionList, List<String> ruleNameList, String operation) {
        if (functionList.size() != ruleNameList.size()) {
            Log.i("Invalid resource: imbalance of rule names of functions for " + operation + " operation. Using default rule name instead");
        }
    }

    private static class CachedMacro {
        private ObjectAndStatic<TypeSystem.Value> mObjectAndStatic;
        private TypeSystem.Value mPushAfterEvaluate;

        public CachedMacro(ObjectAndStatic<TypeSystem.Value> objectAndStatic) {
            this(objectAndStatic, null);
        }

        public CachedMacro(ObjectAndStatic<TypeSystem.Value> objectAndStatic, TypeSystem.Value pushAfterEvaluate) {
            this.mObjectAndStatic = objectAndStatic;
            this.mPushAfterEvaluate = pushAfterEvaluate;
        }

        public ObjectAndStatic<TypeSystem.Value> getObjectAndStatic() {
            return this.mObjectAndStatic;
        }

        public TypeSystem.Value getPushAfterEvaluate() {
            return this.mPushAfterEvaluate;
        }

        public int getSize() {
            return this.mObjectAndStatic.getObject().getCachedSize() + (this.mPushAfterEvaluate == null ? 0 : this.mPushAfterEvaluate.getCachedSize());
        }
    }

    static interface AddRemoveSetPopulator {
        public void rulePassed(ResourceUtil.ExpandedRule var1, Set<ResourceUtil.ExpandedFunctionCall> var2, Set<ResourceUtil.ExpandedFunctionCall> var3, ResolvedRuleBuilder var4);
    }

    private static class MacroInfo {
        private final Set<ResourceUtil.ExpandedRule> mRules = new HashSet<ResourceUtil.ExpandedRule>();
        private final Map<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>> mAddMacros = new HashMap<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>>();
        private final Map<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>> mRemoveMacros;
        private final Map<ResourceUtil.ExpandedRule, List<String>> mAddMacroNames = new HashMap<ResourceUtil.ExpandedRule, List<String>>();
        private final Map<ResourceUtil.ExpandedRule, List<String>> mRemoveMacroNames;
        private ResourceUtil.ExpandedFunctionCall mDefault;

        public MacroInfo() {
            this.mRemoveMacros = new HashMap<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>>();
            this.mRemoveMacroNames = new HashMap<ResourceUtil.ExpandedRule, List<String>>();
        }

        public Set<ResourceUtil.ExpandedRule> getRules() {
            return this.mRules;
        }

        public void addRule(ResourceUtil.ExpandedRule rule) {
            this.mRules.add(rule);
        }

        public Map<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>> getAddMacros() {
            return this.mAddMacros;
        }

        public Map<ResourceUtil.ExpandedRule, List<String>> getAddMacroRuleNames() {
            return this.mAddMacroNames;
        }

        public Map<ResourceUtil.ExpandedRule, List<String>> getRemoveMacroRuleNames() {
            return this.mRemoveMacroNames;
        }

        public void addAddMacroForRule(ResourceUtil.ExpandedRule rule, ResourceUtil.ExpandedFunctionCall function) {
            List<ResourceUtil.ExpandedFunctionCall> result = this.mAddMacros.get(rule);
            if (result == null) {
                result = new ArrayList<ResourceUtil.ExpandedFunctionCall>();
                this.mAddMacros.put(rule, result);
            }
            result.add(function);
        }

        public void addAddMacroRuleNameForRule(ResourceUtil.ExpandedRule rule, String ruleName) {
            List<String> result = this.mAddMacroNames.get(rule);
            if (result == null) {
                result = new ArrayList<String>();
                this.mAddMacroNames.put(rule, result);
            }
            result.add(ruleName);
        }

        public Map<ResourceUtil.ExpandedRule, List<ResourceUtil.ExpandedFunctionCall>> getRemoveMacros() {
            return this.mRemoveMacros;
        }

        public void addRemoveMacroForRule(ResourceUtil.ExpandedRule rule, ResourceUtil.ExpandedFunctionCall function) {
            List<ResourceUtil.ExpandedFunctionCall> result = this.mRemoveMacros.get(rule);
            if (result == null) {
                result = new ArrayList<ResourceUtil.ExpandedFunctionCall>();
                this.mRemoveMacros.put(rule, result);
            }
            result.add(function);
        }

        public void addRemoveMacroRuleNameForRule(ResourceUtil.ExpandedRule rule, String ruleName) {
            List<String> result = this.mRemoveMacroNames.get(rule);
            if (result == null) {
                result = new ArrayList<String>();
                this.mRemoveMacroNames.put(rule, result);
            }
            result.add(ruleName);
        }

        public ResourceUtil.ExpandedFunctionCall getDefault() {
            return this.mDefault;
        }

        public void setDefault(ResourceUtil.ExpandedFunctionCall def) {
            this.mDefault = def;
        }
    }
}

