/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.containertag.proto.Serving;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.DataLayer;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.Types;
import java.util.Map;

public class ExperimentMacroHelper {
    public static void handleExperimentSupplemental(DataLayer dataLayer, Serving.Supplemental supplemental) {
        if (supplemental.experimentSupplemental == null) {
            Log.w("supplemental missing experimentSupplemental");
            return;
        }
        ExperimentMacroHelper.clearKeys(dataLayer, supplemental.experimentSupplemental);
        ExperimentMacroHelper.pushValues(dataLayer, supplemental.experimentSupplemental);
        ExperimentMacroHelper.setRandomValues(dataLayer, supplemental.experimentSupplemental);
    }

    private static void clearKeys(DataLayer dataLayer, Serving.GaExperimentSupplemental expSupplemental) {
        for (TypeSystem.Value value : expSupplemental.valueToClear) {
            dataLayer.clearPersistentKeysWithPrefix(Types.valueToString(value));
        }
    }

    private static void pushValues(DataLayer dataLayer, Serving.GaExperimentSupplemental expSupplemental) {
        for (TypeSystem.Value value : expSupplemental.valueToPush) {
            Map<Object, Object> map = ExperimentMacroHelper.valueToMap(value);
            if (map == null) continue;
            dataLayer.push(map);
        }
    }

    private static void setRandomValues(DataLayer dataLayer, Serving.GaExperimentSupplemental expSupplemental) {
        for (Serving.GaExperimentRandom expRandom : expSupplemental.experimentRandom) {
            Long randomValue;
            if (expRandom.key == null) {
                Log.w("GaExperimentRandom: No key");
                continue;
            }
            Object random = dataLayer.get(expRandom.key);
            if (!(random instanceof Number)) {
                randomValue = null;
            } else {
                Number n = (Number)random;
                randomValue = n.longValue();
            }
            long minRandom = expRandom.minRandom;
            long maxRandom = expRandom.maxRandom;
            if (!expRandom.retainOriginalValue || randomValue == null || randomValue < minRandom || randomValue > maxRandom) {
                if (minRandom <= maxRandom) {
                    random = Math.round(Math.random() * (double)(maxRandom - minRandom) + (double)minRandom);
                } else {
                    Log.w("GaExperimentRandom: random range invalid");
                    continue;
                }
            }
            dataLayer.clearPersistentKeysWithPrefix(expRandom.key);
            Map<Object, Object> map = dataLayer.expandKeyValue(expRandom.key, random);
            if (expRandom.lifetimeInMilliseconds > 0L) {
                if (!map.containsKey("gtm")) {
                    map.put("gtm", DataLayer.mapOf("lifetime", expRandom.lifetimeInMilliseconds));
                } else {
                    Object o = map.get("gtm");
                    if (o instanceof Map) {
                        Map gtmMap = (Map)o;
                        gtmMap.put("lifetime", expRandom.lifetimeInMilliseconds);
                    } else {
                        Log.w("GaExperimentRandom: gtm not a map");
                    }
                }
            }
            dataLayer.push(map);
        }
    }

    private static Map<Object, Object> valueToMap(TypeSystem.Value value) {
        Object valueAsObject = Types.valueToObject(value);
        if (!(valueAsObject instanceof Map)) {
            Log.w("value: " + valueAsObject + " is not a map value, ignored.");
            return null;
        }
        Map valueAsMap = (Map)valueAsObject;
        return valueAsMap;
    }
}

