/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import aniways.com.google.analytics.tracking.android.AnalyticsStore;
import aniways.com.google.analytics.tracking.android.AnalyticsStoreStateListener;
import aniways.com.google.analytics.tracking.android.Clock;
import aniways.com.google.analytics.tracking.android.Dispatcher;
import aniways.com.google.analytics.tracking.android.FutureApis;
import aniways.com.google.analytics.tracking.android.GAServiceManager;
import aniways.com.google.analytics.tracking.android.Hit;
import aniways.com.google.analytics.tracking.android.HitBuilder;
import aniways.com.google.analytics.tracking.android.Log;
import aniways.com.google.analytics.tracking.android.NoopDispatcher;
import aniways.com.google.analytics.tracking.android.SimpleNetworkDispatcher;
import aniways.com.google.android.gms.analytics.internal.Command;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class PersistentAnalyticsStore
implements AnalyticsStore {
    @VisibleForTesting
    static final String HIT_ID = "hit_id";
    @VisibleForTesting
    static final String HIT_STRING = "hit_string";
    @VisibleForTesting
    static final String HIT_TIME = "hit_time";
    @VisibleForTesting
    static final String HIT_URL = "hit_url";
    @VisibleForTesting
    static final String HIT_APP_ID = "hit_app_id";
    @VisibleForTesting
    static final String HITS_TABLE = "hits2";
    private static final String CREATE_HITS_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String DATABASE_FILENAME = "google_analytics_v2.db";
    private final AnalyticsDatabaseHelper mDbHelper;
    private volatile Dispatcher mDispatcher;
    private final AnalyticsStoreStateListener mListener;
    private final Context mContext;
    private final String mDatabaseName;
    private long mLastDeleteStaleHitsTime;
    private Clock mClock;

    PersistentAnalyticsStore(AnalyticsStoreStateListener listener, Context ctx) {
        this(listener, ctx, DATABASE_FILENAME);
    }

    @VisibleForTesting
    PersistentAnalyticsStore(AnalyticsStoreStateListener listener, Context ctx, String databaseName) {
        this.mContext = ctx.getApplicationContext();
        this.mDatabaseName = databaseName;
        this.mListener = listener;
        this.mClock = new Clock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        this.mDbHelper = new AnalyticsDatabaseHelper(this.mContext, this.mDatabaseName);
        this.mDispatcher = new SimpleNetworkDispatcher((HttpClient)new DefaultHttpClient(), this.mContext);
        this.mLastDeleteStaleHitsTime = 0L;
    }

    @VisibleForTesting
    public void setClock(Clock clock) {
        this.mClock = clock;
    }

    @VisibleForTesting
    public AnalyticsDatabaseHelper getDbHelper() {
        return this.mDbHelper;
    }

    @Override
    public void setDispatch(boolean dispatch) {
        this.mDispatcher = dispatch ? new SimpleNetworkDispatcher((HttpClient)new DefaultHttpClient(), this.mContext) : new NoopDispatcher();
    }

    @VisibleForTesting
    void setDispatcher(Dispatcher dispatcher) {
        this.mDispatcher = dispatcher;
    }

    @Override
    public void clearHits(long appId) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for clearHits");
        if (db != null) {
            if (appId == 0L) {
                db.delete(HITS_TABLE, null, null);
            } else {
                String[] params = new String[]{Long.valueOf(appId).toString()};
                db.delete(HITS_TABLE, "hit_app_id = ?", params);
            }
            this.mListener.reportStoreIsEmpty(this.getNumStoredHits() == 0);
        }
    }

    @Override
    public void putHit(Map<String, String> wireFormatParams, long hitTimeInMilliseconds, String path, Collection<Command> commands) {
        this.deleteStaleHits();
        this.removeOldHitIfFull();
        this.fillVersionParameter(wireFormatParams, commands);
        this.writeHitToDatabase(wireFormatParams, hitTimeInMilliseconds, path);
    }

    private void fillVersionParameter(Map<String, String> wireFormatParams, Collection<Command> commands) {
        String clientVersionParam = "&_v".substring(1);
        if (commands != null) {
            for (Command command : commands) {
                if (!"appendVersion".equals(command.getId())) continue;
                wireFormatParams.put(clientVersionParam, command.getValue());
                break;
            }
        }
    }

    private void removeOldHitIfFull() {
        int hitsOverLimit = this.getNumStoredHits() - 2000 + 1;
        if (hitsOverLimit > 0) {
            List<String> hitsToDelete = this.peekHitIds(hitsOverLimit);
            Log.v("Store full, deleting " + hitsToDelete.size() + " hits to make room.");
            this.deleteHits(hitsToDelete.toArray(new String[0]));
        }
    }

    private void writeHitToDatabase(Map<String, String> hit, long hitTimeInMilliseconds, String path) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for putHit");
        if (db == null) {
            return;
        }
        ContentValues content = new ContentValues();
        content.put(HIT_STRING, PersistentAnalyticsStore.generateHitString(hit));
        content.put(HIT_TIME, Long.valueOf(hitTimeInMilliseconds));
        long appSystemId = 0L;
        if (hit.containsKey("AppUID")) {
            try {
                appSystemId = Long.parseLong(hit.get("AppUID"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        content.put(HIT_APP_ID, Long.valueOf(appSystemId));
        if (path == null) {
            path = "http://www.google-analytics.com/collect";
        }
        if (path.length() == 0) {
            Log.w("Empty path: not sending hit");
            return;
        }
        content.put(HIT_URL, path);
        try {
            db.insert(HITS_TABLE, null, content);
            this.mListener.reportStoreIsEmpty(false);
        }
        catch (SQLiteException e) {
            Log.w("Error storing hit");
        }
    }

    static String generateHitString(Map<String, String> urlParams) {
        ArrayList<String> keyAndValues = new ArrayList<String>(urlParams.size());
        for (Map.Entry<String, String> entry : urlParams.entrySet()) {
            keyAndValues.add(HitBuilder.encode(entry.getKey()) + "=" + HitBuilder.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", keyAndValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> peekHitIds(int maxHits) {
        ArrayList<String> hitIds = new ArrayList<String>();
        if (maxHits <= 0) {
            Log.w("Invalid maxHits specified. Skipping");
            return hitIds;
        }
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for peekHitIds.");
        if (db == null) {
            return hitIds;
        }
        Cursor cursor = null;
        try {
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID}, null, null, null, null, String.format("%s ASC", HIT_ID), Integer.toString(maxHits));
            if (cursor.moveToFirst()) {
                do {
                    hitIds.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException e) {
            Log.w("Error in peekHits fetching hitIds: " + e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return hitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Hit> peekHits(int maxHits) {
        ArrayList<Hit> hits = new ArrayList<Hit>();
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for peekHits");
        if (db == null) {
            return hits;
        }
        Cursor cursor = null;
        try {
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID, HIT_TIME}, null, null, null, null, String.format("%s ASC", HIT_ID), Integer.toString(maxHits));
            hits = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    Hit hit = new Hit(null, cursor.getLong(0), cursor.getLong(1));
                    hits.add(hit);
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException e) {
            Log.w("Error in peekHits fetching hitIds: " + e.getMessage());
            ArrayList<Hit> arrayList = hits;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int count = 0;
        try {
            CursorWindow cw;
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID, HIT_STRING, HIT_URL}, null, null, null, null, String.format("%s ASC", HIT_ID), Integer.toString(maxHits));
            if (cursor.moveToFirst()) {
                do {
                    if ((cw = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((Hit)hits.get(count)).setHitString(cursor.getString(1));
                        ((Hit)hits.get(count)).setHitUrl(cursor.getString(2));
                    } else {
                        Log.w(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((Hit)hits.get(count)).getHitId()));
                    }
                    ++count;
                } while (cursor.moveToNext());
            }
            cw = hits;
            return cw;
        }
        catch (SQLiteException e) {
            Log.w("Error in peekHits fetching hitString: " + e.getMessage());
            ArrayList<Hit> partialHits = new ArrayList<Hit>();
            boolean foundOneBadHit = false;
            for (Hit hit : hits) {
                if (TextUtils.isEmpty((CharSequence)hit.getHitParams())) {
                    if (foundOneBadHit) break;
                    foundOneBadHit = true;
                }
                partialHits.add(hit);
            }
            ArrayList<Hit> arrayList = partialHits;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @VisibleForTesting
    void setLastDeleteStaleHitsTime(long timeInMilliseconds) {
        this.mLastDeleteStaleHitsTime = timeInMilliseconds;
    }

    int deleteStaleHits() {
        long now = this.mClock.currentTimeMillis();
        if (now <= this.mLastDeleteStaleHitsTime + 86400000L) {
            return 0;
        }
        this.mLastDeleteStaleHitsTime = now;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteStaleHits.");
        if (db == null) {
            return 0;
        }
        long lastGoodTime = this.mClock.currentTimeMillis() - 2592000000L;
        int rslt = db.delete(HITS_TABLE, "HIT_TIME < ?", new String[]{Long.toString(lastGoodTime)});
        this.mListener.reportStoreIsEmpty(this.getNumStoredHits() == 0);
        return rslt;
    }

    @Deprecated
    void deleteHits(Collection<Hit> hits) {
        if (hits == null || hits.isEmpty()) {
            Log.w("Empty/Null collection passed to deleteHits.");
            return;
        }
        String[] hitIds = new String[hits.size()];
        int i = 0;
        for (Hit h : hits) {
            hitIds[i++] = String.valueOf(h.getHitId());
        }
        this.deleteHits(hitIds);
    }

    void deleteHits(String[] hitIds) {
        if (hitIds == null || hitIds.length == 0) {
            Log.w("Empty hitIds passed to deleteHits.");
            return;
        }
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteHits.");
        if (db == null) {
            return;
        }
        String whereClause = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(hitIds.length, "?")));
        try {
            db.delete(HITS_TABLE, whereClause, hitIds);
            this.mListener.reportStoreIsEmpty(this.getNumStoredHits() == 0);
        }
        catch (SQLiteException e) {
            Log.w("Error deleting hits " + hitIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumStoredHits() {
        int numStoredHits = 0;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for getNumStoredHits.");
        if (db == null) {
            return numStoredHits;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                numStoredHits = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException e) {
            Log.w("Error getting numStoredHits");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return numStoredHits;
    }

    @Override
    public void dispatch() {
        Log.v("Dispatch running...");
        if (!this.mDispatcher.okToDispatch()) {
            return;
        }
        List<Hit> hits = this.peekHits(40);
        if (hits.isEmpty()) {
            Log.v("...nothing to dispatch");
            this.mListener.reportStoreIsEmpty(true);
            return;
        }
        int hitsDispatched = this.mDispatcher.dispatchHits(hits);
        Log.v("sent " + hitsDispatched + " of " + hits.size() + " hits");
        this.deleteHits(hits.subList(0, Math.min(hitsDispatched, hits.size())));
        if (hitsDispatched == hits.size() && this.getNumStoredHits() > 0) {
            GAServiceManager.getInstance().dispatchLocalHits();
        }
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.mDispatcher;
    }

    @Override
    public void close() {
        try {
            this.mDbHelper.getWritableDatabase().close();
            this.mDispatcher.close();
        }
        catch (SQLiteException e) {
            Log.w("Error opening database for close");
            return;
        }
    }

    @VisibleForTesting
    AnalyticsDatabaseHelper getHelper() {
        return this.mDbHelper;
    }

    private SQLiteDatabase getWritableDatabase(String errorMessage) {
        SQLiteDatabase db = null;
        try {
            db = this.mDbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            Log.w(errorMessage);
            return null;
        }
        return db;
    }

    @VisibleForTesting
    class AnalyticsDatabaseHelper
    extends SQLiteOpenHelper {
        private boolean mBadDatabase;
        private long mLastDatabaseCheckTime;

        boolean isBadDatabase() {
            return this.mBadDatabase;
        }

        void setBadDatabase(boolean badDatabase) {
            this.mBadDatabase = badDatabase;
        }

        AnalyticsDatabaseHelper(Context context, String databaseName) {
            super(context, databaseName, null, 1);
            this.mLastDatabaseCheckTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tablePresent(String table, SQLiteDatabase db) {
            Cursor cursor = null;
            try {
                cursor = db.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{table}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
            catch (SQLiteException e) {
                Log.w("Error querying for table " + table);
                boolean bl = false;
                return bl;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.mBadDatabase && this.mLastDatabaseCheckTime + 3600000L > PersistentAnalyticsStore.this.mClock.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase db = null;
            this.mBadDatabase = true;
            this.mLastDatabaseCheckTime = PersistentAnalyticsStore.this.mClock.currentTimeMillis();
            try {
                db = super.getWritableDatabase();
            }
            catch (SQLiteException e) {
                PersistentAnalyticsStore.this.mContext.getDatabasePath(PersistentAnalyticsStore.this.mDatabaseName).delete();
            }
            if (db == null) {
                db = super.getWritableDatabase();
            }
            this.mBadDatabase = false;
            return db;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);
                try {
                    cursor.moveToFirst();
                }
                finally {
                    cursor.close();
                }
            }
            if (!this.tablePresent(PersistentAnalyticsStore.HITS_TABLE, db)) {
                db.execSQL(CREATE_HITS_TABLE);
            } else {
                this.validateColumnsPresent(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateColumnsPresent(SQLiteDatabase db) {
            boolean needsAppId;
            Cursor c = db.rawQuery("SELECT * FROM hits2 WHERE 0", null);
            HashSet<String> columns = new HashSet<String>();
            try {
                String[] columnNames = c.getColumnNames();
                for (int i = 0; i < columnNames.length; ++i) {
                    columns.add(columnNames[i]);
                }
            }
            finally {
                c.close();
            }
            if (!(columns.remove(PersistentAnalyticsStore.HIT_ID) && columns.remove(PersistentAnalyticsStore.HIT_URL) && columns.remove(PersistentAnalyticsStore.HIT_STRING) && columns.remove(PersistentAnalyticsStore.HIT_TIME))) {
                throw new SQLiteException("Database column missing");
            }
            boolean bl = needsAppId = !columns.remove(PersistentAnalyticsStore.HIT_APP_ID);
            if (!columns.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
            if (needsAppId) {
                db.execSQL("ALTER TABLE hits2 ADD COLUMN hit_app_id");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            FutureApis.setOwnerOnlyReadWrite(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

