/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import aniways.com.google.analytics.tracking.android.ServiceManager;
import aniways.com.google.android.gms.common.util.VisibleForTesting;

class GANetworkReceiver
extends BroadcastReceiver {
    @VisibleForTesting
    static final String SELF_IDENTIFYING_EXTRA = GANetworkReceiver.class.getName();
    private final ServiceManager mManager;

    GANetworkReceiver(ServiceManager manager) {
        this.mManager = manager;
    }

    public void onReceive(Context ctx, Intent intent) {
        String action = intent.getAction();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
            boolean notConnected = intent.getBooleanExtra("noConnectivity", false);
            this.mManager.updateConnectivityStatus(!notConnected);
        } else if ("aniways.com.google.analytics.RADIO_POWERED".equals(action) && !intent.hasExtra(SELF_IDENTIFYING_EXTRA)) {
            this.mManager.onRadioPowered();
        }
    }

    public void register(Context context) {
        IntentFilter connectivityFilter = new IntentFilter();
        connectivityFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, connectivityFilter);
        IntentFilter radioPoweredFilter = new IntentFilter();
        radioPoweredFilter.addAction("aniways.com.google.analytics.RADIO_POWERED");
        radioPoweredFilter.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, radioPoweredFilter);
    }

    public static void sendRadioPoweredBroadcast(Context context) {
        Intent intent = new Intent("aniways.com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(SELF_IDENTIFYING_EXTRA, true);
        context.sendBroadcast(intent);
    }
}

