/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifInfoHandle;

public class GifDrawableBuilder {
    private Source mSource;
    private GifDrawable mOldDrawable;
    private ScheduledThreadPoolExecutor mExecutor;

    public GifDrawable build() throws IOException {
        if (this.mSource == null) {
            throw new NullPointerException("Source is not set");
        }
        return this.mSource.build(this.mOldDrawable, this.mExecutor);
    }

    public GifDrawableBuilder with(GifDrawable drawable2) {
        this.mOldDrawable = drawable2;
        return this;
    }

    public GifDrawableBuilder threadPoolSize(int threadPoolSize) {
        this.mExecutor = new ScheduledThreadPoolExecutor(threadPoolSize);
        return this;
    }

    public GifDrawableBuilder taskExecutor(ScheduledThreadPoolExecutor executor) {
        this.mExecutor = executor;
        return this;
    }

    public GifDrawableBuilder from(InputStream inputStream) {
        this.mSource = new InputStreamSource(inputStream);
        return this;
    }

    public GifDrawableBuilder from(AssetFileDescriptor assetFileDescriptor) {
        this.mSource = new FileDescriptorSource(assetFileDescriptor);
        return this;
    }

    public GifDrawableBuilder from(FileDescriptor fileDescriptor) {
        this.mSource = new FileDescriptorSource(fileDescriptor);
        return this;
    }

    public GifDrawableBuilder from(AssetManager assetManager, String assetName) {
        this.mSource = new AssetSource(assetManager, assetName);
        return this;
    }

    public GifDrawableBuilder from(ContentResolver contentResolver, Uri uri) {
        this.mSource = new UriSource(contentResolver, uri);
        return this;
    }

    public GifDrawableBuilder from(File file) {
        this.mSource = new FileSource(file);
        return this;
    }

    public GifDrawableBuilder from(String filePath) {
        this.mSource = new FileSource(filePath);
        return this;
    }

    public GifDrawableBuilder from(byte[] bytes) {
        this.mSource = new ByteArraySource(bytes);
        return this;
    }

    public GifDrawableBuilder from(ByteBuffer byteBuffer) {
        this.mSource = new ByteBufferSource(byteBuffer);
        return this;
    }

    public GifDrawableBuilder from(Resources resources, int resourceId) {
        this.mSource = new FileDescriptorSource(resources, resourceId);
        return this;
    }

    private static interface Source {
        public GifDrawable build(GifDrawable var1, ScheduledThreadPoolExecutor var2) throws IOException;
    }

    private static class InputStreamSource
    implements Source {
        private final InputStream inputStream;

        private InputStreamSource(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) throws IOException {
            return new GifDrawable(GifInfoHandle.openMarkableInputStream(this.inputStream, false), -1L, oldDrawable, executor);
        }
    }

    private static class FileDescriptorSource
    implements Source {
        private final FileDescriptor mFd;
        private final long length;
        private final long startOffset;

        private FileDescriptorSource(AssetFileDescriptor assetFileDescriptor) {
            this.mFd = assetFileDescriptor.getFileDescriptor();
            this.length = assetFileDescriptor.getLength();
            this.startOffset = assetFileDescriptor.getStartOffset();
        }

        private FileDescriptorSource(FileDescriptor fileDescriptor) {
            this.mFd = fileDescriptor;
            this.length = -1L;
            this.startOffset = 0L;
        }

        private FileDescriptorSource(Resources resources, int resourceId) {
            this(resources.openRawResourceFd(resourceId));
        }

        @Override
        public GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) throws IOException {
            return new GifDrawable(GifInfoHandle.openFd(this.mFd, this.startOffset, false), this.length, oldDrawable, executor);
        }
    }

    private static class AssetSource
    implements Source {
        private final AssetManager mAssetManager;
        private final String mAssetName;

        private AssetSource(AssetManager assetManager, String assetName) {
            this.mAssetManager = assetManager;
            this.mAssetName = assetName;
        }

        @Override
        public GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) throws IOException {
            return new FileDescriptorSource(this.mAssetManager.openFd(this.mAssetName)).build(oldDrawable, executor);
        }
    }

    private static class UriSource
    implements Source {
        private final ContentResolver mContentResolver;
        private final Uri mUri;

        private UriSource(ContentResolver contentResolver, Uri uri) {
            this.mContentResolver = contentResolver;
            this.mUri = uri;
        }

        @Override
        public GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) throws IOException {
            return new FileDescriptorSource(this.mContentResolver.openAssetFileDescriptor(this.mUri, "r")).build(oldDrawable, executor);
        }
    }

    private static class FileSource
    implements Source {
        private final File mFile;

        private FileSource(File file) {
            this.mFile = file;
        }

        private FileSource(String filePath) {
            this.mFile = new File(filePath);
        }

        @Override
        public GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) throws IOException {
            return new GifDrawable(GifInfoHandle.openFile(this.mFile.getPath(), false), this.mFile.length(), oldDrawable, executor);
        }
    }

    private static class ByteArraySource
    implements Source {
        private final byte[] bytes;

        private ByteArraySource(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) throws IOException {
            return new GifDrawable(GifInfoHandle.openByteArray(this.bytes, false), this.bytes.length, oldDrawable, executor);
        }
    }

    private static class ByteBufferSource
    implements Source {
        private final ByteBuffer byteBuffer;

        private ByteBufferSource(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        public GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) throws IOException {
            return new GifDrawable(GifInfoHandle.openDirectByteBuffer(this.byteBuffer, false), this.byteBuffer.capacity(), oldDrawable, executor);
        }
    }
}

