/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley;

import com.aniways.volley.Cache;
import com.aniways.volley.VolleyError;

public class Response<T> {
    public final T result;
    public final Cache.Entry cacheEntry;
    private byte[] rawdata;
    public final VolleyError error;
    public boolean intermediate = false;

    public static <T> Response<T> success(T result, Cache.Entry cacheEntry, byte[] rawData) {
        return new Response<T>(result, cacheEntry, rawData);
    }

    public static <T> Response<T> error(VolleyError error) {
        return new Response<T>(error);
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    private Response(T result, Cache.Entry cacheEntry) {
        this.result = result;
        this.cacheEntry = cacheEntry;
        this.error = null;
    }

    private Response(T result, Cache.Entry cacheEntry, byte[] rawdata) {
        this.result = result;
        this.cacheEntry = cacheEntry;
        this.rawdata = rawdata;
        this.error = null;
    }

    private Response(VolleyError error) {
        this.result = null;
        this.cacheEntry = null;
        this.error = error;
    }

    public static interface ErrorListener {
        public void onErrorResponse(VolleyError var1);
    }

    public static interface Listener<T> {
        public void onResponse(T var1);
    }
}

