/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley;

import android.os.Process;
import com.aniways.Log;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.volley.Cache;
import com.aniways.volley.NetworkResponse;
import com.aniways.volley.Request;
import com.aniways.volley.Response;
import com.aniways.volley.ResponseDelivery;
import com.aniways.volley.VolleyLog;
import java.util.concurrent.BlockingQueue;

public class CacheDispatcher
extends Thread {
    private static final String TAG = "AniwaysVolleyCacheDispatcher";
    private static final boolean DEBUG = VolleyLog.DEBUG;
    private final BlockingQueue<Request<?>> mCacheQueue;
    private final BlockingQueue<Request<?>> mNetworkQueue;
    private final Cache mCache;
    private final ResponseDelivery mDelivery;
    private volatile boolean mQuit = false;

    public CacheDispatcher(BlockingQueue<Request<?>> cacheQueue, BlockingQueue<Request<?>> networkQueue, Cache cache, ResponseDelivery delivery) {
        this.mCacheQueue = cacheQueue;
        this.mNetworkQueue = networkQueue;
        this.mCache = cache;
        this.mDelivery = delivery;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        if (DEBUG) {
            VolleyLog.v("start new dispatcher", new Object[0]);
        }
        Process.setThreadPriority((int)10);
        this.mCache.initialize();
        while (true) {
            try {
                while (true) {
                    final Request<?> request = this.mCacheQueue.take();
                    request.addMarker("cache-queue-take");
                    if (request.isCanceled()) {
                        request.finish("cache-discard-canceled");
                        continue;
                    }
                    Cache.Entry entry = this.mCache.get(request.getCacheKey());
                    if (entry == null) {
                        request.addMarker("cache-miss");
                        this.mNetworkQueue.put(request);
                        continue;
                    }
                    if (entry.isExpired()) {
                        request.addMarker("cache-hit-expired");
                        request.setCacheEntry(entry);
                        this.mNetworkQueue.put(request);
                        continue;
                    }
                    request.addMarker("cache-hit");
                    Response<?> response = request.parseNetworkResponse(new NetworkResponse(entry.data, entry.responseHeaders, request.getUrl()));
                    request.addMarker("cache-hit-parsed");
                    if (!entry.refreshNeeded()) {
                        this.mDelivery.postResponse(request, response);
                        continue;
                    }
                    request.addMarker("cache-hit-refresh-needed");
                    request.setCacheEntry(entry);
                    response.intermediate = true;
                    this.mDelivery.postResponse(request, response, new NonThrowingRunnable(TAG, "Error in cache dispatcher", null){

                        @Override
                        public void innerRun() {
                            try {
                                CacheDispatcher.this.mNetworkQueue.put(request);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            catch (Throwable t) {
                Log.e(true, TAG, "Error in cache dispatcher", t);
                continue;
            }
            break;
        }
    }
}

