/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.viewpagerindicator;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.support.v4.view.PagerAdapter;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.viewpagerindicator.IconPagerAdapter;
import com.aniways.viewpagerindicator.IcsLinearLayout;
import com.aniways.viewpagerindicator.PageIndicator;

public class TabPageIndicator
extends HorizontalScrollView
implements PageIndicator {
    private static final CharSequence EMPTY_TITLE = "";
    private static final String TAG = "AniwaysTabPageIndicator";
    private NonThrowingRunnable mTabSelector;
    private final View.OnClickListener mTabClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            try {
                TabView tabView = (TabView)view;
                int newSelected = tabView.getIndex();
                TabPageIndicator.this.mViewPager.setCurrentItem(newSelected);
            }
            catch (Throwable ex) {
                Log.e(true, TabPageIndicator.TAG, "Caught Exception in onClick", ex);
            }
        }
    };
    private final IcsLinearLayout mTabLayout;
    private AniwaysDirectionalViewPager mViewPager;
    private AniwaysDirectionalViewPager.OnPageChangeListener mListener;
    private int mMaxTabWidth;
    private int mSelectedTabIndex;

    public TabPageIndicator(Context context) {
        this(context, null);
    }

    public TabPageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setHorizontalScrollBarEnabled(false);
        this.mTabLayout = new IcsLinearLayout(context, R.attr.aniways_vpiTabPageIndicatorStyle);
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            boolean lockedExpanded = widthMode == 0x40000000;
            this.setFillViewport(lockedExpanded);
            int childCount = this.mTabLayout.getChildCount();
            this.mMaxTabWidth = childCount > 1 && (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE) ? (childCount > 2 ? (int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * 0.4f) : View.MeasureSpec.getSize((int)widthMeasureSpec) / 2) : -1;
            int oldWidth = this.getMeasuredWidth();
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int newWidth = this.getMeasuredWidth();
            if (lockedExpanded && oldWidth != newWidth) {
                this.setCurrentItem(this.mSelectedTabIndex);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onMeasure", ex);
        }
    }

    private void animateToTab(int position) {
        final View tabView = this.mTabLayout.getChildAt(position);
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
        this.mTabSelector = new NonThrowingRunnable(TAG, "run of AnimateToTab", ""){

            @Override
            public void innerRun() {
                int scrollPos = tabView.getLeft() - (TabPageIndicator.this.getWidth() - tabView.getWidth()) / 2;
                TabPageIndicator.this.smoothScrollTo(scrollPos, 0);
                TabPageIndicator.this.mTabSelector = null;
            }
        };
        this.post(this.mTabSelector);
    }

    public void onAttachedToWindow() {
        try {
            super.onAttachedToWindow();
            if (this.mTabSelector != null) {
                this.post(this.mTabSelector);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onAttachedToWindow", ex);
        }
    }

    public void onDetachedFromWindow() {
        try {
            super.onDetachedFromWindow();
            if (this.mTabSelector != null) {
                this.removeCallbacks(this.mTabSelector);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onDetachedFromWindow", ex);
        }
    }

    private void addTab(int index, CharSequence text, Drawable icon) {
        if (icon != null) {
            ImageTabView imageTabView = new ImageTabView(this.getContext());
            imageTabView.setImageDrawable(icon);
            imageTabView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            imageTabView.mIndex = index;
            imageTabView.setFocusable(true);
            imageTabView.setOnClickListener(this.mTabClickListener);
            float scale = this.getResources().getDisplayMetrics().density;
            this.mTabLayout.addView((View)imageTabView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)(40.0f * scale + 0.5f), -1, 1.0f));
        } else {
            TextTabView textTabView = new TextTabView(this.getContext());
            textTabView.setText(text);
            textTabView.mIndex = index;
            textTabView.setFocusable(true);
            textTabView.setOnClickListener(this.mTabClickListener);
            this.mTabLayout.addView((View)textTabView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 0.0f));
        }
    }

    @Override
    public void onPageScrollStateChanged(int arg0) {
        try {
            if (this.mListener != null) {
                this.mListener.onPageScrollStateChanged(arg0);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onPageScrollStateChanged", ex);
        }
    }

    @Override
    public void onPageScrolled(int arg0, float arg1, int arg2) {
        try {
            if (this.mListener != null) {
                this.mListener.onPageScrolled(arg0, arg1, arg2);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onPageScrolled", ex);
        }
    }

    @Override
    public void onPageSelected(int arg0) {
        try {
            this.setCurrentItem(arg0);
            if (this.mListener != null) {
                this.mListener.onPageSelected(arg0);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onPageSelected", ex);
        }
    }

    @Override
    public void setViewPager(AniwaysDirectionalViewPager view) {
        PagerAdapter adapter = null;
        try {
            if (this.mViewPager == view) {
                return;
            }
            if (this.mViewPager != null) {
                this.mViewPager.setOnPageChangeListener(null);
            }
            adapter = view.getAdapter();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setViewPager", ex);
        }
        if (adapter == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        try {
            this.mViewPager = view;
            view.setOnPageChangeListener(this);
            this.notifyDataSetChanged();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setViewPager", ex);
        }
    }

    @Override
    public void notifyDataSetChanged() {
        try {
            this.mTabLayout.removeAllViews();
            PagerAdapter adapter = this.mViewPager.getAdapter();
            IconPagerAdapter iconAdapter = null;
            if (adapter instanceof IconPagerAdapter) {
                iconAdapter = (IconPagerAdapter)adapter;
            }
            int count = adapter.getCount();
            for (int i = 0; i < count; ++i) {
                CharSequence title = adapter.getPageTitle(i);
                if (title == null) {
                    title = EMPTY_TITLE;
                }
                Drawable icon = null;
                if (iconAdapter != null) {
                    icon = iconAdapter.getIconDrawable(i);
                }
                this.addTab(i, title, icon);
            }
            if (this.mSelectedTabIndex > count) {
                this.mSelectedTabIndex = count - 1;
            }
            this.setCurrentItem(this.mSelectedTabIndex);
            this.requestLayout();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in notifyDataSetChanged", ex);
        }
    }

    @Override
    public void setViewPager(AniwaysDirectionalViewPager view, int initialPosition) {
        try {
            this.setViewPager(view);
            this.setCurrentItem(initialPosition);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setViewPager", ex);
        }
    }

    @Override
    public void setCurrentItem(int item) {
        try {
            if (this.isInEditMode()) {
                return;
            }
            if (this.mViewPager == null) {
                Log.w(false, TAG, "Tab Pag Indicator ViewPager is not set: Current=" + this.mSelectedTabIndex + ", New=" + item);
                return;
            }
            this.mSelectedTabIndex = item;
            this.mViewPager.setCurrentItem(item);
            int tabCount = this.mTabLayout.getChildCount();
            for (int i = 0; i < tabCount; ++i) {
                View child = this.mTabLayout.getChildAt(i);
                boolean isSelected = i == item;
                child.setSelected(isSelected);
                if (!isSelected) continue;
                this.animateToTab(item);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setCurrentItem", ex);
        }
    }

    @Override
    public void setOnPageChangeListener(AniwaysDirectionalViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    private class TextTabView
    extends TextView
    implements TabView {
        private int mIndex;
        private static final String TAG = "AniwaysTextTabView";

        public TextTabView(Context context) {
            super((Context)new ContextThemeWrapper(context, R.style.Aniways_StyledIndicators), null, R.attr.aniways_vpiTextTabPageIndicatorStyle);
        }

        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            try {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                if (TabPageIndicator.this.mMaxTabWidth > 0 && this.getMeasuredWidth() > TabPageIndicator.this.mMaxTabWidth) {
                    super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)TabPageIndicator.this.mMaxTabWidth, (int)0x40000000), heightMeasureSpec);
                }
            }
            catch (Throwable ex) {
                Log.e(true, TAG, "Caught Exception in onMeasure", ex);
            }
        }

        @Override
        public int getIndex() {
            return this.mIndex;
        }
    }

    private class ImageTabView
    extends ImageView
    implements TabView {
        private int mIndex;
        private static final String TAG = "AniwaysImageTabView";

        public ImageTabView(Context context) {
            super((Context)new ContextThemeWrapper(context, R.style.Aniways_StyledIndicators), null, R.attr.aniways_vpiImageTabPageIndicatorStyle);
        }

        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            try {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                if (TabPageIndicator.this.mMaxTabWidth > 0 && this.getMeasuredWidth() > TabPageIndicator.this.mMaxTabWidth) {
                    super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)TabPageIndicator.this.mMaxTabWidth, (int)0x40000000), heightMeasureSpec);
                }
            }
            catch (Throwable ex) {
                Log.e(true, TAG, "Caught Exception in onMeasure", ex);
            }
        }

        @Override
        public int getIndex() {
            return this.mIndex;
        }
    }

    private static interface TabView {
        public int getIndex();
    }
}

