/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service.task;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.Settings;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.info.Location;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Installation;
import com.aniways.service.helper.KeywordsHelper;
import com.aniways.service.utils.AniwaysServiceUtils;
import com.aniways.service.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONException;
import org.json.JSONObject;

public class DownloadJSONFileTask
extends AsyncTask<Void, Void, Map<String, Object>> {
    private static final String TAG = "AniwaysDownloadJSONFileTask";
    private static final String JSON_VERSION_KEY = "version";
    public static final String STATUS_KEY = "status";
    public static final String NEED_TO_UPDATE_KEY = "need_to_upadte";
    public static final String VERSION_KEY = "version";
    public static final String ETAG_KEY = "etag";
    public static final String ANDROID = "Android";
    private String mUrl;
    private String mDestFile;
    private String mCurrentVersion;
    private String mCurrentEtag;
    private String mNewEtag = "";
    private Context mContext;

    public DownloadJSONFileTask(Context context, String url, String destFileDir, String destFileName, String currentVersion, String currentEtag) throws IOException {
        this.mUrl = url;
        this.mDestFile = destFileDir + "/" + destFileName;
        this.mCurrentVersion = currentVersion;
        this.mCurrentEtag = currentEtag;
        this.mContext = context;
        File destDirFile = new File(destFileDir);
        if (!destDirFile.exists()) {
            if (!destDirFile.mkdirs()) {
                throw new IOException("Could not create dest dir for Json file: " + destDirFile.getAbsolutePath());
            }
            Log.i(TAG, "Created dest dir for json file: " + destDirFile.getAbsolutePath());
        }
    }

    protected Map<String, Object> doInBackground(Void ... params) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(STATUS_KEY, false);
        resultMap.put(NEED_TO_UPDATE_KEY, false);
        resultMap.put("version", this.mCurrentVersion);
        resultMap.put(ETAG_KEY, this.mCurrentEtag);
        try {
            String jsonString = null;
            try {
                jsonString = this.getJsonString();
            }
            catch (Exception ex) {
                Log.e(true, TAG, "Error downloading Json " + this.mUrl, ex);
                return resultMap;
            }
            if (jsonString == null) {
                Log.e(false, TAG, "Returning empty result map cause received a null Json string for Url: " + this.mUrl);
                return resultMap;
            }
            if (jsonString.equals("")) {
                Log.e(true, TAG, "Returning empty result map cause received an empty Json string for Url: " + this.mUrl);
                return resultMap;
            }
            if (jsonString.equals("304")) {
                Log.v(TAG, "Received empty response from server, so has the same version. Returning result that doesn't need update");
                resultMap.put(STATUS_KEY, true);
                return resultMap;
            }
            String newVersion = this.mCurrentVersion;
            try {
                JSONObject json = new JSONObject(jsonString);
                newVersion = json.getString("version");
                Log.v(TAG, "Comparing Json versions. Existing: " + this.mCurrentVersion + ". New: " + newVersion);
                if (newVersion.equals(this.mCurrentVersion)) {
                    resultMap.put(STATUS_KEY, true);
                    Log.i(TAG, "Downloaded Json with current version so returning result map saying no need to update.  Json Url: " + this.mUrl);
                    return resultMap;
                }
                Log.v(TAG, "Versions not the same, so need to update");
            }
            catch (JSONException e) {
                Log.w(true, TAG, "Bad Json string " + jsonString, e);
                return resultMap;
            }
            if (FileUtils.saveDataToFile(new File(this.mDestFile), jsonString)) {
                resultMap.put(STATUS_KEY, true);
                resultMap.put(NEED_TO_UPDATE_KEY, true);
                resultMap.put("version", newVersion);
                resultMap.put(ETAG_KEY, this.mNewEtag);
                Log.i(TAG, "Saved Json from Url: " + this.mUrl + " to file: " + this.mDestFile);
                return resultMap;
            }
            Log.e(false, TAG, "Save Json failed from Url: " + this.mUrl + " to file: " + this.mDestFile);
            return resultMap;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Encountered and unexpected error while downloading a Json file: " + this.mUrl + " to location on device: " + this.mDestFile, ex);
            return resultMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private String getJsonString() {
        int numOfRetries = 1;
        String jsonString = null;
        String userAgent = this.createUserAgentString();
        HttpRequestPreperationParams preperationParams = new HttpRequestPreperationParams(userAgent, 0, false);
        while (10 >= numOfRetries) {
            String responseParams;
            try {
                Log.i(TAG, "Downloading JSON file: " + this.mUrl + ". Retry number: " + numOfRetries + " out of possible " + 10);
                long startTime = System.currentTimeMillis();
                preperationParams = new HttpRequestPreperationParams(userAgent, numOfRetries, preperationParams.encounteredErrorCreatingZipStream);
                if (Utils.isAndroidVersionAtLeast(9)) {
                    this.performHttpUrlRequest(preperationParams);
                } else {
                    this.performHttpClientRequest(preperationParams);
                }
                responseParams = this.createResponseParamsString(preperationParams);
                Log.v(TAG, "Response: " + responseParams);
                if (preperationParams.responseCode == 304) {
                    Log.i(TAG, "Received 304 from server");
                    jsonString = "304";
                    break;
                }
                if (preperationParams.responseCode != 200) {
                    throw new IOException("Received response code which is not 200. params are: " + responseParams);
                }
                jsonString = this.getJsonString(preperationParams.deflatedInputream, preperationParams.responseCharset);
                if (jsonString.equals("")) {
                    throw new IOException("Received empty Json string: " + jsonString + ". Response params: " + responseParams);
                }
                this.mNewEtag = preperationParams.responseEtag == null ? "" : preperationParams.responseEtag;
                AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Statistical, startTime, "Performance", "Download Json and Read Response Time", String.valueOf(jsonString.length()), TAG, "number of chars");
                break;
            }
            catch (MalformedURLException e) {
                Log.e(numOfRetries == 10, TAG, "Malformed URL: " + this.mUrl + " Retry number: " + numOfRetries + " out of: " + 10, e);
            }
            catch (ProtocolException e) {
                Log.e(numOfRetries == 10, TAG, "Protocol Exception for url: " + this.mUrl + " Retry number: " + numOfRetries + " out of: " + 10, e);
            }
            catch (IOException e) {
                String networkInterface = Utils.isInternetAvailable(this.mContext);
                if (networkInterface != null) {
                    responseParams = this.createResponseParamsString(preperationParams);
                    Log.w(numOfRetries == 10, TAG, "IO Exception on URL " + this.mUrl + " Retry number: " + numOfRetries + " out of: " + 10 + " Network interface: " + networkInterface + "Response params: " + responseParams, e);
                } else {
                    Log.w(false, TAG, "IO Exception, but there is no internet connection, so that's expected. URL: " + this.mUrl + " Retry number: " + numOfRetries + " out of: " + 10, e);
                }
            }
            catch (IllegalArgumentException e) {
                Log.e(true, TAG, "Illegal arg Exception on URL " + this.mUrl + " Retry number: " + numOfRetries + " out of: " + 10, e);
            }
            finally {
                if (preperationParams.deflatedInputream != null) {
                    try {
                        preperationParams.deflatedInputream.close();
                    }
                    catch (IOException e) {
                        Log.e(true, TAG, "Error while closing the deflated input string. is content zipped = " + preperationParams.isContentGziped, e);
                    }
                }
                if (preperationParams.isContentGziped && preperationParams.inputStream != null) {
                    try {
                        preperationParams.inputStream.close();
                    }
                    catch (IOException e) {
                        Log.e(true, TAG, "Error while closing the input string. is content zipped = " + preperationParams.isContentGziped, e);
                    }
                }
                if (preperationParams.httpClient != null && preperationParams.httpClient instanceof AndroidHttpClient) {
                    ((AndroidHttpClient)preperationParams.httpClient).close();
                }
                if (preperationParams.urlConnection != null) {
                    try {
                        preperationParams.urlConnection.disconnect();
                    }
                    catch (Throwable e) {
                        Log.e(true, TAG, "Error while disconnection HttpUrlConnection", e);
                    }
                }
            }
            ++numOfRetries;
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException e) {
                Log.w(true, TAG, "Thread interrupted while waiting for next retry downloading Json: " + this.mUrl, e);
            }
        }
        return jsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performHttpUrlRequest(HttpRequestPreperationParams preperationParams) throws IOException {
        block19: {
            HttpURLConnection urlConnection;
            System.setProperty("http.keepAlive", "false");
            preperationParams.urlConnection = urlConnection = (HttpURLConnection)new URL(this.mUrl).openConnection();
            urlConnection.setRequestProperty("Accept-Charset", preperationParams.requestCharset.displayName(Locale.US));
            if (this.shouldRequestNonZippedContent(preperationParams.retryNumber, preperationParams.encounteredErrorCreatingZipStream)) {
                urlConnection.setRequestProperty("Accept-Encoding", "");
            }
            urlConnection.setRequestProperty("User-Agent", preperationParams.userAgent);
            if (this.mCurrentEtag.length() > 0) {
                urlConnection.setRequestProperty("If-None-Match", this.mCurrentEtag);
            }
            urlConnection.setRequestProperty("Cache-Control", "max-age=0, no-cache, no-store");
            urlConnection.setRequestProperty("Pragma", "no-cache");
            urlConnection.setReadTimeout(15000);
            urlConnection.setConnectTimeout(15000);
            HttpURLConnection.setFollowRedirects(true);
            System.setProperty("http.keepAlive", "false");
            try {
                long startTime = System.currentTimeMillis();
                urlConnection.connect();
                preperationParams.responseCode = urlConnection.getResponseCode();
                if (preperationParams.responseCode != 200) break block19;
                try {
                    preperationParams.deflatedInputream = urlConnection.getInputStream();
                    String contentLengthString = "-1";
                    try {
                        contentLengthString = String.valueOf(urlConnection.getContentLength());
                    }
                    catch (Throwable ex) {
                        Log.i(TAG, "Caught Exception while getting entity for logging: " + ex.getStackTrace());
                    }
                    AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Statistical, startTime, "Performance", "Download Json Time", contentLengthString, TAG, "number of chars");
                }
                catch (IOException ex) {
                    preperationParams.encounteredErrorCreatingZipStream = true;
                    throw ex;
                }
            }
            finally {
                try {
                    if (urlConnection.getHeaderFields() != null && urlConnection.getHeaderFields().entrySet() != null) {
                        StringBuilder responseHeadersSb = new StringBuilder();
                        for (Map.Entry<String, List<String>> header : urlConnection.getHeaderFields().entrySet()) {
                            responseHeadersSb.append("\n" + header.getKey() + ":" + header.getValue());
                        }
                        preperationParams.responseHeaders = responseHeadersSb.toString();
                    }
                    preperationParams.responseStatusLine = urlConnection.getHeaderField(0);
                    preperationParams.contentEncoding = urlConnection.getContentEncoding();
                    preperationParams.contentType = urlConnection.getContentType();
                    preperationParams.responseContentLength = urlConnection.getContentLength();
                    this.populateResponseCharset(preperationParams);
                    this.populateIsContentGzipped(preperationParams);
                    preperationParams.responseEtag = urlConnection.getHeaderField("ETag");
                }
                catch (Throwable ex) {
                    Log.e(true, TAG, "Error while getting response params", ex);
                }
                try {
                    InputStream errorStream = urlConnection.getErrorStream();
                    this.populateResponseError(preperationParams, errorStream);
                }
                catch (Throwable ex) {
                    Log.e(true, TAG, "Error while getting response error", ex);
                }
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void performHttpClientRequest(HttpRequestPreperationParams preperationParams) throws IllegalStateException, IOException {
        AndroidHttpClient httpClient = null;
        if (Utils.isAndroidVersionAtLeast(8)) {
            httpClient = AndroidHttpClient.newInstance((String)preperationParams.userAgent);
        } else {
            httpClient = new DefaultHttpClient();
            HttpProtocolParams.setUserAgent((HttpParams)httpClient.getParams(), (String)preperationParams.userAgent);
        }
        ConnManagerParams.setTimeout((HttpParams)httpClient.getParams(), (long)15000L);
        HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)15000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)15000);
        HttpClientParams.setRedirecting((HttpParams)httpClient.getParams(), (boolean)true);
        preperationParams.httpClient = httpClient;
        System.setProperty("http.keepAlive", "false");
        HttpGet request = new HttpGet(this.mUrl);
        if (this.shouldRequestNonZippedContent(preperationParams.retryNumber, preperationParams.encounteredErrorCreatingZipStream)) {
            request.removeHeaders("Accept-Encoding");
            Log.w(true, TAG, "Requesting non zipped content. Retry number: " + preperationParams.retryNumber);
        } else if (Utils.isAndroidVersionAtLeast(8)) {
            AndroidHttpClient.modifyRequestToAcceptGzipResponse((HttpRequest)request);
        } else {
            request.setHeader("Accept-Encoding", "gzip");
        }
        request.setHeader("Accept-Charset", preperationParams.requestCharset.displayName(Locale.US));
        if (this.mCurrentEtag.length() > 0) {
            request.setHeader("If-None-Match", this.mCurrentEtag);
        }
        request.setHeader("Cache-Control", "max-age=0, no-cache, no-store");
        request.setHeader("Pragma", "no-cache");
        if (Utils.isAndroidVersionAtLeast(11)) {
            throw new IOException("Using apache client for API version >= 9");
        }
        this.workAroundReverseDnsBugInHoneycombAndEarlier((HttpClient)httpClient);
        long startTime = System.currentTimeMillis();
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        String contentLengthString = "-1";
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                contentLengthString = String.valueOf(entity.getContentLength());
            }
        }
        catch (Throwable ex) {
            Log.i(TAG, "Caught Exception while getting entity for logging: " + ex.getStackTrace());
        }
        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Statistical, startTime, "Performance", "Download Json Time", contentLengthString, TAG, "number of chars");
        Header contentEncoding = response.getFirstHeader("Content-Encoding");
        if (contentEncoding != null) {
            preperationParams.contentEncoding = contentEncoding.getValue();
        }
        this.populateIsContentGzipped(preperationParams);
        StatusLine line = response.getStatusLine();
        if (line != null) {
            preperationParams.responseStatusLine = String.format(Locale.US, "%s %d %s", line.getProtocolVersion() == null ? "null" : line.getProtocolVersion().getProtocol(), line.getStatusCode(), line.getReasonPhrase());
        }
        preperationParams.responseCode = response.getStatusLine() == null ? -1 : response.getStatusLine().getStatusCode();
        Header contentType = response.getFirstHeader("Content-Type");
        if (contentType != null) {
            preperationParams.contentType = contentType.getValue();
        }
        Header etag = response.getFirstHeader("ETag");
        if (contentType != null) {
            preperationParams.responseEtag = etag.getValue();
        }
        this.populateResponseCharset(preperationParams);
        Header[] headers = response.getAllHeaders();
        StringBuilder responseHeadersSb = new StringBuilder();
        if (headers != null && headers.length > 0) {
            for (Header i : headers) {
                responseHeadersSb.append("\n" + i.getName() + ":" + i.getValue());
            }
        }
        preperationParams.responseHeaders = responseHeadersSb.toString();
        if (preperationParams.responseCode == 200) {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                Log.w(false, TAG, "Null entity");
                throw new IllegalArgumentException("Null entity");
            }
            preperationParams.responseContentLength = entity.getContentLength();
            preperationParams.deflatedInputream = preperationParams.inputStream = entity.getContent();
            if (preperationParams.isContentGziped) {
                try {
                    preperationParams.deflatedInputream = new GZIPInputStream(preperationParams.inputStream, 1024);
                }
                catch (IOException e) {
                    preperationParams.encounteredErrorCreatingZipStream = true;
                    throw e;
                }
            }
        }
    }

    private boolean shouldRequestNonZippedContent(int retryNumber, boolean encounteredErrorCreatingZipStream) {
        return encounteredErrorCreatingZipStream && retryNumber % 3 == 0;
    }

    private void populateIsContentGzipped(HttpRequestPreperationParams preperationParams) {
        if (preperationParams.contentEncoding != null && preperationParams.contentEncoding.equalsIgnoreCase("gzip")) {
            preperationParams.isContentGziped = true;
        }
    }

    private void populateResponseCharset(HttpRequestPreperationParams preperationParams) {
        if (preperationParams.contentType != null) {
            for (String param : preperationParams.contentType.replace(" ", "").split(";")) {
                if (!param.startsWith("charset=")) continue;
                try {
                    String charsetName = param.split("=", 2)[1];
                    if (!Charset.isSupported(charsetName)) break;
                    preperationParams.responseCharset = Charset.forName(charsetName);
                }
                catch (Throwable ex) {
                    Log.w(true, TAG, "Could not parse charset from: " + preperationParams.contentType, ex);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void populateResponseError(HttpRequestPreperationParams preperationParams, InputStream responseErrorStream) {
        try {
            if (responseErrorStream != null) {
                byte[] response = this.readFully(responseErrorStream);
                String errorString = "";
                errorString = Utils.isAndroidVersionAtLeast(9) ? new String(response, preperationParams.responseCharset) : new String(response, preperationParams.responseCharset.displayName(Locale.US));
                preperationParams.responseError = errorString;
            }
        }
        catch (Throwable ex) {
            Log.w(true, TAG, "Error while reading response error stream", ex);
        }
        finally {
            try {
                if (responseErrorStream != null) {
                    responseErrorStream.close();
                }
            }
            catch (Throwable e) {
                Log.e(true, TAG, "Error while colsing response error stream", e);
            }
        }
    }

    private String createResponseParamsString(HttpRequestPreperationParams preperationParams) {
        String responseParams = String.format(Locale.US, "\nResponse statusLine: %s, is content Gzipped: %s, Response content length: %s, Response ETag: %s, Response error: %s, response headers: %s", preperationParams.responseStatusLine, preperationParams.isContentGziped, preperationParams.responseContentLength, preperationParams.responseEtag, preperationParams.responseError, preperationParams.responseHeaders);
        return responseParams;
    }

    private String createUserAgentString() {
        Context context = this.mContext;
        PackageInfo pi = null;
        try {
            pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(true, TAG, "Package name doesn't exist");
        }
        String userId = "unknown";
        String deviceInfo = "Device: " + Build.MANUFACTURER + " " + Build.MODEL + " " + Build.VERSION.RELEASE + " (api level " + Build.VERSION.SDK_INT + ")";
        String android_id = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        long appInstallTime = AniwaysServiceUtils.getAppInstallTime(context, System.currentTimeMillis());
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(appInstallTime);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        String installDateString = dateTimeFormat.format(calendar.getTime());
        Location location = new Location();
        EasyJSONObject locationJson = location.get(this.mContext);
        String locationString = String.format(Locale.US, "latitude=%s;longitude=%s;speed=%s;countryCode=%s;countryName=%s;state=%s;county=%s;city=%s;neighborhood=%s;landmark=%s", locationJson == null ? "unknown" : locationJson.getString("latitude", "unknown"), locationJson == null ? "unknown" : locationJson.getString("longitude", "unknown"), locationJson == null ? "unknown" : locationJson.getString("speed", "unknown"), locationJson == null ? "unknown" : locationJson.getString("countryCode", "unknown"), locationJson == null ? "unknown" : locationJson.getString("country", "unknown"), locationJson == null ? "unknown" : locationJson.getString("state", "unknown"), locationJson == null ? "unknown" : locationJson.getString("county", "unknown"), locationJson == null ? "unknown" : locationJson.getString("city", "unknown"), locationJson == null ? "unknown" : locationJson.getString("neighborhood", "unknown"), locationJson == null ? "unknown" : locationJson.getString("landmark", "unknown"));
        String userAgent = String.format(Locale.US, "appName=%s;appVersion=%d;appVersionName=%s;configVersion=%s;configVersionName=%s;deviceName=%s;osName=%s;osVersion=%s;language=%s;appId=%s;keywordsVersion=%s;screenRatio=%s;sdkVersion=%s;installationId=%s;deviceId=%s;userId=%s;installDate=%s;%s;end=end", pi == null ? "Unknown" : pi.packageName, pi == null ? 0 : pi.versionCode, pi == null ? "Unknown" : pi.versionName, AniwaysPrivateConfig.getInstance().version, AniwaysPrivateConfig.getInstance().versionName, deviceInfo, ANDROID, String.valueOf(Build.VERSION.SDK_INT), Locale.getDefault().getDisplayLanguage() + "-" + Locale.getDefault().getLanguage(), AniwaysPrivateConfig.getInstance().appId, KeywordsHelper.getInstance().getKeywordsVersion(context), String.valueOf(context.getResources().getDisplayMetrics().densityDpi), "2.3.08", Installation.id(context), android_id == null ? "Unknown" : android_id, userId, installDateString, locationString);
        return userAgent;
    }

    @SuppressLint(value={"NewApi"})
    private String getJsonString(InputStream is, Charset charset) throws IOException {
        byte[] response = this.readFully(is);
        if (Utils.isAndroidVersionAtLeast(9)) {
            return new String(response, charset);
        }
        return new String(response, charset.displayName(Locale.US));
    }

    private byte[] readFully(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        return out.toByteArray();
    }

    private void workAroundReverseDnsBugInHoneycombAndEarlier(HttpClient client) {
        LayeredSocketFactory socketFactory = new LayeredSocketFactory(){
            SSLSocketFactory delegate = SSLSocketFactory.getSocketFactory();

            public Socket createSocket() throws IOException {
                return this.delegate.createSocket();
            }

            public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
                return this.delegate.connectSocket(sock, host, port, localAddress, localPort, params);
            }

            public boolean isSecure(Socket sock) throws IllegalArgumentException {
                return this.delegate.isSecure(sock);
            }

            public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
                this.injectHostname(socket, host);
                return this.delegate.createSocket(socket, host, port, autoClose);
            }

            private void injectHostname(Socket socket, String host) {
                try {
                    Field field = InetAddress.class.getDeclaredField("hostName");
                    field.setAccessible(true);
                    field.set(socket.getInetAddress(), host);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)socketFactory, 443));
    }

    private class HttpRequestPreperationParams {
        public HttpClient httpClient = null;
        public String responseHeaders = null;
        public long responseContentLength = -1L;
        public boolean isContentGziped = false;
        public String responseStatusLine = null;
        public InputStream inputStream = null;
        public InputStream deflatedInputream = null;
        public HttpURLConnection urlConnection = null;
        public String contentType = null;
        public int responseCode = -1;
        public String contentEncoding = null;
        public Charset responseCharset = Charset.defaultCharset();
        public Charset requestCharset = Charset.defaultCharset();
        public String userAgent;
        public String responseError = null;
        public boolean encounteredErrorCreatingZipStream = false;
        public int retryNumber = 0;
        public String responseEtag = null;

        public HttpRequestPreperationParams(String userAgent, int retryNumber, boolean encounteredErrorCreatingZipStream) {
            this.userAgent = userAgent;
            this.retryNumber = retryNumber;
            this.encounteredErrorCreatingZipStream = encounteredErrorCreatingZipStream;
        }
    }
}

